<section class="siaracorporatebusiness-section-aboutus-wrapper">

    <div class="uf-wrapper">
        <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-12 image">

            <?php
                $about_us_image_url = get_theme_mod( 'aboutus_image' );
                $default_about_us_image_url = get_template_directory_uri() . '/assets/images/placeholder.png';

                // Check if the Customizer setting has a valid image URL.
                // If not, fall back to the predefined default image.
                $display_image_url = ! empty( $about_us_image_url ) ? esc_url( $about_us_image_url ) : esc_url( $default_about_us_image_url );

                // You might also want an alt text for accessibility.
                // This could be another Customizer setting, or a static text.
                $about_us_alt_text = get_theme_mod( 'aboutus_image_alt_text', __( 'About Us Section Image', 'siara-corporate-business' ) );

            ?>

            <div class="img">
                <img src="<?php echo $display_image_url; ?>" alt="<?php echo esc_attr( $about_us_alt_text ); ?>">
            </div>
            <div class="reviewbox">
                <div class="google-info">
                    <?php
                        $google_review_logo = get_template_directory_uri() . '/assets/images/googlereviewimage.png';
                    ?>
                    <div class="google-logo">
                    <img src="<?php echo $google_review_logo; ?>" alt="<?php esc_attr_e( 'Google Reviewed', 'siara-corporate-business' ); ?>">

                    </div>
                    <p><?php esc_html_e( 'Google Reviewed By', 'siara-corporate-business' ); ?></p>
                </div>
                <div class="google-reviews">
                    <?php
                        $aboutus_reviewnum  = get_theme_mod( 'aboutus_reviewnum','4.8' );
                        $aboutus_reviewnumtext  = get_theme_mod( 'aboutus_reviewnumtext','6.8k Reviews' );
                    ?>
                    <div class="rating-info">
                        <span class="rating-digit">
                            <?php echo esc_html( $aboutus_reviewnum ); ?>
                        </span>
                        <div class="stars">
                            <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
                            <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
                            <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
                            <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
                            <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
                            <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
                        </svg>
                        </div>
                    </div>
                    <span class="total-reviews"><?php echo esc_html( $aboutus_reviewnumtext ); ?></span>
                </div>
            </div>
            
        </div>

        <div class="col-lg-6 col-md-6 col-sm-12 content">
            <div class="about--content">
                <?php
                    $aboutus_subtitle_text  = get_theme_mod( 'aboutus_subtitle_text','About Us' );
                    $aboutus_title_text  = get_theme_mod( 'aboutus_title_text','Experts In Business, Promote' );
                    $aboutus_growthnum  = get_theme_mod( 'aboutus_growthnum','4.5K' );
                    $aboutus_growthtext  = get_theme_mod( 'aboutus_growthtext','Suffered Alteration In Some Look Even' );
                    $aboutus_description_text  = get_theme_mod( 'aboutus_description_text','There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some look even slightly believable.' );
                    $aboutus_list1_text  = get_theme_mod( 'aboutus_list1_text','Lorem Ipsum Available' );
                    $aboutus_list2_text  = get_theme_mod( 'aboutus_list2_text','Lorem Ipsum Available, But The Majority' );
                    $aboutus_button_text  = get_theme_mod( 'aboutus_button_text','Get Stared' );
                    $aboutus_button_link  = get_theme_mod( 'aboutus_button_link','#' );
                ?>
                <div class="heading">
                    <h3>
                        <?php echo esc_html( $aboutus_subtitle_text ); ?>
                    </h3>
                    <h2>
                        <?php echo esc_html( $aboutus_title_text ); ?>
                    </h2>
                </div>
                <div class="growth">
                    <div class="icon-wrapper">
                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="#ffffff" viewBox="0 0 256 256"><path d="M224,200h-8V40a8,8,0,0,0-8-8H152a8,8,0,0,0-8,8V80H96a8,8,0,0,0-8,8v40H48a8,8,0,0,0-8,8v64H32a8,8,0,0,0,0,16H224a8,8,0,0,0,0-16ZM160,48h40V200H160ZM104,96h40V200H104ZM56,144H88v56H56Z"></path></svg>
                    </div>
                    <div class="stats-details">
                        <h3><?php echo esc_html( $aboutus_growthnum ); ?></h3>      
                        <p><?php echo esc_html( $aboutus_growthtext ); ?></p>
                    </div>
                </div>
                <div class="description">
                    <p><?php echo esc_html( $aboutus_description_text ); ?></p>
                </div>  
                <div class="lists">
                    <p><?php echo esc_html( $aboutus_list1_text ); ?></p>
                    <p><?php echo esc_html( $aboutus_list2_text ); ?></p>
                </div>
                <div class="button">
                    <a href="<?php echo esc_html( $aboutus_button_link ); ?>">
                        <?php echo esc_html( $aboutus_button_text ); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    </div>

</section>