<?php


// Topbar Search.
if ( ! function_exists( 'siaracorporatebusiness_topbar_search' ) ) :
	function siaracorporatebusiness_topbar_search() {
			?>
			<div class="siaracorporatebusiness-search-toggle">
				<button class="siaracorporatebusiness-search-canvas-btn siaracorporatebusiness-search search-icon toggle-search-block toggle" aria-label="<?php esc_attr_e( 'Search', 'siara-corporate-business' ); ?>" aria-expanded="false" data-block=".siaracorporatebusiness-search-block" data-body-class="showing-search-block" data-focus=".siaracorporatebusiness-search-form .search-field">
					<span class="search-label"><?php esc_html_e( 'Search', 'siara-corporate-business' ); ?></span>
					<?php siaracorporatebusiness_the_theme_svg( 'search' ); ?>
					<?php siaracorporatebusiness_the_theme_svg( 'cross' ); ?>
				</button>
				<div class="siaracorporatebusiness-search-form siaracorporatebusiness-canvas-modal">
					<div class="em-search-form-inner">
						<?php
						get_search_form(
							array(
								'aria_label' => __( 'Search for:', 'siara-corporate-business' ),
							)
						);
						?>
					</div>
				</div>
			</div>
			<?php
	}
endif;
add_action( 'siaracorporatebusiness_topbar_last_col_items', 'siaracorporatebusiness_topbar_search', 30 );

// Primary Menu Bar Offcanvas Icon.
if ( ! function_exists( 'siaracorporatebusiness_primary_bar_offcanvas' ) ) :
	function siaracorporatebusiness_primary_bar_offcanvas() {
		$class = '';
		if ( get_theme_mod( 'offcanvas_hide_desktop', true ) ) {
			$class .= ' hide-on-desktop';
		}
		?>
		<div class="siaracorporatebusiness-offcanvas-toggle<?php echo esc_attr( $class ); ?>">
			<button class="siaracorporatebusiness-off-canvas-btn toggle toggle-off-canvas toggle-canvas-modal" data-modal=".siaracorporatebusiness-canvas-block" data-body-class="showing-offcanvas-modal" data-focus=".siaracorporatebusiness-off-canvas-close" aria-expanded="false">
				<span class="off-canvas-bars">
					<span class="bar-one"></span>
					<span class="bar-two"></span>
					<span class="bar-three"></span>
				</span>
				<span class="toggle-text screen-reader-text">
					<?php esc_html_e( 'Off Canvas', 'siara-corporate-business' ); ?>
				</span>
			</button>
		</div>
		<?php
	}
endif;
add_action( 'siaracorporatebusiness_primary_nav_items', 'siaracorporatebusiness_primary_bar_offcanvas', 10 );

// Primary Menu Bar Menu.
if ( ! function_exists( 'siaracorporatebusiness_primary_bar_menu' ) ) :
	function siaracorporatebusiness_primary_bar_menu() {
		
		?>
		<div id="site-navigation" class="main-navigation siaracorporatebusiness-primary-nav">
			
			<?php
			if ( has_nav_menu( 'primary-menu' ) ) :

				?>
				<nav class="primary-menu-wrapper" aria-label="<?php echo esc_attr_x( 'Primary', 'menu', 'siara-corporate-business' ); ?>">
					<ul class="primary-menu reset-list-style">
					<?php
					wp_nav_menu(
						array(
							'container'      => '',
							'items_wrap'     => '%3$s',
							'theme_location' => 'primary-menu',
						)
					);
					?>
					</ul>
				</nav><!-- .primary-menu-wrapper -->
			<?php endif; ?>
		</div>
		<?php
	}
endif;
add_action( 'siaracorporatebusiness_primary_nav_items', 'siaracorporatebusiness_primary_bar_menu', 20 );


// Primary Menu Bar Search Icon.
if ( ! function_exists( 'siaracorporatebusiness_primary_bar_search' ) ) :
	function siaracorporatebusiness_primary_bar_search() {
			?>
			<div class="siaracorporatebusiness-search-toggle">
				<button class="siaracorporatebusiness-search-canvas-btn siaracorporatebusiness-search search-icon toggle-search-block toggle" aria-label="<?php esc_attr_e( 'Search', 'siara-corporate-business' ); ?>" aria-expanded="false" data-block=".siaracorporatebusiness-search-block" data-body-class="showing-search-block" data-focus=".siaracorporatebusiness-search-form .search-field">
					<span class="search-label"><?php esc_html_e( 'Search', 'siara-corporate-business' ); ?></span>
					<?php siaracorporatebusiness_the_theme_svg( 'search' ); ?>
					<?php siaracorporatebusiness_the_theme_svg( 'cross' ); ?>
				</button>
				<div class="siaracorporatebusiness-search-form siaracorporatebusiness-canvas-modal">
					<div class="em-search-form-inner">
						<?php
						get_search_form(
							array(
								'aria_label' => __( 'Search for:', 'siara-corporate-business' ),
							)
						);
						?>
					</div>
				</div>
			</div>
			<?php
	}
endif;
add_action( 'siaracorporatebusiness_secondary_nav_items', 'siaracorporatebusiness_primary_bar_search', 30 );
