<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Siaracorporatebusiness_Social_Menu extends Siaracorporatebusiness_Widget_Base {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->widget_cssclass    = 'widget_siaracorporatebusiness_social_menu';
		$this->widget_description = __( 'Displays social menu if you have set it.', 'siara-corporate-business' );
		$this->widget_id          = 'siaracorporatebusiness_social_menu';
		$this->widget_name        = __( 'Siaracorporatebusiness: Social Menu', 'siara-corporate-business' );
		$this->settings           = array(
			'title'      => array(
				'type'  => 'text',
				'label' => __( 'Title', 'siara-corporate-business' ),
			),
			'color'      => array(
				'type'    => 'select',
				'label'   => __( 'Social Links Color', 'siara-corporate-business' ),
				'options' => array(
					'theme_color' => __( 'Use Theme Color', 'siara-corporate-business' ),
					'brand_color' => __( 'Use Brand Color', 'siara-corporate-business' ),
				),
				'std'     => 'theme_color',
			),
			'style'      => array(
				'type'    => 'select',
				'label'   => __( 'Style', 'siara-corporate-business' ),
				'options' => siaracorporatebusiness_get_social_links_styles(),
				'std'     => 'style_1',
			),
			'show_label' => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Label', 'siara-corporate-business' ),
				'std'   => false,
			),
			'column'     => array(
				'type'    => 'select',
				'label'   => __( 'Column', 'siara-corporate-business' ),
				'desc'    => __( 'Will only work when label is enabled from above and there is enough space to display the columns.', 'siara-corporate-business' ),
				'options' => array(
					'one'   => __( 'One', 'siara-corporate-business' ),
					'two'   => __( 'Two', 'siara-corporate-business' ),
					'three' => __( 'Three', 'siara-corporate-business' ),
				),
				'std'     => 'two',
			),
			'align'      => array(
				'type'    => 'select',
				'label'   => __( 'Alignment', 'siara-corporate-business' ),
				'options' => array(
					'left'   => __( 'Left', 'siara-corporate-business' ),
					'center' => __( 'Center', 'siara-corporate-business' ),
					'right'  => __( 'Right', 'siara-corporate-business' ),
				),
				'std'     => 'left',
			),
			'inverted_block_color'      => array(
				'type'  => 'checkbox',
				'label' => __( 'Inverted Color', 'siara-corporate-business' ),
				'desc'  => __( 'Can be used if you have dark background and some social brands color are also dark', 'siara-corporate-business' ),
				'std'   => false,
			),
		);

		parent::__construct();

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		ob_start();

		$this->widget_start( $args, $instance );

		do_action( 'siaracorporatebusiness_before_social_menu' );

		$wrapper_class = isset( $instance['align'] ) ? $instance['align'] : $this->settings['align']['std'];

		$inverted_block_color = isset( $instance['inverted_block_color'] ) ? $instance['inverted_block_color'] : $this->settings['inverted_block_color']['std'];
		// Inverted Color.
		if ( $inverted_block_color ) {
			$wrapper_class .= ' saga-block-inverted-color';
		}
		
		?>
		<div class="siaracorporatebusiness-social-menu-widget menu-align-<?php echo esc_attr( $wrapper_class ); ?>">
			<?php

			if ( has_nav_menu( 'social-menu' ) ) {

				$social_link_class  = ' reset-list-style siaracorporatebusiness-social-icons ';
				$social_link_style  = isset( $instance['style'] ) ? $instance['style'] : $this->settings['style']['std'];
				$social_link_style .= siaracorporatebusiness_get_social_icons_class( $social_link_style );
				$social_link_color  = isset( $instance['color'] ) ? $instance['color'] : $this->settings['color']['std'];

				$social_link_class .= $social_link_style . ' ' . $social_link_color;

				$label_class = 'screen-reader-text';
				$show_label  = isset( $instance['show_label'] ) ? $instance['show_label'] : $this->settings['show_label']['std'];
				if ( $show_label ) {
					$label_class        = 'em-social-menu-label';
					$social_link_class .= ' has-social-menu-label';
					$column             = isset( $instance['column'] ) ? $instance['column'] : $this->settings['column']['std'];
					$social_link_class .= ' em-flex-col-' . $column;
				}

				wp_nav_menu(
					array(
						'theme_location'  => 'social-menu',
						'container_class' => 'social-navigation',
						'fallback_cb'     => false,
						'depth'           => 1,
						'menu_class'      => $social_link_class,
						'link_before'     => '<span class="' . $label_class . '">',
						'link_after'      => '</span>',
					)
				);
			} else {
				esc_html_e( 'Social menu is not set. You need to create menu and assign it to Social Menu on Menu Settings.', 'siara-corporate-business' );
			}
			?>
		</div>
		<?php

		do_action( 'siaracorporatebusiness_after_social_menu' );

		$this->widget_end( $args );

		echo ob_get_clean();
	}

	public function enqueue_assets() {
		siaracorporatebusiness_widget_css( $this->id_base, 'social-menu' );
	}
}
