<?php
// Add Home Page slider Section.
$wp_customize->add_section(
	'home_slider_options',
	array(
		'title' => __( 'Slider Options', 'siara-corporate-business' ),
		'panel' => 'theme_home_option_panel',
	)
);

// Enable slider Section.
$wp_customize->add_setting(
	'enable_slider',
	array(
		'default'           => $theme_options_defaults['enable_slider'],
		'sanitize_callback' => 'siaracorporatebusiness_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Siaracorporatebusiness_Toggle_Control(
		$wp_customize,
		'enable_slider',
		array(
			'label'    => __( 'Enable Home Slider', 'siara-corporate-business' ),
			'section'  => 'home_slider_options',
			'priority' => 10,
		)
	)
);


// slider Page 1.
$wp_customize->add_setting(
    'slider_page1',
    array(
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Siaracorporatebusiness_Dropdown_Pages_Control( // Using your new Page control!
        $wp_customize,
        'slider_page1',
        array(
            'label'           => __( 'Choose a Slider Page 1', 'siara-corporate-business' ),
            'section'         => 'home_slider_options', // Ensure this matches your section ID
            'active_callback' => 'siaracorporatebusiness_is_slider_posts_enabled',
            'priority'        => 12,
        )
    )
);

// slider Page 2.
$wp_customize->add_setting(
    'slider_page2',
    array(
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Siaracorporatebusiness_Dropdown_Pages_Control( // Using your new Page control!
        $wp_customize,
        'slider_page2',
        array(
            'label'           => __( 'Choose a Slider Page 2', 'siara-corporate-business' ),
            'section'         => 'home_slider_options', // Ensure this matches your section ID
            'active_callback' => 'siaracorporatebusiness_is_slider_posts_enabled',
            'priority'        => 13,
        )
    )
);

// slider Page 3.
$wp_customize->add_setting(
    'slider_page3',
    array(
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Siaracorporatebusiness_Dropdown_Pages_Control( // Using your new Page control!
        $wp_customize,
        'slider_page3',
        array(
            'label'           => __( 'Choose a Slider Page 3', 'siara-corporate-business' ),
            'section'         => 'home_slider_options', // Ensure this matches your section ID
            'active_callback' => 'siaracorporatebusiness_is_slider_posts_enabled',
            'priority'        => 14,
        )
    )
);

// slider Page 4.
$wp_customize->add_setting(
    'slider_page4',
    array(
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Siaracorporatebusiness_Dropdown_Pages_Control( // Using your new Page control!
        $wp_customize,
        'slider_page4',
        array(
            'label'           => __( 'Choose a Slider Page 4', 'siara-corporate-business' ),
            'section'         => 'home_slider_options', // Ensure this matches your section ID
            'active_callback' => 'siaracorporatebusiness_is_slider_posts_enabled',
            'priority'        => 15,
        )
    )
);