<?php
/**
 * Custom Customizer Controls.
 *
 * @package Siaracorporatebusiness
 */

/**
 * Customize Control for upsell.
 *
 * @since 1.0.0
 *
 * @see WP_Customize_Control
 */
class Siaracorporatebusiness_Upsell extends WP_Customize_Control {

	/**
	 * Control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'upsell';

	/**
	 * Displays the control content.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function render_content() {
		?>
		<div>
			<div class="customize-control">
				<h3><?php esc_html_e( 'Need More Features?', 'siara-corporate-business' ); ?> <span>*</span></h3>
				<ul class="theme-features">
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'Premium Modules', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'Extended Typography Options', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'More Color Options', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'Beautiful Dark Mode', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'More Header Options', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'More Footer Options', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'More Blog Layouts', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'More Widget Options', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'Extended Post Formats', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-yes"></span><?php esc_html_e( 'Premium Support', 'siara-corporate-business' ); ?></li>
					<li><span class="dashicons dashicons-plus"></span><?php esc_html_e( 'Many More', 'siara-corporate-business' ); ?></li>
				</ul>
				<a href="" target="_blank" class="button upgrade-now"><?php esc_html_e( 'Upgrade Now', 'siara-corporate-business' ); ?></a>
			</div>
			<div class="customize-control">
				<h3><?php esc_html_e( 'Need Support?', 'siara-corporate-business' ); ?></h3>
				<p><?php esc_html_e( 'If you have any questions related to the theme, feel free to ask us.', 'siara-corporate-business' ); ?></p>
				<a href="" target="_blank" class="button button-primary"><?php esc_html_e( 'Contact Us', 'siara-corporate-business' ); ?></a>
			</div>
		</div>
		<?php
	}
}
