<?php
/**
 * Custom Customizer Controls.
 *
 * @package Siaracorporatebusiness
 */

/**
 * Customize Control for Page Select.
 *
 * @since 1.0.0
 *
 * @see WP_Customize_Control
 */
class Siaracorporatebusiness_Dropdown_Pages_Control extends WP_Customize_Control {

    /**
     * Control type.
     *
     * @access public
     * @var string
     */
    public $type = 'dropdown-pages'; // Changed type to indicate pages

    /**
     * Dropdown Arguments.
     *
     * @access protected
     * @var array
     */
    protected $dropdown_args = array(); // Kept for consistency, though wp_dropdown_pages has its own args

    /**
     * Constructor.
     *
     * @since 1.0.0
     *
     * @param WP_Customize_Manager $manager Customizer bootstrap instance.
     * @param string               $id      Control ID.
     * @param array                $args    Optional. Arguments to override class property defaults.
     */
    public function __construct( $manager, $id, $args = array() ) {
        // No need for taxonomy-specific checks here, as we're always dealing with pages.
        parent::__construct( $manager, $id, $args );
    }

    /**
     * Render content.
     *
     * @since 1.0.0
     */
    public function render_content() {
        ?>
        <label>
            <?php
            if ( ! empty( $this->label ) ) :
                ?>
                <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                <?php
            endif;

            if ( ! empty( $this->description ) ) :
                ?>
                <span class="description customize-control-description"><?php echo $this->description; ?></span>
                <?php
            endif;

            $dropdown_args = wp_parse_args(
                $this->dropdown_args, // Allows for additional arguments to be passed when instantiating the control
                array(
                    'selected'          => $this->value(),
                    'show_option_none'  => __( '&mdash; Select &mdash;', 'siara-corporate-business' ), // Option for no page selected
                    'sort_column'       => 'post_title', // Sort pages by title
                    'post_status'       => 'publish', // Only show published pages
                    'echo'              => false, // We'll echo it ourselves after modifying
                )
            );

            // Use wp_dropdown_pages() instead of wp_dropdown_categories()
            $dropdown = wp_dropdown_pages( $dropdown_args );

            // Add the Customizer link attributes to the select tag
            $dropdown = str_replace( '<select', '<select ' . $this->get_link(), $dropdown );
            echo $dropdown;
            ?>
        </label>
        <?php
    }
}