<?php 
/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function sen_business_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'sen-business' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

if ( ! function_exists( 'sen_business_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function sen_business_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'sen-business' ),
            'off'       => esc_html__( 'Disable', 'sen-business' )
        );
        return apply_filters( 'sen_business_switch_options', $arr );
    }
endif;

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function sen_business_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'sen-business' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}
if ( ! function_exists( 'sen_business_get_woo_product' ) ) {
    /**
     * Get product.
     */
    function sen_business_get_woo_product() {
        $args = array(
            'posts_per_page' => -1,
        );
         
        $choices = array( '' => esc_html__( '--Select--', 'sen-business' ) );
        $products = wc_get_products( $args );
        foreach ( $products as $product ) {
            $id = $product->get_id();
            $title = $product->get_name();
            $choices[ $id ] = $title;
        }
        return $choices;
    }
}




 /**
 * Get an array of google fonts.
 * 
 */
function sen_business_font_choices() {
    $font_family_arr = array();
    $font_family_arr[''] = esc_html__( '--Default--', 'sen-business' );

    // Make the request
    $request = wp_remote_get( get_theme_file_uri( 'assets/fonts/webfonts.json' ) );

    if( is_wp_error( $request ) ) {
        return false; // Bail early
    }
    // Retrieve the data
    $body = wp_remote_retrieve_body( $request );
    $data = json_decode( $body );
    if ( ! empty( $data ) ) {
        foreach ( $data->items as $items => $fonts ) {
            $family_str_arr = explode( ' ', $fonts->family );
            $family_value = implode( '-', array_map( 'strtolower', $family_str_arr ) );
            $font_family_arr[ $family_value ] = $fonts->family;
        }
    }

    return apply_filters( 'sen_business_font_choices', $font_family_arr );
}

if ( ! function_exists( 'sen_business_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'header-font-1'   => esc_html__( 'Raleway', 'sen-business' ),
            'header-font-2'   => esc_html__( 'Poppins', 'sen-business' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'sen-business' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'sen-business' ),
            'header-font-5'   => esc_html__( 'Lato', 'sen-business' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'header-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'header-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'header-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'sen-business' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'sen-business' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'sen-business' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'sen-business' ),
            'header-font-21'   => esc_html__( 'Courgette', 'sen-business' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'sen-business' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'sen-business' ),
            'header-font-24'   => esc_html__( 'Righteous', 'sen-business' ),
            'header-font-25'   => esc_html__( 'Dosis', 'sen-business' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-business' ),
            'header-font-27'   => esc_html__( 'Faster one', 'sen-business' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'sen-business' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'sen-business' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'sen-business' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_business_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'body-font-1'     => esc_html__( 'Raleway', 'sen-business' ),
            'body-font-2'     => esc_html__( 'Poppins', 'sen-business' ),
            'body-font-3'     => esc_html__( 'Roboto', 'sen-business' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'sen-business' ),
            'body-font-5'     => esc_html__( 'Lato', 'sen-business' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'body-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'body-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'body-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'sen-business' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'sen_business_archive_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_archive_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'header-font-1'   => esc_html__( 'Raleway', 'sen-business' ),
            'header-font-2'   => esc_html__( 'Poppins', 'sen-business' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'sen-business' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'sen-business' ),
            'header-font-5'   => esc_html__( 'Lato', 'sen-business' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'header-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'header-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'header-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'sen-business' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'sen-business' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'sen-business' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'sen-business' ),
            'header-font-21'   => esc_html__( 'Courgette', 'sen-business' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'sen-business' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'sen-business' ),
            'header-font-24'   => esc_html__( 'Righteous', 'sen-business' ),
            'header-font-25'   => esc_html__( 'Dosis', 'sen-business' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-business' ),
            'header-font-27'   => esc_html__( 'Faster one', 'sen-business' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'sen-business' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'sen-business' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'sen-business' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_archive_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_business_archive_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_archive_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'body-font-1'     => esc_html__( 'Raleway', 'sen-business' ),
            'body-font-2'     => esc_html__( 'Poppins', 'sen-business' ),
            'body-font-3'     => esc_html__( 'Roboto', 'sen-business' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'sen-business' ),
            'body-font-5'     => esc_html__( 'Lato', 'sen-business' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'body-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'body-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'body-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'sen-business' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_archive_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_business_page_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_page_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'header-font-1'   => esc_html__( 'Raleway', 'sen-business' ),
            'header-font-2'   => esc_html__( 'Poppins', 'sen-business' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'sen-business' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'sen-business' ),
            'header-font-5'   => esc_html__( 'Lato', 'sen-business' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'header-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'header-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'header-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'sen-business' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'sen-business' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'sen-business' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'sen-business' ),
            'header-font-21'   => esc_html__( 'Courgette', 'sen-business' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'sen-business' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'sen-business' ),
            'header-font-24'   => esc_html__( 'Righteous', 'sen-business' ),
            'header-font-25'   => esc_html__( 'Dosis', 'sen-business' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-business' ),
            'header-font-27'   => esc_html__( 'Faster one', 'sen-business' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'sen-business' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'sen-business' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'sen-business' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_page_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_business_page_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_page_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'body-font-1'     => esc_html__( 'Raleway', 'sen-business' ),
            'body-font-2'     => esc_html__( 'Poppins', 'sen-business' ),
            'body-font-3'     => esc_html__( 'Roboto', 'sen-business' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'sen-business' ),
            'body-font-5'     => esc_html__( 'Lato', 'sen-business' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'body-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'body-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'body-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'sen-business' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_page_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_business_post_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_post_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'header-font-1'   => esc_html__( 'Raleway', 'sen-business' ),
            'header-font-2'   => esc_html__( 'Poppins', 'sen-business' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'sen-business' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'sen-business' ),
            'header-font-5'   => esc_html__( 'Lato', 'sen-business' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'header-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'header-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'header-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'sen-business' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'sen-business' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'sen-business' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'sen-business' ),
            'header-font-21'   => esc_html__( 'Courgette', 'sen-business' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'sen-business' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'sen-business' ),
            'header-font-24'   => esc_html__( 'Righteous', 'sen-business' ),
            'header-font-25'   => esc_html__( 'Dosis', 'sen-business' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-business' ),
            'header-font-27'   => esc_html__( 'Faster one', 'sen-business' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'sen-business' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'sen-business' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'sen-business' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_post_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_business_post_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_post_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'body-font-1'     => esc_html__( 'Raleway', 'sen-business' ),
            'body-font-2'     => esc_html__( 'Poppins', 'sen-business' ),
            'body-font-3'     => esc_html__( 'Roboto', 'sen-business' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'sen-business' ),
            'body-font-5'     => esc_html__( 'Lato', 'sen-business' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'body-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'body-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'body-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'sen-business' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_post_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'sen_business_site_title_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_site_title_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'site-font-1'   => esc_html__( 'Raleway', 'sen-business' ),
            'site-font-2'   => esc_html__( 'Poppins', 'sen-business' ),
            'site-font-3'   => esc_html__( 'Montserrat', 'sen-business' ),
            'site-font-4'   => esc_html__( 'Open Sans', 'sen-business' ),
            'site-font-5'   => esc_html__( 'Lato', 'sen-business' ),
            'site-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'site-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'site-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'site-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'site-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'site-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'site-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'site-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'site-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'site-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'site-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'site-font-17'   => esc_html__( 'Henny Penny', 'sen-business' ),
            'site-font-18'   => esc_html__( 'Orbitron' , 'sen-business' ),
            'site-font-19'   => esc_html__( 'Marck Script', 'sen-business' ),
            'site-font-20'   => esc_html__( 'Kaushan Script', 'sen-business' ),
            'site-font-21'   => esc_html__( 'Courgette', 'sen-business' ),
            'site-font-22'   => esc_html__( 'Rajdhani', 'sen-business' ),
            'site-font-23'   => esc_html__( 'Bad Script', 'sen-business' ),
            'site-font-24'   => esc_html__( 'Righteous', 'sen-business' ),
            'site-font-25'   => esc_html__( 'Dosis', 'sen-business' ),
            'site-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-business' ),
            'site-font-27'   => esc_html__( 'Faster one', 'sen-business' ),
            'site-font-28'   => esc_html__( 'Tangerine', 'sen-business' ),
            'site-font-29'   => esc_html__( 'Fredericka the Great', 'sen-business' ),
            'site-font-30'   => esc_html__( 'Shadows Into Light', 'sen-business' ),
            'site-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_site_title_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_business_site_tagline_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_business_site_tagline_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-business' ),
            'tagline-font-1'     => esc_html__( 'Raleway', 'sen-business' ),
            'tagline-font-2'     => esc_html__( 'Poppins', 'sen-business' ),
            'tagline-font-3'     => esc_html__( 'Roboto', 'sen-business' ),
            'tagline-font-4'     => esc_html__( 'Open Sans', 'sen-business' ),
            'tagline-font-5'     => esc_html__( 'Lato', 'sen-business' ),
            'tagline-font-6'   => esc_html__( 'Ubuntu', 'sen-business' ),
            'tagline-font-7'   => esc_html__( 'Playfair Display', 'sen-business' ),
            'tagline-font-8'   => esc_html__( 'Lora', 'sen-business' ),
            'tagline-font-9'   => esc_html__( 'Titillium Web', 'sen-business' ),
            'tagline-font-10'   => esc_html__( 'Muli', 'sen-business' ),
            'tagline-font-11'   => esc_html__( 'Oxygen', 'sen-business' ),
            'tagline-font-12'   => esc_html__( 'Nunito Sans', 'sen-business' ),
            'tagline-font-13'   => esc_html__( 'Maven Pro', 'sen-business' ),
            'tagline-font-14'   => esc_html__( 'Cairo', 'sen-business' ),
            'tagline-font-15'   => esc_html__( 'Philosopher', 'sen-business' ),
            'tagline-font-16'   => esc_html__( 'Quicksand', 'sen-business' ),
            'tagline-font-17'   => esc_html__( 'Dancing Script ', 'sen-business' ),
            'tagline-font-18'   => esc_html__( 'Rajdhani', 'sen-business' ),
        );

        $output = apply_filters( 'sen_business_site_tagline_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

 ?>