<?php 
/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function sen_agency_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'sen-agency' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

if ( ! function_exists( 'sen_agency_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function sen_agency_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'sen-agency' ),
            'off'       => esc_html__( 'Disable', 'sen-agency' )
        );
        return apply_filters( 'sen_agency_switch_options', $arr );
    }
endif;

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function sen_agency_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'sen-agency' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}
if ( ! function_exists( 'sen_agency_get_woo_product' ) ) {
    /**
     * Get product.
     */
    function sen_agency_get_woo_product() {
        $args = array(
            'posts_per_page' => -1,
        );
         
        $choices = array( '' => esc_html__( '--Select--', 'sen-agency' ) );
        $products = wc_get_products( $args );
        foreach ( $products as $product ) {
            $id = $product->get_id();
            $title = $product->get_name();
            $choices[ $id ] = $title;
        }
        return $choices;
    }
}




 /**
 * Get an array of google fonts.
 * 
 */
function sen_agency_font_choices() {
    $font_family_arr = array();
    $font_family_arr[''] = esc_html__( '--Default--', 'sen-agency' );

    // Make the request
    $request = wp_remote_get( get_theme_file_uri( 'assets/fonts/webfonts.json' ) );

    if( is_wp_error( $request ) ) {
        return false; // Bail early
    }
    // Retrieve the data
    $body = wp_remote_retrieve_body( $request );
    $data = json_decode( $body );
    if ( ! empty( $data ) ) {
        foreach ( $data->items as $items => $fonts ) {
            $family_str_arr = explode( ' ', $fonts->family );
            $family_value = implode( '-', array_map( 'strtolower', $family_str_arr ) );
            $font_family_arr[ $family_value ] = $fonts->family;
        }
    }

    return apply_filters( 'sen_agency_font_choices', $font_family_arr );
}

if ( ! function_exists( 'sen_agency_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'header-font-1'   => esc_html__( 'Raleway', 'sen-agency' ),
            'header-font-2'   => esc_html__( 'Poppins', 'sen-agency' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'sen-agency' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'sen-agency' ),
            'header-font-5'   => esc_html__( 'Lato', 'sen-agency' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'header-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'header-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'header-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'sen-agency' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'sen-agency' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'sen-agency' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'sen-agency' ),
            'header-font-21'   => esc_html__( 'Courgette', 'sen-agency' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'sen-agency' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'sen-agency' ),
            'header-font-24'   => esc_html__( 'Righteous', 'sen-agency' ),
            'header-font-25'   => esc_html__( 'Dosis', 'sen-agency' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-agency' ),
            'header-font-27'   => esc_html__( 'Faster one', 'sen-agency' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'sen-agency' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'sen-agency' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'sen-agency' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_agency_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'body-font-1'     => esc_html__( 'Raleway', 'sen-agency' ),
            'body-font-2'     => esc_html__( 'Poppins', 'sen-agency' ),
            'body-font-3'     => esc_html__( 'Roboto', 'sen-agency' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'sen-agency' ),
            'body-font-5'     => esc_html__( 'Lato', 'sen-agency' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'body-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'body-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'body-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'sen-agency' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'sen_agency_archive_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_archive_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'header-font-1'   => esc_html__( 'Raleway', 'sen-agency' ),
            'header-font-2'   => esc_html__( 'Poppins', 'sen-agency' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'sen-agency' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'sen-agency' ),
            'header-font-5'   => esc_html__( 'Lato', 'sen-agency' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'header-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'header-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'header-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'sen-agency' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'sen-agency' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'sen-agency' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'sen-agency' ),
            'header-font-21'   => esc_html__( 'Courgette', 'sen-agency' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'sen-agency' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'sen-agency' ),
            'header-font-24'   => esc_html__( 'Righteous', 'sen-agency' ),
            'header-font-25'   => esc_html__( 'Dosis', 'sen-agency' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-agency' ),
            'header-font-27'   => esc_html__( 'Faster one', 'sen-agency' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'sen-agency' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'sen-agency' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'sen-agency' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_archive_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_agency_archive_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_archive_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'body-font-1'     => esc_html__( 'Raleway', 'sen-agency' ),
            'body-font-2'     => esc_html__( 'Poppins', 'sen-agency' ),
            'body-font-3'     => esc_html__( 'Roboto', 'sen-agency' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'sen-agency' ),
            'body-font-5'     => esc_html__( 'Lato', 'sen-agency' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'body-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'body-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'body-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'sen-agency' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_archive_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_agency_page_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_page_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'header-font-1'   => esc_html__( 'Raleway', 'sen-agency' ),
            'header-font-2'   => esc_html__( 'Poppins', 'sen-agency' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'sen-agency' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'sen-agency' ),
            'header-font-5'   => esc_html__( 'Lato', 'sen-agency' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'header-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'header-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'header-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'sen-agency' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'sen-agency' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'sen-agency' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'sen-agency' ),
            'header-font-21'   => esc_html__( 'Courgette', 'sen-agency' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'sen-agency' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'sen-agency' ),
            'header-font-24'   => esc_html__( 'Righteous', 'sen-agency' ),
            'header-font-25'   => esc_html__( 'Dosis', 'sen-agency' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-agency' ),
            'header-font-27'   => esc_html__( 'Faster one', 'sen-agency' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'sen-agency' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'sen-agency' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'sen-agency' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_page_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_agency_page_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_page_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'body-font-1'     => esc_html__( 'Raleway', 'sen-agency' ),
            'body-font-2'     => esc_html__( 'Poppins', 'sen-agency' ),
            'body-font-3'     => esc_html__( 'Roboto', 'sen-agency' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'sen-agency' ),
            'body-font-5'     => esc_html__( 'Lato', 'sen-agency' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'body-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'body-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'body-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'sen-agency' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_page_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_agency_post_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_post_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'header-font-1'   => esc_html__( 'Raleway', 'sen-agency' ),
            'header-font-2'   => esc_html__( 'Poppins', 'sen-agency' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'sen-agency' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'sen-agency' ),
            'header-font-5'   => esc_html__( 'Lato', 'sen-agency' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'header-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'header-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'header-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'sen-agency' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'sen-agency' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'sen-agency' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'sen-agency' ),
            'header-font-21'   => esc_html__( 'Courgette', 'sen-agency' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'sen-agency' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'sen-agency' ),
            'header-font-24'   => esc_html__( 'Righteous', 'sen-agency' ),
            'header-font-25'   => esc_html__( 'Dosis', 'sen-agency' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-agency' ),
            'header-font-27'   => esc_html__( 'Faster one', 'sen-agency' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'sen-agency' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'sen-agency' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'sen-agency' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_post_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_agency_post_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_post_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'body-font-1'     => esc_html__( 'Raleway', 'sen-agency' ),
            'body-font-2'     => esc_html__( 'Poppins', 'sen-agency' ),
            'body-font-3'     => esc_html__( 'Roboto', 'sen-agency' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'sen-agency' ),
            'body-font-5'     => esc_html__( 'Lato', 'sen-agency' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'body-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'body-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'body-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'sen-agency' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_post_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'sen_agency_site_title_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_site_title_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'site-font-1'   => esc_html__( 'Raleway', 'sen-agency' ),
            'site-font-2'   => esc_html__( 'Poppins', 'sen-agency' ),
            'site-font-3'   => esc_html__( 'Montserrat', 'sen-agency' ),
            'site-font-4'   => esc_html__( 'Open Sans', 'sen-agency' ),
            'site-font-5'   => esc_html__( 'Lato', 'sen-agency' ),
            'site-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'site-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'site-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'site-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'site-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'site-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'site-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'site-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'site-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'site-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'site-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'site-font-17'   => esc_html__( 'Henny Penny', 'sen-agency' ),
            'site-font-18'   => esc_html__( 'Orbitron' , 'sen-agency' ),
            'site-font-19'   => esc_html__( 'Marck Script', 'sen-agency' ),
            'site-font-20'   => esc_html__( 'Kaushan Script', 'sen-agency' ),
            'site-font-21'   => esc_html__( 'Courgette', 'sen-agency' ),
            'site-font-22'   => esc_html__( 'Rajdhani', 'sen-agency' ),
            'site-font-23'   => esc_html__( 'Bad Script', 'sen-agency' ),
            'site-font-24'   => esc_html__( 'Righteous', 'sen-agency' ),
            'site-font-25'   => esc_html__( 'Dosis', 'sen-agency' ),
            'site-font-26'   => esc_html__( 'Cinzel Decorative', 'sen-agency' ),
            'site-font-27'   => esc_html__( 'Faster one', 'sen-agency' ),
            'site-font-28'   => esc_html__( 'Tangerine', 'sen-agency' ),
            'site-font-29'   => esc_html__( 'Fredericka the Great', 'sen-agency' ),
            'site-font-30'   => esc_html__( 'Shadows Into Light', 'sen-agency' ),
            'site-font-31'   => esc_html__( 'Gloria Hallelujah', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_site_title_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'sen_agency_site_tagline_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function sen_agency_site_tagline_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'sen-agency' ),
            'tagline-font-1'     => esc_html__( 'Raleway', 'sen-agency' ),
            'tagline-font-2'     => esc_html__( 'Poppins', 'sen-agency' ),
            'tagline-font-3'     => esc_html__( 'Roboto', 'sen-agency' ),
            'tagline-font-4'     => esc_html__( 'Open Sans', 'sen-agency' ),
            'tagline-font-5'     => esc_html__( 'Lato', 'sen-agency' ),
            'tagline-font-6'   => esc_html__( 'Ubuntu', 'sen-agency' ),
            'tagline-font-7'   => esc_html__( 'Playfair Display', 'sen-agency' ),
            'tagline-font-8'   => esc_html__( 'Lora', 'sen-agency' ),
            'tagline-font-9'   => esc_html__( 'Titillium Web', 'sen-agency' ),
            'tagline-font-10'   => esc_html__( 'Muli', 'sen-agency' ),
            'tagline-font-11'   => esc_html__( 'Oxygen', 'sen-agency' ),
            'tagline-font-12'   => esc_html__( 'Nunito Sans', 'sen-agency' ),
            'tagline-font-13'   => esc_html__( 'Maven Pro', 'sen-agency' ),
            'tagline-font-14'   => esc_html__( 'Cairo', 'sen-agency' ),
            'tagline-font-15'   => esc_html__( 'Philosopher', 'sen-agency' ),
            'tagline-font-16'   => esc_html__( 'Quicksand', 'sen-agency' ),
            'tagline-font-17'   => esc_html__( 'Dancing Script ', 'sen-agency' ),
            'tagline-font-18'   => esc_html__( 'Rajdhani', 'sen-agency' ),
        );

        $output = apply_filters( 'sen_agency_site_tagline_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

 ?>