<?php

// namespace Elementor;

if (!defined('ABSPATH')) {
    exit(); // Exit if accessed directly.
}

if (!class_exists('Honrix_Posts')) {
    class Honrix_Posts extends Elementor\Widget_Base
    {
        public function __construct($data = [], $args = null)
        {
            parent::__construct($data, $args);
        }
        public function get_name()
        {
            return 'honrix_posts';
        }

        public function get_title()
        {
            return __('Honrix: Posts', 'savalog');
        }

        public function get_icon()
        {
            return 'eicon-post-list';
        }

        public function get_categories()
        {
            return ['honrix-addon'];
        }

        public function get_style_depends()
        {
            return ['honrix-widget-slider-css'];
        }

        public function get_script_depends()
        {
            return ['honrix-widget-slider-script'];
        }

        protected function register_controls()
        {
            $this->start_controls_section('items_section', [
                'label' => __('Posts', 'savalog'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]);

            $this->add_control(
                'mode',
                [
                    'label' => esc_html__('Mode', 'savalog'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'grid',
                    'options' => [
                        'list' => esc_html__('List', 'savalog'),
                        'grid' => esc_html__('Grid', 'savalog'),
                        'slider' => esc_html__('Slider', 'savalog'),
                        'masonry' => esc_html__('Masonry', 'savalog'),
                    ],
                ]
            );

            $this->add_responsive_control(
                'count',
                [
                    'label' => esc_html__('Display Count', 'savalog'),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'min' => -1,
                    'max' => 6,
                    'step' => 1,
                    'default' => 3,
                    'condition' => [
                        'mode' => ['list', 'grid', 'masonry'],
                    ],
                ]
            );

            $this->add_control(
                'column',
                [
                    'label' => esc_html__('Display Columns', 'savalog'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => '3',
                    'options' => [
                        '1' => esc_html__('1', 'savalog'),
                        '2' => esc_html__('2', 'savalog'),
                        '3'  => esc_html__('3', 'savalog'),
                        '4' => esc_html__('4', 'savalog'),
                    ],
                    'condition' => [
                        'mode' => ['grid', 'masonry'],
                    ],
                ]
            );

            $this->add_control(
                'display_pagination',
                [
                    'label' => esc_html__('Display Pagination', 'savalog'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => esc_html__('Yes', 'savalog'),
                    'label_off' => esc_html__('No', 'savalog'),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'mode' => ['list', 'grid', 'masonry'],
                    ],
                ]
            );

            $this->end_controls_section();

            $this->start_controls_section('slider_content_section', [
                'label' => __('Slider', 'savalog'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'mode' => 'slider',
                ],
            ]);

            $args = array(
                "post_type" => "post",
                "orderby" => "ID",
                "post_status" => "publish",
                "order" => "DESC",
            );

            $posts_arr = [];
            $_posts = get_posts($args);
            if (count($_posts) > 0) {
                foreach ($_posts as $post) {
                    $posts_arr[$post->ID] = $post->post_title;
                }
            }

            $this->add_control(
                'slides',
                [
                    'label' => esc_html__('Select Posts', 'savalog'),
                    'type' => \Elementor\Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => $posts_arr,
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            if ($settings['mode'] === 'slider'):
                wp_localize_script('honrix-widget-slider-script', 'honrix_slider_params', array(
                    'id' => $this->get_id(),
                ));
                $slider_posts = [];
                if ($settings['slides']):
                    foreach ($settings['slides'] as $post) {
                        $slider_posts[] = $post;
                    }
                endif;

                $args = array(
                    'post__in' => $slider_posts,
                    'order' => 'ASC'
                );

                $slider_posts = get_posts($args);
                if (count($slider_posts) > 0): ?>
                    <div id="hrx-widget-slider-<?php echo esc_attr($this->get_id()); ?>" class="hrix-posts hrx-widget-slider">
                        <?php foreach ($slider_posts as $post) :
                            $post_thumbnail_url = get_the_post_thumbnail_url($post->ID);
                            if (!empty($post_thumbnail_url)): ?>
                                <article class="position-relative">
                                    <img src="<?php echo esc_url($post_thumbnail_url); ?>" alt="<?php echo esc_html($post->post_title); ?>" />
                                    <div class="slider-content position-absolute w-100 h-100 top-0 start-0 d-flex flex-column align-items-center justify-content-center">
                                        <div class="text-center">
                                            <?php $categories_list = wp_get_post_categories($post->ID, array('fields' => 'all')); ?>
                                            <?php if (count($categories_list) > 0) : ?>
                                                <div>
                                                    <span class="entry-categories mb-2">
                                                        <?php foreach ($categories_list as $category): ?>
                                                            <span><a href="<?php echo esc_url(get_category_link($category->term_id)); ?>"><?php echo esc_html($category->name); ?></a></span>
                                                        <?php endforeach; ?>
                                                    </span>
                                                </div>
                                            <?php endif; ?>
                                            <h2 class="entry-title d-inline-block mb-2"><?php echo wp_kses_post($post->post_title); ?></h2>
                                            <div class="entry-read-more my-4">
                                                <a href="<?php echo esc_url(get_permalink($post->ID)) ?>" rel="bookmark"><?php echo esc_html(get_theme_mod('honrix-pro_archive_content_read_more_text', __('Continue Reading...', 'savalog'))) ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </article>
                        <?php endif;
                        endforeach; ?>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <?php
                $related_args = [
                    'post_type' => 'post',
                    'posts_per_page' => $settings['count'],
                    'post_status' => 'publish',
                ];

                if ($settings['display_pagination'] === 'yes') {
                    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
                    $postsPerPage = get_option('posts_per_page');
                    $postOffset = ($paged - 1) * $postsPerPage;

                    $related_args['posts_per_page'] = $postsPerPage;
                    $related_args['offset'] = $postOffset;
                }

                $column_count = $settings['column'];
                $archive_mode = $settings['mode'];
                if ($archive_mode === 'list') {
                    $column_count = 1;
                }

                $post_counter = 1;

                $the_query = new WP_Query($related_args);
                if ($the_query->have_posts()) : ?>
                    <div class="posts hrix-posts honrix-entries d-flex column-<?php echo esc_attr($column_count); ?> <?php echo esc_attr($archive_mode === 'masonry' ? 'honrix-masonry' : $archive_mode) ?>">
                        <?php
                        while ($the_query->have_posts()) :
                            $the_query->the_post(); ?>
                            <?php get_template_part('template-parts/sections/post-card/theme', null, [
                                'counter' => $post_counter,
                                'mode' => $archive_mode
                            ]); ?>
                            <?php $post_counter++; ?>
                        <?php
                        endwhile; ?>
                    </div>
                    <?php if ($settings['display_pagination'] === 'yes'): ?>
                        <?php
                        $total_pages = $the_query->max_num_pages;

                        if ($total_pages > 1) { ?>
                            <nav class="navigation pagination" aria-label="<?php echo esc_attr__('Posts pagination', 'savalog'); ?>">
                                <h2 class="screen-reader-text"><?php echo esc_html__('Posts pagination', 'savalog'); ?></h2>
                                <div class="nav-links">
                                    <?php

                                    echo esc_url(paginate_links(array(
                                        'base' => esc_url(get_pagenum_link(1)) . '%_%',
                                        'format' => '/page/%#%',
                                        'current' => $paged,
                                        'total' => $total_pages,
                                        'prev_text'    => __('<i class="fas fa-angle-double-left"></i>', 'savalog'),
                                        'next_text'    => __('<i class="fas fa-angle-double-right"></i>', 'savalog'),
                                    ))); ?>
                                </div>


                            </nav>
                    <?php
                        }
                        wp_reset_postdata();
                    endif; ?>
<?php
                endif;
                wp_reset_postdata();
            endif;
        }
    }
    Elementor\Plugin::instance()->widgets_manager->register_widget_type(
        new Honrix_Posts()
    );
}
