<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit(); // Exit if accessed directly.
}

if (!class_exists('Honrix_Menu')) {
    class Honrix_Menu extends Widget_Base
    {
        public function __construct($data = [], $args = null)
        {
            parent::__construct($data, $args);
        }
        public function get_name()
        {
            return 'honrix_menu';
        }

        public function get_title()
        {
            return __('Honrix: Menu', 'savalog');
        }

        public function get_icon()
        {
            return 'eicon-nav-menu';
        }

        public function get_categories()
        {
            return ['honrix-addon'];
        }

        public function get_style_depends()
        {
            return ['honrix-widgets-css'];
        }

        public function get_script_depends()
        {
            return ['honrix-menu-js'];
        }

        protected function register_controls() {}

        protected function render()
        {
            do_action('savalog_nav_menu');
        }
    }
    Plugin::instance()->widgets_manager->register_widget_type(
        new Honrix_Menu()
    );
}
