<?php
$_mode = get_theme_mod('honrix_archive_mode', 'grid');
if (!empty($args['mode'])) {
    $_mode = $args['mode'];
}

$post_counter = 2;
if (!empty($args['counter'])) {
    $post_counter = $args['counter'];
}

if ($post_counter === 1 && $_mode !== 'masonry' && $_mode !== 'list'): ?>
    <article class="post-<?php the_ID(); ?> d-flex flex-column">
        <div class="d-flex justify-content-center mb-2">
            <span class="d-inline-block fst-italic me-2"><?php echo esc_html__('In', 'savalog') ?></span>
            <?php savalog_entry_category(); ?>
        </div>
        <div class="d-flex justify-content-center mb-2"><?php savalog_entry_title(['center' => true]); ?></div>
        <div class="d-flex align-items-center justify-content-center mb-2">
            <span class="date"><?php echo esc_html(get_the_date('M j, Y')); ?></span>
            <span class="dot mx-3"></span>
            <span class="author-name">
                <span class="d-inline-block fst-italic"><?php echo esc_html__('By', 'savalog') ?></span>
                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
            </span>
            <span class="dot mx-3"></span>
            <span class="comments">
                <?php echo intval(get_comments_number()); ?>
                <?php
                if (intval(get_comments_number()) > 1) {
                    esc_html_e('Comments', 'savalog');
                } else {
                    esc_html_e('Comment', 'savalog');
                }
                ?>
            </span>
        </div>
        <?php if (get_theme_mod('honrix_archive_display_thumbnail', 'yes') === 'yes'): ?>
            <div class="d-flex justify-content-center mb-4"><?php savalog_post_thumbnail(); ?></div>
        <?php endif; ?>
        <?php
        $display_read_more_text = get_theme_mod('honrix_archive_content_read_more_text', __('Continue Reading...', 'savalog'));
        ?>
        <div class="d-flex justify-content-center mb-4 text-center"><?php honrix_entry_content(); ?></div>
        <div class="entry-read-more mb-4 d-flex justify-content-center">
            <a href="<?php echo esc_url(get_permalink()) ?>" rel="bookmark"><?php echo esc_html($display_read_more_text) ?></a>
        </div>
    </article>

<?php else: ?>
    <article class="post-<?php the_ID(); ?> d-flex flex-column">
        <?php if (get_theme_mod('honrix_archive_display_thumbnail', 'yes') === 'yes'): ?>
            <div class="mb-4"><?php savalog_post_thumbnail(); ?></div>
        <?php endif; ?>
        <div class="d-flex justify-content-center mb-2">
            <span class="d-inline-block fst-italic me-2"><?php echo esc_html__('In', 'savalog') ?></span>
            <?php savalog_entry_category(); ?>
        </div>

        <div class="d-flex justify-content-center mb-2"><?php savalog_entry_title(['center' => true]); ?></div>

        <div class="d-flex align-items-center justify-content-center mb-4">
            <span class="date"><?php echo esc_html(get_the_date('M j, Y')); ?></span>
            <span class="dot mx-3"></span>
            <span class="author-name">
                <span class="d-inline-block fst-italic"><?php echo esc_html__('By', 'savalog') ?></span>
                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
            </span>
            <span class="dot mx-3"></span>
            <span class="comments">
                <?php echo intval(get_comments_number()); ?>
                <?php
                if (intval(get_comments_number()) > 1) {
                    esc_html_e('Comments', 'savalog');
                } else {
                    esc_html_e('Comment', 'savalog');
                }
                ?>
            </span>
        </div>

        <?php
        $display_read_more_text = get_theme_mod('honrix_archive_content_read_more_text', __('Continue Reading...', 'savalog'));
        ?>
        <div class="mb-4 text-center"><?php honrix_entry_content(); ?></div>
        <div class="entry-read-more mb-4 d-flex justify-content-center">
            <a href="<?php echo esc_url(get_permalink()) ?>" rel="bookmark"><?php echo esc_html($display_read_more_text) ?></a>
        </div>
    </article>
<?php endif;