<?php

/**
 * savalog page template
 *
 * @package savalog
 */

if (!defined('ABSPATH')) {
    exit;
}
?>
<div id="content" class="savalog-entry py-4 <?php echo esc_attr(get_theme_mod('savalog_boxed', 'boxed')) == 'boxed' ? 'container' : 'container-fluid'; ?>">
    <div class="row">
        <?php
        $right_sidebar = $left_sidebar = false;
        $right_sidebar = get_theme_mod('savalog_page_right_sidebar_display', 'yes') === 'yes' && is_active_sidebar('right_sidebar');
        $left_sidebar = get_theme_mod('savalog_page_left_sidebar_display', 'yes') === 'yes' && is_active_sidebar('left_sidebar');
        ?>
        <?php if ($left_sidebar) : ?>
            <div class="col-12 col-md-3">
                <?php is_rtl() ? get_sidebar('right') : get_sidebar('left'); ?>
            </div>
        <?php endif; ?>
        <div class="col-12 col-md-<?php echo (12 - ($left_sidebar ? 3 : 0) - ($right_sidebar ? 3 : 0));  ?> honrix-entries">
            <div class="honrix-content">
                <?php if (have_posts()) : ?>
                    <?php while (have_posts()) :/* loop start*/
                        the_post(); ?>
                        <article <?php post_class('post page'); ?>>
                            <div class="d-flex justify-content-center mb-4"><?php savalog_entry_title(); ?></div>
                            <div class="d-flex align-items-center justify-content-center mb-4">
                                <span class="date"><?php echo esc_html(get_the_date('M j, Y')); ?></span>
                                <span class="dot mx-3"></span>
                                <span class="comments">
                                    <?php echo intval(get_comments_number()); ?>
                                    <?php
                                    if (intval(get_comments_number()) > 1) {
                                        esc_html_e('Comments', 'savalog');
                                    } else {
                                        esc_html_e('Comment', 'savalog');
                                    }
                                    ?>
                                </span>
                            </div>

                            <div class="mb-4 d-flex justify-content-center"><?php savalog_singular_thumbnail(); ?></div>

                            <div class="entry-content mb-4 clearfix">
                                <?php the_content(); ?>
                                <?php
                                wp_link_pages(
                                    array(
                                        'before' => '<div class="page-links"><span class="page-links-title">' . __('Pages:', 'savalog') . '</span>',
                                        'after' => '</div>',
                                        'link_before' => '<span>',
                                        'link_after' => '</span>',
                                        'pagelink' => '<span class="screen-reader-text">' . __('Page', 'savalog') . ' </span>%',
                                        'separator' => '<span class="screen-reader-text">, </span>',
                                    )
                                );
                                ?>
                            </div>
                            <?php
                            savalog_post_avatar(50);
                            savalog_post_navigation();

                            savalog_post_comment();
                            ?>
                        </article>
                    <?php endwhile; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>