<?php
if (!function_exists('savalog_top_header_customizer_register')) {
    function savalog_top_header_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_top_header', __('Top Header', 'savalog'), 'savalog_settings_pannel');

        $customizer->AddSetting(
            array(
                'id' => 'savalog_top_bar_display',
                'default' => 'yes',
                'title' => __('Top Header', 'savalog'),
                'section_id' => 'savalog_top_header',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_top_bg_color',
                'default' => '#333333',
                'title' => __('Background Color', 'savalog'),
                'section_id' => 'savalog_top_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_top_text_color',
                'default' => '#cccccc',
                'title' => __('Text Color', 'savalog'),
                'section_id' => 'savalog_top_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_top_link_color',
                'default' => '#cccccc',
                'title' => __('Link Color', 'savalog'),
                'section_id' => 'savalog_top_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_top_link_hover_color',
                'default' => '#ffffff',
                'title' => __('Link Hover Color', 'savalog'),
                'section_id' => 'savalog_top_header'
            ),
            BHR_Customizer::$COLOR
        );
    }
    add_action('customize_register', 'savalog_top_header_customizer_register');
}

if (!function_exists('savalog_top_customizer_css')) {
    function savalog_top_customizer_css()
    {
?>
        <style type="text/css">
            .hrix-top-bar {
                background: <?php echo esc_attr(get_theme_mod('savalog_top_bg_color', '#333333')); ?> !important;
                color: <?php echo esc_attr(get_theme_mod('savalog_top_text_color', '#cccccc')); ?> !important;
            }
            .hrix-top-bar a {
                color: <?php echo esc_attr(get_theme_mod('savalog_top_link_color', '#cccccc')); ?> !important;
            }

            .hrix-top-bar a:hover {
                color: <?php echo esc_attr(get_theme_mod('savalog_top_link_hover_color', '#ffffff')); ?> !important;
            }

            .hrix-top-bar select{
                border: none;
                background: <?php echo esc_attr(get_theme_mod('savalog_top_bg_color', '#333333')); ?> !important;
                color: <?php echo esc_attr(get_theme_mod('savalog_top_link_color', '#cccccc')); ?> !important;
            }

            .hrix-top-bar select:hover{
                color: <?php echo esc_attr(get_theme_mod('savalog_top_link_hover_color', '#ffffff')); ?> !important;
            }
        </style>
<?php
    }

    add_action('wp_head', 'savalog_top_customizer_css');
}
