<?php
if (!function_exists('savalog_header_customizer_register')) {
    function savalog_header_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_header', __('Header', 'savalog'), 'savalog_settings_pannel');

        /*** Header ***/
        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_bg_color',
                'default' => '#ffffff',
                'title' => __('Background Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_text_color',
                'default' => '#666666',
                'title' => __('Text Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_link_color',
                'default' => '#333333',
                'title' => __('Link Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_link_hover_color',
                'default' => '#DA8359',
                'title' => __('Link Hover Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        /*** Site Name ***/
        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_site_name_color',
                'default' => '#DA8359',
                'title' => __('Website Name Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        /*** Search ***/
        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_search_bg_color',
                'default' => '#ffffff99',
                'title' => __('Search Background Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_search_text_color',
                'default' => '#333333',
                'title' => __('Search Text Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_search_button_bg_color',
                'default' => '#ffffff',
                'title' => __('Search Button Background Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_search_button_text_color',
                'default' => '#333333',
                'title' => __('Search Button Icon Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        /*** Menu ***/
        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_menu_item_color',
                'default' => '#333333',
                'title' => __('Menu Item Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_menu_item_hover_color',
                'default' => '#DA8359',
                'title' => __('Menu Item Hover Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_submenu_bg_color',
                'default' => '#ffffff',
                'title' => __('Sub Menu Background Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_submenu_item_color',
                'default' => '#333333',
                'title' => __('Sub Menu Item Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_submenu_item_hover_color',
                'default' => '#ffffff',
                'title' => __('Sub Menu Item Hover Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_submenu_item_bg_hover_color',
                'default' => '#DA8359',
                'title' => __('Sub Menu Item Hover Background Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_mobile_toggle_color',
                'default' => '#333333',
                'title' => __('Mobile Toggle Menu Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_mobile_toggle_menu_link_color',
                'default' => '#333333',
                'title' => __('Mobile Toggle Menu Close Button Icon Color', 'savalog'),
                'section_id' => 'savalog_header'
            ),
            BHR_Customizer::$COLOR
        );
    }
    add_action('customize_register', 'savalog_header_customizer_register');
}

if (!function_exists('savalog_header_customizer_css')) {
    function savalog_header_customizer_css()
    {
?>
        <style type="text/css">
            .hrix-site-header {
                <?php if(empty(header_image())): ?>
                    background: <?php echo esc_attr(get_theme_mod('savalog_header_bg_color', '#ffffff')); ?> !important;
                <?php endif; ?>
                color: <?php echo esc_attr(get_theme_mod('savalog_header_text_color', '#666666')); ?> !important;
            }

            .hrix-navbar-toggler {
                color: <?php echo esc_attr(get_theme_mod('savalog_header_link_color', '#333333')); ?> !important;
            }

            .hrix-site-header .site-title,
            .hrix-site-header .site-title a {
                color: <?php echo esc_attr(get_theme_mod('savalog_header_site_name_color', '#DA8359')); ?> !important;
            }

            .hrix-site-header .site-description {
                color: <?php echo esc_attr(get_theme_mod('savalog_header_text_color', '#666666')); ?> !important;
            }

            .hrix-header-search-form form,
            .hrix-header-search-form .search-box,
            .hrix-header-search-form form .hrix-header-search-input {
                background: <?php echo esc_attr(get_theme_mod('savalog_header_search_bg_color', '#ffffff')); ?> !important;
                color: <?php echo esc_attr(get_theme_mod('savalog_header_search_text_color', '#333333')); ?> !important;
            }

            .hrix-header-search-form .hrix-header-search-button {
                background: <?php echo esc_attr(get_theme_mod('savalog_header_search_button_bg_color', '#ffffff')); ?> !important;
                color: <?php echo esc_attr(get_theme_mod('savalog_header_search_button_text_color', '#333333')); ?> !important;
            }

            .hrix-header-menu.navbar-dark .navbar-nav .nav-link {
                color: <?php echo esc_attr(get_theme_mod('savalog_header_menu_item_color', '#333333')); ?> !important;
            }

            .hrix-header-menu.navbar-dark .navbar-nav .nav-link:hover {
                color: <?php echo esc_attr(get_theme_mod('savalog_header_menu_item_hover_color', '#DA8359')); ?> !important;
            }

            .hrix-header-menu .sub-menu {
                background: <?php echo esc_attr(get_theme_mod('savalog_header_submenu_bg_color', '#ffffff')); ?> !important;
            }

            .hrix-header-menu .sub-menu a {
                color: <?php echo esc_attr(get_theme_mod('savalog_header_submenu_item_color', '#333333')); ?> !important;
            }

            .hrix-header-menu .sub-menu a:hover {
                background: <?php echo esc_attr(get_theme_mod('savalog_header_submenu_item_bg_hover_color', '#DA8359')); ?> !important;
                color: <?php echo esc_attr(get_theme_mod('savalog_header_submenu_item_hover_color', '#ffffff')); ?> !important;
            }

            .hrix-mobile-navigation-menu > div{
                color: <?php echo esc_attr(get_theme_mod('savalog_header_mobile_toggle_color', '#333333')); ?> !important;
            }

            @media (max-width:991px) {
                .hrix-mobile-navigation-menu a,
                .hrix-mobile-navigation-menu span.close {
                    color: <?php echo esc_attr(get_theme_mod('savalog_header_mobile_toggle_menu_link_color', '#333333'));?> !important;
                }

                .hrix-header-search-form .hrix-header-search-button {
                    border: 1px solid <?php echo esc_attr(get_theme_mod('savalog_header_search_button_bg_color', '#ffffff')); ?> !important;
                }
            }
        </style>
<?php
    }

    add_action('wp_head', 'savalog_header_customizer_css');
}
