<?php

if (!function_exists('savalog_general_customizer_register')) {
    function savalog_general_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_layout', __('Layout', 'savalog'), 'savalog_settings_pannel');

        $customizer->AddSetting(
            array(
                'id' => 'savalog_boxed',
                'default' => 'boxed',
                'title' => __('Layout Mode', 'savalog'),
                'description' => __('This is an option you can choose to display your website content in full width mode or boxed mode.', 'savalog'),
                'section_id' => 'savalog_layout',
                'options' => array(
                    'boxed' => __('Boxed', 'savalog'),
                    'wide' => __('Wide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_to_top',
                'default' => 'yes',
                'title' => __('Display Back To Top Button', 'savalog'),
                'description' => __('Back to top button is a little button in bottom of the website page. If client clicks it, he will go to top of the page smoothly. Choose to display or hide the button in here.', 'savalog'),
                'section_id' => 'savalog_layout',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_loading_display',
                'default' => 'yes',
                'title' => __('Loading Page', 'savalog'),
                'description' => __('If page is loading, the client will see the Loading Page with a little spinner. Hide or display the page with this option.', 'savalog'),
                'section_id' => 'savalog_layout',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_enqueue_bootstrap',
                'default' => 'yes',
                'title' => __('Add Bootstrap', 'savalog'),
                'description' => __('This is an option you can choose to add Bootstrap or not.', 'savalog'),
                'section_id' => 'savalog_layout',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_enqueue_fontawesome',
                'default' => 'yes',
                'title' => __('Add FontAwesome', 'savalog'),
                'description' => __('This is an option you can choose to add FontAwesome or not.', 'savalog'),
                'section_id' => 'savalog_layout',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_theme_color',
                'default' => '#DA8359',
                'title' => __('Theme Color', 'savalog'),
                'description' => __('Change Theme color to customize your website as you wanted.', 'savalog'),
                'section_id' => 'colors'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_header_color',
                'default' => '#333333',
                'title' => __('Heading (h1 - h6) Color', 'savalog'),
                'description' => __('Change heading (h1-h6) color', 'savalog'),
                'section_id' => 'colors'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_text_color',
                'default' => '#666666',
                'title' => __('Text Color', 'savalog'),
                'description' => __('Change text (posts and pages content) color', 'savalog'),
                'section_id' => 'colors'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_accent_color',
                'default' => '#A5B68D',
                'title' => __('Accent Color', 'savalog'),
                'description' => __('This color will be used in some borders and lines between the items like comment message txtarea border.', 'savalog'),
                'section_id' => 'colors'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_secondary_color',
                'default' => '#ECDFCC',
                'title' => __('Secondary Color', 'savalog'),
                'section_id' => 'colors'
            ),
            BHR_Customizer::$COLOR
        );
    }

    add_action('customize_register', 'savalog_general_customizer_register');
}

if (!function_exists('savalog_customizer_css')) {
    function savalog_customizer_css()
    {
?>
        <style type="text/css">
            :root {
                --savalog-theme-color: <?php echo esc_attr(get_theme_mod('savalog_theme_color', '#DA8359')); ?>;
                --savalog-header-color: <?php echo esc_attr(get_theme_mod('savalog_header_color', '#333333')); ?>;
                --savalog-text-color: <?php echo esc_attr(get_theme_mod('savalog_text_color', '#666666')); ?>;
                --savalog-background-color: #<?php echo esc_attr(get_background_color()); ?>;
                --savalog-accent-color: <?php echo esc_attr(get_theme_mod('savalog_accent_color', '#A5B68D')); ?>;
                --savalog-secondary-color: <?php echo esc_attr(get_theme_mod('savalog_secondary_color', '#ECDFCC')); ?>;
            }

            body{
                color: <?php echo esc_attr(get_theme_mod('savalog_text_color', '#666666')); ?>;
            }

            h1,h2,h3,h4,h5,h6{
                color: <?php echo esc_attr(get_theme_mod('savalog_header_color', '#333333')); ?>;
            }
        </style>
<?php
    }

    add_action('wp_head', 'savalog_customizer_css');
}

// if (!function_exists('ic_sanitize_image')) {
//     function ic_sanitize_image($file, $setting)
//     {
//         $mimes = array(
//             'jpg|jpeg|jpe' => 'image/jpeg',
//             'gif'          => 'image/gif',
//             'png'          => 'image/png',
//             'bmp'          => 'image/bmp',
//             'tif|tiff'     => 'image/tiff',
//             'ico'          => 'image/x-icon'
//         );
//         $file_ext = wp_check_filetype($file, $mimes);
//         return ($file_ext['ext'] ? $file : $setting->default);
//     }
// }
