<?php
if (!function_exists('savalog_footer_customizer_register')) {
    function savalog_footer_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_footer', __('Footer', 'savalog'), 'savalog_settings_pannel');

        $customizer->AddSetting(
            array(
                'id' => 'savalog_footer_display',
                'default' => 'yes',
                'title' => __('Footer', 'savalog'),
                'description' => __('Hide or display website footer.', 'savalog'),
                'section_id' => 'savalog_footer',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_footer_columns',
                'default' => '3',
                'title' => __('Columns Count', 'savalog'),
                'description' => __('Choose your website footer\'s column count. All columns will have the same width.', 'savalog'),
                'section_id' => 'savalog_footer',
                'options' => array(
                    '1' => __('One', 'savalog'),
                    '2' => __('Two', 'savalog'),
                    '3' => __('Three', 'savalog'),
                    '4' => __('Four', 'savalog'),
                    '5' => __('Five', 'savalog'),
                )
            ),
            BHR_Customizer::$SELECT
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_footer_bg_color',
                'default' => '#333333',
                'title' => __('Background Color', 'savalog'),
                'description' => __('Change footer background color.', 'savalog'),
                'section_id' => 'savalog_footer'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_footer_title_color',
                'default' => '#ffffff',
                'title' => __('Widget Title Color', 'savalog'),
                'section_id' => 'savalog_footer'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_footer_text_color',
                'default' => '#cccccc',
                'title' => __('Text Color', 'savalog'),
                'section_id' => 'savalog_footer'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_footer_link_color',
                'default' => '#ffffff',
                'title' => __('Link Color', 'savalog'),
                'section_id' => 'savalog_footer'
            ),
            BHR_Customizer::$COLOR
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_footer_link_hover_color',
                'default' => '#cccccc',
                'title' => __('Link Hover Color', 'savalog'),
                'section_id' => 'savalog_footer'
            ),
            BHR_Customizer::$COLOR
        );
    }

    add_action('customize_register', 'savalog_footer_customizer_register');
}

if (!function_exists('savalog_footer_customizer_css')) {
    function savalog_footer_customizer_css()
    {
?>
        <style type="text/css">
            .site-footer {
                background: <?php echo esc_attr(get_theme_mod('savalog_footer_bg_color', '#333333')); ?> !important;
                color:<?php echo esc_attr(get_theme_mod('savalog_footer_text_color', '#cccccc')); ?> !important;
            }

            .site-footer .widget-title,
            .site-footer .widget h1,
            .site-footer .widget h2,
            .site-footer .widget h3,
            .site-footer .widget h4,
            .site-footer .widget h5,
            .site-footer .widget h6{
                color:<?php echo esc_attr(get_theme_mod('savalog_footer_title_color', '#ffffff')); ?> !important;
            }

            .site-footer a{
                color:<?php echo esc_attr(get_theme_mod('savalog_footer_link_color', '#ffffff')); ?> !important;
            }

            .site-footer a:hover{
                color:<?php echo esc_attr(get_theme_mod('savalog_footer_link_hover_color', '#cccccc')); ?> !important;
            }
        </style>
<?php
    }

    add_action('wp_head', 'savalog_footer_customizer_css');
}