<?php
if (!function_exists('savalog_comment_customizer_register')) {
    function savalog_comment_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_comment', __('Comments', 'savalog'), 'savalog_settings_pannel');

        $customizer->AddSetting(
            array(
                'id' => 'savalog_comment_display',
                'default' => 'yes',
                'title' => __('Comment', 'savalog'),
                'description' => __('Hide or display all comment section from posts and pages.', 'savalog'),
                'section_id' => 'savalog_comment',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_comment_close_message',
                'default' => __('Comments are closed for this section.', 'savalog'),
                'title' => __('Comment Closed Message', 'savalog'),
                'description' => __('Write close comment message in here to display when comments are closed for post or page. Leave it blank to display none.', 'savalog'),
                'section_id' => 'savalog_comment'
            ),
            BHR_Customizer::$TEXTAREA
        );
    }

    add_action('customize_register', 'savalog_comment_customizer_register');
}
