<?php
if (!function_exists('savalog_archive_customizer_register')) {
    function savalog_archive_customizer_register($wp_customize)
    {
        get_template_part('/inc/customize/class/customizer');
        $customizer = new BHR_Customizer($wp_customize);

        $customizer->AddSection('savalog_archive', __('Blog', 'savalog'), 'savalog_settings_pannel');

        $customizer->AddSetting(
            array(
                'id' => 'savalog_archive_mode',
                'default' => 'grid',
                'title' => __('Blog Mode', 'savalog'),
                'section_id' => 'savalog_archive',
                'options' => array(
                    'list' => __('List', 'savalog'),
                    'grid' => __('Grid', 'savalog'),
                    'masonry' => __('Masonry', 'savalog'),
                )
            ),
            BHR_Customizer::$SELECT
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_archive_columns',
                'default' => '2',
                'title' => __('Columns', 'savalog'),
                'description' => __('Choose columns to display.', 'savalog'),
                'section_id' => 'savalog_archive',
                'options' => array(
                    '1' => __('One', 'savalog'),
                    '2' => __('Two', 'savalog'),
                    '3' => __('Three', 'savalog'),
                    '4' => __('Four', 'savalog'),
                )
            ),
            BHR_Customizer::$SELECT
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_archive_display_thumbnail',
                'default' => 'yes',
                'title' => __('Thumbnail', 'savalog'),
                'description' => __('Hide or display posts thumbnail.', 'savalog'),
                'section_id' => 'savalog_archive',
                'options' => array(
                    'yes' => __('Show', 'savalog'),
                    'no' => __('Hide', 'savalog')
                )
            ),
            BHR_Customizer::$SWITCH
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_archive_content_length',
                'default' => '20',
                'title' => __('Excerpt Length', 'savalog'),
                'section_id' => 'savalog_archive'
            ),
            BHR_Customizer::$NUMBER
        );

        $customizer->AddSetting(
            array(
                'id' => 'savalog_archive_content_read_more_text',
                'default' => __('continue reading...', 'savalog'),
                'title' => __('Read More Text', 'savalog'),
                'description' => __('Change the text of the read more button.', 'savalog'),
                'section_id' => 'savalog_archive'
            ),
            BHR_Customizer::$TEXT
        );
    }

    add_action('customize_register', 'savalog_archive_customizer_register');
}
