<?php
if (!defined('HONRIX_PARENT_TEMPLATE_URI')) {
	define('HONRIX_PARENT_TEMPLATE_URI', get_template_directory_uri());
}
define('SAVALOG_TEMPLATE_DIR', get_stylesheet_directory());
define('SAVALOG_TEMPLATE_URI', get_stylesheet_directory_uri());

if (!function_exists('savalog_remove_honrix_theme_actions')) {
	add_action('init', 'savalog_remove_honrix_theme_actions');
	function savalog_remove_honrix_theme_actions()
	{
		remove_action('wp_enqueue_scripts', 'honrix_enqueue_scripts');
		remove_action('widgets_init', 'honrix_init_widget_area');
	}
}

if (!function_exists('savalog_setup')) :
	function savalog_setup()
	{
		// Add default posts and comments RSS feed links to head.
		add_theme_support('automatic-feed-links');

		/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
		add_theme_support('title-tag');

		/*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
		add_theme_support('post-thumbnails');

		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on appside, use a find and replace
		 * to change 'savalog' to the name of your theme in all the template files.
		 */
		load_theme_textdomain('savalog', SAVALOG_TEMPLATE_DIR . '/languages');
		load_child_theme_textdomain('savalog', get_stylesheet_directory() . '/languages');

		/*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'navigation-widgets',
			)
		);

		/**
		 * Add post-formats support.
		 */
		add_theme_support(
			'post-formats',
			array(
				'link',
				'aside',
				'gallery',
				'image',
				'quote',
				'status',
				'video',
				'audio',
				'chat',
			)
		);

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height' => 300,
				'width' => 250,
				'flex-width' => true,
				'flex-height' => true,
				'unlink-homepage-logo' => true,
			)
		);

		$args = array(
			'default-text-color' => '000',
			'width'              => 1140,
			'height'             => 122,
			'flex-width'         => true,
			'flex-height'        => true,
		);
		add_theme_support('custom-header', $args);

		add_theme_support('wp-block-styles');

		// Add support for responsive embedded content.
		add_theme_support('responsive-embeds');

		add_theme_support('register_block_style');

		add_theme_support('register_block_pattern');

		// Add support for full and wide align images.
		add_theme_support('align-wide');

		add_theme_support('add_editor_style()');

		// Add support for editor styles.
		add_theme_support('editor-styles');

		$editor_stylesheet_path = 'assets/css/editor-style.css';
		// Note, the is_IE global variable is defined by WordPress and is used
		// to detect if the current browser is internet explorer.

		global $is_IE;
		if ($is_IE) {
			$editor_stylesheet_path = './assets/css/ie-editor.css';
		}
		// Enqueue editor styles.
		add_editor_style($editor_stylesheet_path);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'honrix_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);
	}
	add_action('after_setup_theme', 'savalog_setup');
endif;

require_once SAVALOG_TEMPLATE_DIR . '/inc/template-tags.php';
require_once SAVALOG_TEMPLATE_DIR . '/inc/template-functions.php';
require_once SAVALOG_TEMPLATE_DIR . '/inc/enqueue.php';
require_once SAVALOG_TEMPLATE_DIR . '/inc/widget-areas.php';
require_once SAVALOG_TEMPLATE_DIR . '/inc/customize/customize.php';
require_once SAVALOG_TEMPLATE_DIR . '/widgets/init.php';
require_once SAVALOG_TEMPLATE_DIR . '/inc/recommended_plugins.php';

if (!function_exists('savalog_custom_excerpt_length')) {
	function savalog_custom_excerpt_length($length)
	{
		if (is_admin()) {
			return $length;
		}
		return esc_attr(get_theme_mod('savalog_archive_content_length', '20'));
	}
	add_filter("excerpt_length", "savalog_custom_excerpt_length", 999);
}

if (!function_exists('savalog_custom_excerpt_more')) {
	function savalog_custom_excerpt_more($more)
	{
		if (is_admin()) {
			return $more;
		} else {
			return ' ...';
		}
	}
	add_filter('excerpt_more', 'savalog_custom_excerpt_more');
}

/*
 * Custom Comment Form
 */
if (!function_exists('savalog_custom_comment_list')) {
	function savalog_custom_comment_list($comment, $args, $depth)
	{
?>
		<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
			<div id="div-comment-<?php comment_ID(); ?>" class="comment-body d-flex p-2 mb-2">
				<?php
				if (0 != $args['avatar_size']) :
					$avatar = get_avatar($comment, $args['avatar_size']);
					if ($avatar) :
				?>
						<div class="avatar-image me-3">
							<?php echo get_avatar($comment, $args['avatar_size']); ?>
						</div>
				<?php endif;
				endif; ?>
				<div class="comment-author">
					<div class="comment-metadata d-flex">
						<div class="name w-75 fs-6 text-capitalize">
							<span class="date">
								<a href="<?php echo esc_url(get_comment_link($comment->comment_ID)); ?>">
									<?php
									$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time></span>';
									$time_string = sprintf(
										$time_string,
										esc_attr(get_comment_date(DATE_W3C)),
										esc_html(get_comment_date("j M, Y"))
									);
									echo wp_kses_post($time_string); ?>

								</a>
							</span>
							<span class="dot mx-3"></span>
							<span class="author-name">
								<span class="d-inline-block fst-italic"><?php echo esc_html__('By', 'savalog') ?></span>
								<?php echo wp_kses(get_comment_author_link(), array('a' => array('href' => array()))); ?>
							</span>
							<?php edit_comment_link(esc_html__('Edit', 'savalog'), '<span class="dot mx-3"></span>', ''); ?>
						</div>
						<div class="comment-reply w-25 text-end">
							<?php
							comment_reply_link(array_merge($args, array(
								'reply_text' => __('Reply', 'savalog'),
								'depth'      => $depth,
								'max_depth'  => $args['max_depth']
							)));
							?>
						</div>
					</div>

					<div class="comment-content entry-content">
						<?php comment_text(); ?>
					</div>
				</div>

			</div>
			<div class="comment-footer">
				<?php if ('0' == $comment->comment_approved) : ?>
					<p class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'savalog'); ?></p>
				<?php endif; ?>
			</div>
	<?php
	}
}
