<?php
/**
 * The Template Name: Home Page
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package Rehab Center
 */

get_header(); ?>

<div id="content" >
    <?php
        $rehab_center_banner = get_theme_mod('rehab_center_banner', false);
        if ($rehab_center_banner) {
            $rehab_center_banner_post_catData = get_theme_mod('rehab_center_select_banner_post_category', '0');
            if ($rehab_center_banner_post_catData !== '0') :
                $rehab_center_page_query = new WP_Query(array(
                    'category_name'  => esc_attr($rehab_center_banner_post_catData),
                    'posts_per_page' => 10,
                ));
                if ($rehab_center_page_query->have_posts()) :
        ?>
        <section id="banner-section" class="position-relative">
            <div class="container">
                <div class="banner-left-content position-relative">
                    <div class="row">
                        <div class="col-xl-7 col-lg-7 col-md-6 col-12 align-self-center position-absolute banner-inner-box p-0">
                            <?php if (get_theme_mod('rehab_center_banner_posts', false)) { ?>
                                <div class="banner-top-posts px-4 mb-2">
                                    <div class="slider-nav">
                                        <?php while ($rehab_center_page_query->have_posts()) : $rehab_center_page_query->the_post(); ?>
                                            <div class="banner-post-content">
                                                <div class="imagebox mb-2 mx-2">
                                                    <?php if (has_post_thumbnail()) {
                                                        the_post_thumbnail('medium', array('class' => 'post-image'));
                                                    } else { ?>
                                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/post-img.png" alt="<?php echo esc_attr('post image', 'rehab-center'); ?>" class="post-image" />
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        <?php endwhile; ?>
                                    </div>
                                </div>
                            <?php } ?>
                            <div class="main-content-box py-5 text-lg-start text-md-start text-center">
                                <?php if (get_theme_mod('rehab_center_banner_title') != "") { ?>
                                    <h1 class="banner-title text-capitalize mb-4"><?php echo esc_html(get_theme_mod('rehab_center_banner_title')); ?></h1>
                                <?php } ?>
                                <?php if (get_theme_mod('rehab_center_banner_description') != "") { ?>
                                    <p class="banner-text text-capitalize mb-4"><?php echo esc_html(get_theme_mod('rehab_center_banner_description')); ?></p>
                                <?php } ?>
                                <?php if (get_theme_mod('rehab_center_banner_btn_text') || get_theme_mod('rehab_center_banner_btn_url')) { ?>
                                    <div class="banner-btn">
                                        <a href="<?php echo esc_url(get_theme_mod('rehab_center_banner_btn_url')); ?>" class="text-capitalize">
                                            <?php echo esc_html(get_theme_mod('rehab_center_banner_btn_text')); ?>
                                            <i class="fa-solid fa-arrow-right ps-2"></i>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom Box -->
            <div class="banner-bottom-box position-absolute">
                <div class="container">
                    <?php if (get_theme_mod('rehab_center_banner_bottom_text') != "") { ?>
                        <div class="banner-bottom-inner d-flex align-items-center gap-5 p-2">
                            <div class="bottom-text">
                                <p class="banner-info-text text-capitalize mb-0"><?php echo esc_html(get_theme_mod('rehab_center_banner_bottom_text')); ?></p>
                            </div>
                            <div class="social-icons d-flex gap-3">
                                <?php if (get_theme_mod('rehab_center_linkedin_url')) { ?>
                                    <a href="<?php echo esc_url(get_theme_mod('rehab_center_linkedin_url')); ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                                <?php } ?>
                                <?php if (get_theme_mod('rehab_center_instagram_url')) { ?>
                                    <a href="<?php echo esc_url(get_theme_mod('rehab_center_instagram_url')); ?>"><i class="fa-brands fa-instagram"></i></a>
                                <?php } ?>
                                <?php if (get_theme_mod('rehab_center_facebook_url')) { ?>
                                    <a href="<?php echo esc_url(get_theme_mod('rehab_center_facebook_url')); ?>"><i class="fa-brands fa-facebook-f"></i></a>
                                <?php } ?>
                                <?php if (get_theme_mod('rehab_center_twitter_url')) { ?>
                                    <a href="<?php echo esc_url(get_theme_mod('rehab_center_twitter_url')); ?>"><i class="fa-brands fa-x-twitter"></i></a>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>

            <!-- Banner Right Image - SLIDER FOR -->
            <div class="banner-right-img position-absolute">
                <div class="slider-for banner-inner-image position-relative">
                    <?php
                    $rehab_center_page_query->rewind_posts();
                    while ($rehab_center_page_query->have_posts()) : $rehab_center_page_query->the_post(); ?>
                        <div class="slide-image">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'post-image'));
                            } else { ?>
                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/post-img.png" alt="<?php echo esc_attr('post image', 'rehab-center'); ?>" class="post-image" />
                            <?php } ?>
                            <div class="banner-border1 position-absolute"></div>
                            <div class="banner-border2 position-absolute"></div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
    <?php
        wp_reset_postdata();
        endif;
        endif;
    }?>


    <!-- Treatment Program Section -->
    <?php
        $rehab_center_hide_treatment_program_section = get_theme_mod('rehab_center_disabled_treatment_program_section', false);
        if ($rehab_center_hide_treatment_program_section){ ?>
        <section id="services-section" class="position-relative">
            <?php if (get_theme_mod('rehab_center_treatment_program_img') != "") { ?>
                <div class="services-img position-relative">
                    <img src="<?php echo esc_url(get_theme_mod('rehab_center_treatment_program_img')); ?>" alt="<?php echo esc_attr( 'Image', 'rehab-center'); ?>"/>
                    <div class="services-overlay position-absolute"></div>
                    <div class="container">
                        <div class="blog-bx text-center position-absolute">
                            <?php if (get_theme_mod('rehab_center_treatment_program_title') != "") { ?>
                                <h2 class="services-title text-capitalize"><?php echo esc_html(get_theme_mod('rehab_center_treatment_program_title')); ?></h2>
                                <div class="section-title-icon mt-2"><i class="fa-solid fa-shield-halved"></i></i></div>
                            <?php } ?>
                        </div> 
                    </div>
                </div>
            <?php } ?>
            <div class="container">
                <div class="services-content pb-5">
                    <div class="row">
                        <?php 
                            for ($rehab_center_i = 1; $rehab_center_i <= 4; $rehab_center_i++) {?>
                            <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 col-12 text-center mb-5">
                                <?php if (get_theme_mod('rehab_center_treatment_program_icon'.$rehab_center_i) != "" || get_theme_mod('rehab_center_treatment_program_name'.$rehab_center_i) != "" || get_theme_mod('rehab_center_treatment_program_text'.$rehab_center_i) != "" || get_theme_mod('rehab_center_treatment_program_name_url'.$rehab_center_i) != "") { ?>
                                    <div class="services-card px-3 py-5 position-relative">
                                        <div class="service-icon my-3">
                                            <?php $rehab_center_treatment_program_icon = get_theme_mod('rehab_center_treatment_program_icon'.$rehab_center_i, ''); ?><i class="<?php echo esc_attr($rehab_center_treatment_program_icon); ?>"></i>
                                        </div>
                                        <?php if (get_theme_mod('rehab_center_treatment_program_name'.$rehab_center_i) != "") { ?>
                                            <h3 class="services-name my-4 text-capitalize"><?php echo esc_html(get_theme_mod('rehab_center_treatment_program_name'.$rehab_center_i,)); ?></h3>
                                        <?php } ?>
                                        <?php if (get_theme_mod('rehab_center_treatment_program_text'.$rehab_center_i) != "") { ?>
                                            <p class="services-text mb-3 text-capitalize"><?php echo esc_html(get_theme_mod('rehab_center_treatment_program_text'.$rehab_center_i,)); ?></p>
                                        <?php } ?>
                                        <?php if (get_theme_mod('rehab_center_treatment_program_name_url'.$rehab_center_i) != "") { ?>
                                            <a target="_blank" class="card-link position-absolute" href="<?php echo esc_url(get_theme_mod('rehab_center_treatment_program_name_url'.$rehab_center_i)); ?>"><i class="fa-solid fa-arrow-right"></i></a> 
                                        <?php } ?>
                                    </div>
                                <?php }?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>
</div>
<?php get_footer(); ?>