<div class="theme-offer">
   <?php
     // POST and update the customizer and other related data of Rehab Center
    if ( isset( $_POST['submit'] ) ) {

        // Check if Classic Blog Grid plugin is installed
        if (!is_plugin_active('classic-blog-grid/classic-blog-grid.php')) {
            // Plugin slug and file path for Classic Blog Grid
            $rehab_center_plugin_slug = 'classic-blog-grid';
            $rehab_center_plugin_file = 'classic-blog-grid/classic-blog-grid.php';
        
            // Check if Classic Blog Grid is installed and activated
            if ( ! is_plugin_active( $rehab_center_plugin_file ) ) {
        
                // Check if Classic Blog Grid is installed
                $rehab_center_installed_plugins = get_plugins();
                if ( ! isset( $rehab_center_installed_plugins[ $rehab_center_plugin_file ] ) ) {
        
                    // Include necessary files to install plugins
                    include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
                    include_once( ABSPATH . 'wp-admin/includes/file.php' );
                    include_once( ABSPATH . 'wp-admin/includes/misc.php' );
                    include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
        
                    // Download and install Classic Blog Grid
                    $rehab_center_upgrader = new Plugin_Upgrader();
                    $rehab_center_upgrader->install( 'https://downloads.wordpress.org/plugin/classic-blog-grid.latest-stable.zip' );
                }
        
                // Activate the Classic Blog Grid plugin after installation (if needed)
                activate_plugin( $rehab_center_plugin_file );
            }
        }

        // ------- Create Main Menu --------
        $rehab_center_menuname = 'Primary Menu'; 
        $rehab_center_bpmenulocation = 'primary';
        $rehab_center_menu_exists = wp_get_nav_menu_object($rehab_center_menuname);

        if (!$rehab_center_menu_exists) {
            // Create a new menu
            $rehab_center_menu_id = wp_create_nav_menu($rehab_center_menuname);

            // Define pages to be created
            $rehab_center_pages = array(
                'home' => array(
                    'title' => 'Home',
                    'template' => '/templates/template-home-page.php'
                ),
                'about-us' => array(
                    'title' => 'About Us',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'our-programs' => array(
                    'title' => 'Our Programs',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'admissions' => array(
                    'title' => 'Admissions',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'resources-blog' => array(
                    'title' => 'Resources Blog',
                    'content' => ''
                ),
                'success-stories' => array(
                    'title' => 'Success Stories',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
            );

            $rehab_center_page_ids = array();

            // Loop through the pages and create them if they don’t exist
            foreach ($rehab_center_pages as $rehab_center_slug => $rehab_center_data) {
                $rehab_center_existing_page = get_page_by_path($rehab_center_slug);

                if ($rehab_center_existing_page) {
                    // If the page already exists, use its ID
                    $rehab_center_page_id = $rehab_center_existing_page->ID;
                } else {
                    // Create a new page
                    $rehab_center_page_data = array(
                        'post_type'    => 'page',
                        'post_title'   => $rehab_center_data['title'],
                        'post_content' => isset($rehab_center_data['content']) ? $rehab_center_data['content'] : '',
                        'post_status'  => 'publish',
                        'post_author'  => get_current_user_id(), // Set author dynamically
                        'post_name'    => $rehab_center_slug,
                    );

                    $rehab_center_page_id = wp_insert_post($rehab_center_page_data);

                    // Assign custom page template if specified
                    if (!empty($rehab_center_data['template'])) {
                        update_post_meta($rehab_center_page_id, '_wp_page_template', $rehab_center_data['template']);
                    }
                }

                // Store the page IDs
                $rehab_center_page_ids[$rehab_center_slug] = $rehab_center_page_id;
            }

            // Set homepage and blog page
            update_option('page_for_posts', $rehab_center_page_ids['resources-blog']);
            update_option('page_on_front', $rehab_center_page_ids['home']);
            update_option('show_on_front', 'page');

            // Define menu items
            $rehab_center_menu_items = array(
                'home',
                'about-us',
                'our-programs',
                'admissions',
                'resources-blog',
                'success-stories'
            );

            // Add menu items dynamically
            foreach ($rehab_center_menu_items as $rehab_center_slug) {
                wp_update_nav_menu_item($rehab_center_menu_id, 0, array(
                    'menu-item-title' => esc_html($rehab_center_pages[$rehab_center_slug]['title']),
                    'menu-item-url' => get_permalink($rehab_center_page_ids[$rehab_center_slug]),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $rehab_center_page_ids[$rehab_center_slug],
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type',
                ));
            }

            // Assign menu to theme location
            $rehab_center_locations = get_theme_mod('nav_menu_locations', array());
            $rehab_center_locations[$rehab_center_bpmenulocation] = $rehab_center_menu_id;
            set_theme_mod('nav_menu_locations', $rehab_center_locations);
        }

        //Logo
        set_theme_mod( 'rehab_center_the_custom_logo', esc_url( get_template_directory_uri().'/images/Logo.png'));

        //Banner Section
        set_theme_mod('rehab_center_banner', true);
        set_theme_mod('rehab_center_banner_posts', true);        
        set_theme_mod('rehab_center_banner_title', 'Hope, Healing, and Recovery Starts Here');   
        set_theme_mod('rehab_center_banner_description', 'Personalized Addiction Treatment for a Healthier Future');
        set_theme_mod('rehab_center_banner_btn_text', 'Start Your Recovery Today');
        set_theme_mod('rehab_center_banner_bottom_text', 'Let’s Walk This Path Together!');
        set_theme_mod('rehab_center_linkedin_url', '#'); 
        set_theme_mod('rehab_center_instagram_url', '#'); 
        set_theme_mod('rehab_center_facebook_url', '#'); 
        set_theme_mod('rehab_center_twitter_url', '#'); 
        set_theme_mod( 'rehab_center_banner_side_img', esc_url( get_template_directory_uri().'/images/banner.png'));

        $rehab_center_featured_category_id = wp_create_category('Slider');
        set_theme_mod('rehab_center_select_banner_post_category', 'Slider');
        
        $rehab_center_titles = array(
            'Witness the Path to Healing',
            'Empowering Recovery, Restoring Lives',
            'Your Journey to Wellness Starts Here',
            'Reclaim Your Life with Confidence',
            'Healing Begins with Compassionate Care',
            'Hope. Strength. Transformation.',
            'Guiding You Toward a Better Tomorrow',
        );                       
        $rehab_center_content = '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book."</p>';
        
        for ($rehab_center_i = 0; $rehab_center_i < 7; $rehab_center_i++) { // Fixed loop iteration
            set_theme_mod('rehab_center_title' . ($rehab_center_i + 1), $rehab_center_titles[$rehab_center_i]);
        
            $rehab_center_my_post = array(
                'post_title'    => wp_strip_all_tags($rehab_center_titles[$rehab_center_i]),
                'post_content'  => $rehab_center_content,
                'post_status'   => 'publish',
                'post_type'     => 'post',
                'post_category' => array($rehab_center_featured_category_id),
            );
        
            $rehab_center_trainer_post_id = wp_insert_post($rehab_center_my_post);
        
            if (!is_wp_error($rehab_center_trainer_post_id)) {
                $rehab_center_image_url = get_template_directory_uri() . '/images/slider' . ($rehab_center_i + 1) . '.png';
                $rehab_center_image_id = media_sideload_image($rehab_center_image_url, $rehab_center_trainer_post_id, null, 'id');
                if (!is_wp_error($rehab_center_image_id)) {
                    set_post_thumbnail($rehab_center_trainer_post_id, $rehab_center_image_id);
                } else {
                    error_log('Failed to set post thumbnail for post ID: ' . $rehab_center_trainer_post_id);
                }
            } else {
                error_log('Failed to create post: ' . print_r($rehab_center_trainer_post_id, true));
            }
        }   

        // Treatment Programs Section
        set_theme_mod('rehab_center_disabled_treatment_program_section', true);
        set_theme_mod('rehab_center_treatment_program_img', esc_url( get_template_directory_uri().'/images/program.png'));
        set_theme_mod('rehab_center_treatment_program_title', 'Treatment Programs');

        $rehab_center_treatment_icons = array('fa-solid fa-people-arrows','fa-solid fa-hand-holding-heart','fa-solid fa-brain','fa-solid fa-heart-pulse');
        $rehab_center_treatment_titles = array('Inpatient Rehabilitation','Aftercare Programs','Diagnosis Treatment','Therapy & Support');
        $rehab_center_treatment_texts = array('There are many variation passages Lorem Ipsum availbles.','There are many variation passages Lorem Ipsum availbles.','There are many variation passages Lorem Ipsum availbles.','There are many variation passages Lorem Ipsum availbles.');
        $rehab_center_treatment_links = array('#','#','#','#');
        
        for ($rehab_center_i = 1; $rehab_center_i <= 4; $rehab_center_i++) {
            set_theme_mod('rehab_center_treatment_program_icon' . $rehab_center_i, $rehab_center_treatment_icons[$rehab_center_i - 1]);
            set_theme_mod('rehab_center_treatment_program_name' . $rehab_center_i, $rehab_center_treatment_titles[$rehab_center_i - 1]);
            set_theme_mod('rehab_center_treatment_program_text' . $rehab_center_i, $rehab_center_treatment_texts[$rehab_center_i - 1]);
            set_theme_mod('rehab_center_treatment_program_name_url' . $rehab_center_i, $rehab_center_treatment_links[$rehab_center_i - 1]);
        }

        // Show success message and the "View Site" button
         echo '<div class="success">Demo Import Successful</div>';
    }
     ?>
    <ul>
        <li>
        <hr>
        <?php 
        // Check if the form is submitted
        if ( !isset( $_POST['submit'] ) ) : ?>
           <!-- Show demo importer form only if it's not submitted -->
           <?php echo esc_html( 'Click on the below content to get demo content installed.', 'rehab-center' ); ?>
          <br>
          <small><b><?php echo esc_html('Please take a backup if your website is already live with data. This importer will overwrite existing data.', 'rehab-center' ); ?></b></small>
          <br><br>

          <form id="demo-importer-form" action="" method="POST" onsubmit="return confirm('Do you really want to do this?');">
            <input type="submit" name="submit" value="<?php echo esc_attr('Run Importer','rehab-center'); ?>" class="button button-primary button-large">
          </form>
        <?php 
        endif; 

        // Show "View Site" button after form submission
        if ( isset( $_POST['submit'] ) ) {
        echo '<div class="view-site-btn">';
        echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
        echo '</div>';
        }
        ?>

        <hr>
        </li>
    </ul>
 </div>