<?php
/**
 * @package Rehab Center
 * Setup the WordPress core custom header feature.
 *
 * @uses rehab_center_header_style()
 */
function rehab_center_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'rehab_center_custom_header_args', array(
		'default-text-color'     => 'fff',
		'width'                  => 2500,
		'height'                 => 300,
		'wp-head-callback'       => 'rehab_center_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'rehab_center_custom_header_setup' );

if ( ! function_exists( 'rehab_center_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see rehab_center_custom_header_setup().
 */
function rehab_center_header_style() {
    $rehab_center_header_image = get_header_image() ?: get_template_directory_uri() . '/images/headerimg.png';

    $rehab_center_custom_css = "
        .box-image .single-page-img {
            background-image: url('{$rehab_center_header_image}');
            background-repeat: no-repeat;
            background-position: center bottom;
            background-size: cover !important;
            height: 300px;
        }

        h1.site-title a, p.site-title a {
            color: " . esc_attr(get_theme_mod('rehab_center_sitetitle_color')) . " !important;
        }

        .site-description {
            color: " . esc_attr(get_theme_mod('rehab_center_sitetagline_color')) . " !important;
        }

        .main-nav ul li a {
            color: " . esc_attr(get_theme_mod('rehab_center_menu_color')) . " !important;
        }

        .main-nav a:hover {
            color: " . esc_attr(get_theme_mod('rehab_center_menuhrv_color')) . " !important;
        }

        .main-nav ul ul a {
            color: " . esc_attr(get_theme_mod('rehab_center_submenu_color')) . " !important;
        }

        .main-nav ul ul a:hover {
            color: " . esc_attr(get_theme_mod('rehab_center_submenuhrv_color')) . " !important;
        }

        .copywrap, .copywrap a {
            color: " . esc_attr(get_theme_mod('rehab_center_footercoypright_color')) . " !important;
        }

        #footer h3 {
            color: " . esc_attr(get_theme_mod('rehab_center_footertitle_color')) . " !important;
        }

        #footer p {
            color: " . esc_attr(get_theme_mod('rehab_center_footerdescription_color')) . ";
        }

        #footer ul li a {
            color: " . esc_attr(get_theme_mod('rehab_center_footerlist_color')) . ";
        }

        #footer {
            background-color: " . esc_attr(get_theme_mod('rehab_center_footerbg_color')) . ";
        }
    ";

    // Attach to your main stylesheet (make sure this handle matches the one you registered)
    wp_add_inline_style('rehab-center-style', $rehab_center_custom_css);
}
endif;
add_action('wp_enqueue_scripts', 'rehab_center_header_style');