<?php
/**
 * Template Name: Home Template
 */

get_header(); ?>

<main id="skip-content">
  <?php if (get_theme_mod('recipe_maker_slider_section_setting', true) != '') { ?>
    <section id="top-slider">
      <div class="row m-0">
        <div class="col-lg-4 col-md-3 ps-0 align-self-center">
          <div class="left-box-empty"></div>
        </div>
        <div class="col-lg-8 col-md-9 slider-right align-self-center" style="background-image: url(<?php echo esc_url(get_theme_mod('recipe_maker_slider_right_background_image')); ?>)">
          <?php $recipe_maker_slide_pages = array();
            for ( $recipe_maker_count = 1; $recipe_maker_count <= 3; $recipe_maker_count++ ) {
              $recipe_maker_mod = intval( get_theme_mod( 'recipe_maker_top_slider_page' . $recipe_maker_count ));
              if ( 'page-none-selected' != $recipe_maker_mod ) {
                $recipe_maker_slide_pages[] = $recipe_maker_mod;
              }
            }
            if( !empty($recipe_maker_slide_pages) ) :
              $recipe_maker_args = array(
                'post_type' => 'page',
                'post__in' => $recipe_maker_slide_pages,
                'orderby' => 'post__in'
              );
              $recipe_maker_query = new WP_Query( $recipe_maker_args );
              if ( $recipe_maker_query->have_posts() ) :
                $i = 1;
          ?>
          <div id="combinedCarousel" class="owl-carousel" role="listbox">
            <?php  while ( $recipe_maker_query->have_posts() ) : $recipe_maker_query->the_post(); ?>
              <div class="slide-box row">
                <div class="col-xl-4 col-lg-5 col-md-5  align-self-center slider-image">
                  <?php if(has_post_thumbnail()){
                      the_post_thumbnail();
                      } else{?>
                  <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/slider.png" alt="" />
                  <?php } ?>
                </div>
                <div class="col-xl-8 col-lg-7 col-md-7 align-self-center slider-inner-box">
                  <?php if(get_theme_mod('recipe_maker_slider_short_heading') != ''){ ?>
                  <h5 class="main-heading mb-4">
                    <?php echo esc_html(get_theme_mod('recipe_maker_slider_short_heading')); ?></h5>
                  <?php }?>
                  <a href="<?php the_permalink(); ?>"><h3 class="m-0"><?php the_title(); ?></h3></a>
                  <p class="content mt-3"><?php echo esc_html( wp_trim_words( get_the_content(),70 )); ?></p>
                </div>
              </div>
            <?php $i++; endwhile;
             wp_reset_postdata();?>
            <?php else : ?>
            <div class="no-postfound"></div>
            <?php endif;
            endif;?>
          </div>
        </div>
     </div>
    </section>
  <?php }?>

  <?php if (get_theme_mod('recipe_maker_categories_section_setting', true) != '') { ?>
    <section id="top-categories" class="py-5">
      <div class="container">
        <div class="categorie-heading">
          <?php if(get_theme_mod('recipe_maker_categorie_short_heading') != ''){ ?>
            <h4 class="main-heading m-0"><?php echo esc_html(get_theme_mod('recipe_maker_categorie_short_heading')); ?></h4>
          <?php }?>
          <?php if(get_theme_mod('recipe_maker_categorie_heading') != ''){ ?>
            <h3 class="main-heading"><?php echo esc_html(get_theme_mod('recipe_maker_categorie_heading')); ?></h3>
          <?php }?>
        </div>
        <div class="owl-carousel mt-5 ser-box">
          <?php
            $recipe_maker_services_cat = get_theme_mod('recipe_maker_services_sec_category','');
            if($recipe_maker_services_cat){
              $recipe_maker_page_query5 = new WP_Query(array( 'category_name' => esc_html($recipe_maker_services_cat,'recipe-maker'),'posts_per_page' => 8));
              $i=1;
              while( $recipe_maker_page_query5->have_posts() ) : $recipe_maker_page_query5->the_post(); ?>
                <div class="service-box row">
                  <div class="col-xl-5 col-lg-6 col-md-5 col-sm-5 col-5 service-icon align-self-center ps-0">
                    <?php if(has_post_thumbnail()){
                      the_post_thumbnail();
                      } else{?>
                      <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/slider.png" alt="" />
                    <?php } ?>
                  </div>
                  <div class="col-xl-7 col-lg-6 col-md-7 col-sm-7 col-7 team-content align-self-center">
                    <?php 
                      $category = get_the_category(); 
                      if ( ! empty( $category ) ) {
                        echo '<span class="category-div">' . esc_html( $category[0]->name ) . '</span>'; 
                      }
                    ?>
                    <h4 class="mb-0 mt-1"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                    <div class="arrow-button">
                      <a class="category-title" href="<?php the_permalink(); ?>">
                        <i class="fas fa-arrow-right"></i>
                      </a>
                    </div>
                  </div>
                </div>
              <?php $i++; endwhile;
            wp_reset_postdata();
          } ?>
        </div>
      </div>
    </section>
  <?php }?>

  <?php if (get_theme_mod('recipe_maker_activities_section_setting', true) != '') { ?>
  <section class="featured py-5">
    <div class="container">
      <div class="row mb-3">
        <div class="col-lg-9 col-md-9 align-self-center">
          <div class="row offer-left-box">
            <div class="col-xl-4 col-lg-5 col-md-5 align-self-center left-image-box ps-0">
              <?php if(get_theme_mod('recipe_maker_flash_sale_section_image_left') != ''){ ?>
                <img src="<?php echo esc_url( get_theme_mod( 'recipe_maker_flash_sale_section_image_left' )); ?>">
              <?php }?>
            </div>
            <div class="col-xl-8 col-lg-7 col-md-7 align-self-center flash-sale-content">
              <?php if(get_theme_mod('recipe_maker_flash_sale_short_heading') != ''){ ?>
                <h6 class="main-heading mb-1"><?php echo esc_html(get_theme_mod('recipe_maker_flash_sale_short_heading')); ?></h6>
              <?php }?>
              <?php if(get_theme_mod('recipe_maker_flash_sale_heading') != ''){ ?>
                <h4 class="main-heading"><?php echo esc_html(get_theme_mod('recipe_maker_flash_sale_heading')); ?></h4>
              <?php }?>
              <?php if(get_theme_mod('recipe_maker_clock_timer_end') != ''){ ?>
                <div class="countdowntimer text-center mt-3">
                  <p id="timer" class="countdown">
                    <?php 
                    $recipe_maker_dateday = get_theme_mod('recipe_maker_clock_timer_end','30 Jan 2025');
                    $recipe_maker_startday = get_theme_mod('recipe_maker_clock_timer_start','29 Jan 2025 16:13');
                    ?>
                    <input type="hidden" class="date" value="<?php echo esc_html($recipe_maker_dateday); ?>">
                    <input type="hidden" class="date-start" value="<?php echo esc_html($recipe_maker_startday); ?>">
                  </p>
                </div>
              <?php }?>
              <div class="progress-bar-container">
                <div id="progress-bar" ></div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-3 col-md-3 align-self-center right-image">
          <?php if(get_theme_mod('recipe_maker_flash_sale_section_image_right') != ''){ ?>
            <img src="<?php echo esc_url( get_theme_mod( 'recipe_maker_flash_sale_section_image_right' )); ?>">
          <?php }?>
        </div>
      </div>
    </div>
  </section>
  <?php }?>
  <section id="page-content">
    <div class="container">
      <div class="py-5">
        <?php
          if ( have_posts() ) :
            while ( have_posts() ) : the_post();
              the_content();
            endwhile;
          endif;
        ?>
      </div>
    </div>
  </section>
</main>

<?php get_footer(); ?>