<?php
/**
 * Recipe Maker Theme Customizer
 *
 * @link: https://developer.wordpress.org/themes/customize-api/customizer-objects/
 *
 * @package Recipe Maker
 */

if ( ! defined( 'RECIPE_MAKER_URL' ) ) {
    define( 'RECIPE_MAKER_URL', esc_url( 'https://www.themagnifico.net/products/recipe-blog-wordpress-theme', 'recipe-maker') );
}
if ( ! defined( 'RECIPE_MAKER_TEXT' ) ) {
    define( 'RECIPE_MAKER_TEXT', __( 'Recipe Maker Pro','recipe-maker' ));
}
if ( ! defined( 'RECIPE_MAKER_BUY_TEXT' ) ) {
    define( 'RECIPE_MAKER_BUY_TEXT', __( 'Buy Recipe Maker Pro','recipe-maker' ));
}

use WPTRT\Customize\Section\Recipe_Maker_Button;

add_action( 'customize_register', function( $manager ) {

    $manager->register_section_type( Recipe_Maker_Button::class );

    $manager->add_section(
        new Recipe_Maker_Button( $manager, 'recipe_maker_pro', [
            'title'       => esc_html( RECIPE_MAKER_TEXT,'recipe-maker' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'recipe-maker' ),
            'button_url'  => esc_url( RECIPE_MAKER_URL )
        ] )
    );

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

    $version = wp_get_theme()->get( 'Version' );

    wp_enqueue_script(
        'recipe-maker-customize-section-button',
        get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
        [ 'customize-controls' ],
        $version,
        true
    );

    wp_enqueue_style(
        'recipe-maker-customize-section-button',
        get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
        [ 'customize-controls' ],
        $version
    );

} );

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function recipe_maker_customize_register($wp_customize){

    // Pro Version
    class Recipe_Maker_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>For More <strong>'. esc_html( $this->label ) .'</strong>?</span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( RECIPE_MAKER_BUY_TEXT,'recipe-maker' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function Recipe_Maker_sanitize_custom_control( $input ) {
        return $input;
    }

    $wp_customize->get_setting('blogname')->transport = 'postMessage';
    $wp_customize->get_setting('blogdescription')->transport = 'postMessage';

    $wp_customize->add_setting('recipe_maker_logo_title_text', array(
        'default' => true,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_logo_title_text',array(
        'label'          => __( 'Enable Disable Title', 'recipe-maker' ),
        'section'        => 'title_tagline',
        'settings'       => 'recipe_maker_logo_title_text',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_logo_title_font_size',array(
        'default'   => '',
        'sanitize_callback' => 'recipe_maker_sanitize_number_absint'
    ));
    $wp_customize->add_control('recipe_maker_logo_title_font_size',array(
        'label' => esc_html__('Title Font Size','recipe-maker'),
        'section' => 'title_tagline',
        'type'    => 'number'
    ));

    $wp_customize->add_setting('recipe_maker_theme_description', array(
        'default' => false,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_theme_description',array(
        'label'          => __( 'Enable Disable Tagline', 'recipe-maker' ),
        'section'        => 'title_tagline',
        'settings'       => 'recipe_maker_theme_description',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_logo_tagline_font_size',array(
        'default'   => '',
        'sanitize_callback' => 'recipe_maker_sanitize_number_absint'
    ));
    $wp_customize->add_control('recipe_maker_logo_tagline_font_size',array(
        'label' => esc_html__('Tagline Font Size','recipe-maker'),
        'section'   => 'title_tagline',
        'type'      => 'number'
    ));

    //Logo
    $wp_customize->add_setting('recipe_maker_logo_max_height',array(
        'default'   => '200',
        'sanitize_callback' => 'recipe_maker_sanitize_number_absint'
    ));
    $wp_customize->add_control('recipe_maker_logo_max_height',array(
        'label' => esc_html__('Logo Width','recipe-maker'),
        'section'   => 'title_tagline',
        'type'      => 'number'
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_logo', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_logo', array(
                'section'     => 'title_tagline',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );

    // Global Color Settings
     $wp_customize->add_section('recipe_maker_global_color_settings',array(
        'title' => esc_html__('Global Settings','recipe-maker'),
        'priority'   => 28,
    ));

    $wp_customize->add_setting( 'recipe_maker_global_color', array(
        'default' => '#F3D333',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_global_color', array(
        'description' => __('Change the global color of the theme in one click.', 'recipe-maker'),
        'section' => 'recipe_maker_global_color_settings',
        'settings' => 'recipe_maker_global_color',
    )));

    //Typography option
    $recipe_maker_font_array = array(
        ''                       => 'No Fonts',
        'Abril Fatface'          => 'Abril Fatface',
        'Acme'                   => 'Acme',
        'Anton'                  => 'Anton',
        'Architects Daughter'    => 'Architects Daughter',
        'Arimo'                  => 'Arimo',
        'Arsenal'                => 'Arsenal',
        'Arvo'                   => 'Arvo',
        'Alegreya'               => 'Alegreya',
        'Alfa Slab One'          => 'Alfa Slab One',
        'Averia Serif Libre'     => 'Averia Serif Libre',
        'Bangers'                => 'Bangers',
        'Boogaloo'               => 'Boogaloo',
        'Bad Script'             => 'Bad Script',
        'Bitter'                 => 'Bitter',
        'Bree Serif'             => 'Bree Serif',
        'BenchNine'              => 'BenchNine',
        'Cabin'                  => 'Cabin',
        'Cardo'                  => 'Cardo',
        'Courgette'              => 'Courgette',
        'Cherry Swash'           => 'Cherry Swash',
        'Cormorant Garamond'     => 'Cormorant Garamond',
        'Crimson Text'           => 'Crimson Text',
        'Cuprum'                 => 'Cuprum',
        'Cookie'                 => 'Cookie',
        'Chewy'                  => 'Chewy',
        'Days One'               => 'Days One',
        'Dosis'                  => 'Dosis',
        'Droid Sans'             => 'Droid Sans',
        'Economica'              => 'Economica',
        'Fredoka One'            => 'Fredoka One',
        'Fjalla One'             => 'Fjalla One',
        'Francois One'           => 'Francois One',
        'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
        'Gloria Hallelujah'      => 'Gloria Hallelujah',
        'Great Vibes'            => 'Great Vibes',
        'Handlee'                => 'Handlee',
        'Hammersmith One'        => 'Hammersmith One',
        'Inconsolata'            => 'Inconsolata',
        'Indie Flower'           => 'Indie Flower',
        'IM Fell English SC'     => 'IM Fell English SC',
        'Julius Sans One'        => 'Julius Sans One',
        'Josefin Slab'           => 'Josefin Slab',
        'Josefin Sans'           => 'Josefin Sans',
        'Kanit'                  => 'Kanit',
        'Lobster'                => 'Lobster',
        'Lato'                   => 'Lato',
        'Lora'                   => 'Lora',
        'Libre Baskerville'      => 'Libre Baskerville',
        'Lobster Two'            => 'Lobster Two',
        'Merriweather'           => 'Merriweather',
        'Monda'                  => 'Monda',
        'Montserrat'             => 'Montserrat',
        'Muli'                   => 'Muli',
        'Marck Script'           => 'Marck Script',
        'Noto Serif'             => 'Noto Serif',
        'Open Sans'              => 'Open Sans',
        'Overpass'               => 'Overpass',
        'Overpass Mono'          => 'Overpass Mono',
        'Oxygen'                 => 'Oxygen',
        'Orbitron'               => 'Orbitron',
        'Patua One'              => 'Patua One',
        'Pacifico'               => 'Pacifico',
        'Padauk'                 => 'Padauk',
        'Playball'               => 'Playball',
        'Playfair Display'       => 'Playfair Display',
        'PT Sans'                => 'PT Sans',
        'Philosopher'            => 'Philosopher',
        'Permanent Marker'       => 'Permanent Marker',
        'Poiret One'             => 'Poiret One',
        'Quicksand'              => 'Quicksand',
        'Quattrocento Sans'      => 'Quattrocento Sans',
        'Raleway'                => 'Raleway',
        'Rubik'                  => 'Rubik',
        'Roboto'                 => 'Roboto',
        'Rokkitt'                => 'Rokkitt',
        'Russo One'              => 'Russo One',
        'Righteous'              => 'Righteous',
        'Slabo'                  => 'Slabo',
        'Source Sans Pro'        => 'Source Sans Pro',
        'Shadows Into Light Two' => 'Shadows Into Light Two',
        'Shadows Into Light'     => 'Shadows Into Light',
        'Sacramento'             => 'Sacramento',
        'Shrikhand'              => 'Shrikhand',
        'Tangerine'              => 'Tangerine',
        'Ubuntu'                 => 'Ubuntu',
        'VT323'                  => 'VT323',
        'Varela Round'           => 'Varela Round',
        'Vampiro One'            => 'Vampiro One',
        'Vollkorn'               => 'Vollkorn',
        'Volkhov'                => 'Volkhov',
        'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
    );

    // Heading Typography
    $wp_customize->add_setting( 'recipe_maker_heading_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_heading_color', array(
        'label' => __('Heading Color', 'recipe-maker'),
        'section' => 'recipe_maker_global_color_settings',
        'settings' => 'recipe_maker_heading_color',
    )));

    $wp_customize->add_setting('recipe_maker_heading_font_family', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'recipe_maker_sanitize_choices',
    ));
    $wp_customize->add_control( 'recipe_maker_heading_font_family', array(
        'section' => 'recipe_maker_global_color_settings',
        'label'   => __('Heading Fonts', 'recipe-maker'),
        'type'    => 'select',
        'choices' => $recipe_maker_font_array,
    ));

    $wp_customize->add_setting('recipe_maker_heading_font_size',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_heading_font_size',array(
        'label' => esc_html__('Heading Font Size','recipe-maker'),
        'section' => 'recipe_maker_global_color_settings',
        'setting' => 'recipe_maker_heading_font_size',
        'type'  => 'text'
    ));

    // Paragraph Typography
    $wp_customize->add_setting( 'recipe_maker_paragraph_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_paragraph_color', array(
        'label' => __('Paragraph Color', 'recipe-maker'),
        'section' => 'recipe_maker_global_color_settings',
        'settings' => 'recipe_maker_paragraph_color',
    )));

    $wp_customize->add_setting('recipe_maker_paragraph_font_family', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'recipe_maker_sanitize_choices',
    ));
    $wp_customize->add_control( 'recipe_maker_paragraph_font_family', array(
        'section' => 'recipe_maker_global_color_settings',
        'label'   => __('Paragraph Fonts', 'recipe-maker'),
        'type'    => 'select',
        'choices' => $recipe_maker_font_array,
    ));

    $wp_customize->add_setting('recipe_maker_paragraph_font_size',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_paragraph_font_size',array(
        'label' => esc_html__('Paragraph Font Size','recipe-maker'),
        'section' => 'recipe_maker_global_color_settings',
        'setting' => 'recipe_maker_paragraph_font_size',
        'type'  => 'text'
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_global_color_settings', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_global_color_settings', array(
                'section'     => 'recipe_maker_global_color_settings',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );

    // General Settings
     $wp_customize->add_section('recipe_maker_general_settings',array(
        'title' => esc_html__('General Settings','recipe-maker'),
        'priority'   => 30,
    ));

     $wp_customize->add_setting('recipe_maker_width_option',array(
        'default' => 'Full Width',
        'transport' => 'refresh',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control('recipe_maker_width_option',array(
        'type' => 'select',
        'section' => 'recipe_maker_general_settings',
        'choices' => array(
            'Full Width' => __('Full Width','recipe-maker'),
            'Wide Width' => __('Wide Width','recipe-maker'),
            'Boxed Width' => __('Boxed Width','recipe-maker')
        ),
    ) );

    $wp_customize->add_setting('recipe_maker_nav_menu_text_transform',array(
        'default'=> 'Uppercase',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control('recipe_maker_nav_menu_text_transform',array(
        'type' => 'radio',
        'choices' => array(
            'Uppercase' => __('Uppercase','recipe-maker'),
            'Capitalize' => __('Capitalize','recipe-maker'),
            'Lowercase' => __('Lowercase','recipe-maker'),
        ),
        'section'=> 'recipe_maker_general_settings',
    ));

    $wp_customize->add_setting('recipe_maker_preloader_hide', array(
        'default' => 0,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_preloader_hide',array(
        'label'          => __( 'Show Theme Preloader', 'recipe-maker' ),
        'section'        => 'recipe_maker_general_settings',
        'settings'       => 'recipe_maker_preloader_hide',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_preloader_type',array(
        'default' => 'Preloader 1',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control('recipe_maker_preloader_type',array(
        'type' => 'radio',
        'label' => esc_html__('Preloader Type','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'choices' => array(
            'Preloader 1' => __('Preloader 1','recipe-maker'),
            'Preloader 2' => __('Preloader 2','recipe-maker'),
        ),
    ) );

    $wp_customize->add_setting( 'recipe_maker_preloader_bg_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_preloader_bg_color', array(
        'label' => esc_html__('Preloader Background Color','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'settings' => 'recipe_maker_preloader_bg_color'
    )));

    $wp_customize->add_setting( 'recipe_maker_preloader_dot_1_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_preloader_dot_1_color', array(
        'label' => esc_html__('Preloader First Dot Color','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'settings' => 'recipe_maker_preloader_dot_1_color',
        'active_callback' => 'recipe_maker_preloader1'
    )));

    $wp_customize->add_setting( 'recipe_maker_preloader_dot_2_color', array(
        'default' => '#222222',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_preloader_dot_2_color', array(
        'label' => esc_html__('Preloader Second Dot Color','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'settings' => 'recipe_maker_preloader_dot_2_color',
        'active_callback' => 'recipe_maker_preloader1'
    )));

    $wp_customize->add_setting( 'recipe_maker_preloader2_dot_color', array(
        'default' => '#F3D333',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_preloader2_dot_color', array(
        'label' => esc_html__('Preloader Dot Color','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'settings' => 'recipe_maker_preloader2_dot_color',
        'active_callback' => 'recipe_maker_preloader2'
    )));

    $wp_customize->add_setting('recipe_maker_scroll_hide', array(
        'default' => true,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_scroll_hide',array(
        'label'          => __( 'Show Theme Scroll To Top', 'recipe-maker' ),
        'section'        => 'recipe_maker_general_settings',
        'settings'       => 'recipe_maker_scroll_hide',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_scroll_top_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control('recipe_maker_scroll_top_position',array(
        'type' => 'radio',
        'section' => 'recipe_maker_general_settings',
        'choices' => array(
            'Right' => __('Right','recipe-maker'),
            'Left' => __('Left','recipe-maker'),
            'Center' => __('Center','recipe-maker')
        ),
    ) );

    $wp_customize->add_setting( 'recipe_maker_scroll_bg_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_scroll_bg_color', array(
        'label' => esc_html__('Scroll Top Background Color','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'settings' => 'recipe_maker_scroll_bg_color'
    )));

    $wp_customize->add_setting( 'recipe_maker_scroll_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recipe_maker_scroll_color', array(
        'label' => esc_html__('Scroll Top Color','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'settings' => 'recipe_maker_scroll_color'
    )));

    $wp_customize->add_setting('recipe_maker_scroll_font_size',array(
        'default'   => '16',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_scroll_font_size',array(
        'label' => __('Scroll Top Font Size','recipe-maker'),
        'description' => __('Put in px','recipe-maker'),
        'section'   => 'recipe_maker_general_settings',
        'type'      => 'number'
    ));

    $wp_customize->add_setting('recipe_maker_scroll_border_radius',array(
        'default'   => '0',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_scroll_border_radius',array(
        'label' => __('Scroll Top Border Radius','recipe-maker'),
        'description' => __('Put in %','recipe-maker'),
        'section'   => 'recipe_maker_general_settings',
        'type'      => 'number'
    ));

    // Product Columns
    $wp_customize->add_setting( 'recipe_maker_products_per_row' , array(
       'default'           => '3',
       'transport'         => 'refresh',
       'sanitize_callback' => 'recipe_maker_sanitize_select',
    ) );

    $wp_customize->add_control('recipe_maker_products_per_row', array(
       'label' => __( 'Product per row', 'recipe-maker' ),
       'section'  => 'recipe_maker_general_settings',
       'type'     => 'select',
       'choices'  => array(
           '2' => '2',
           '3' => '3',
           '4' => '4',
       ),
    ) );

    $wp_customize->add_setting('recipe_maker_product_per_page',array(
        'default'   => '9',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_product_per_page',array(
        'label' => __('Product per page','recipe-maker'),
        'section'   => 'recipe_maker_general_settings',
        'type'      => 'number'
    ));

    //Woocommerce shop page Sidebar
    $wp_customize->add_setting('recipe_maker_woocommerce_shop_page_sidebar', array(
        'default' => true,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_woocommerce_shop_page_sidebar',array(
        'label'          => __( 'Hide Shop Page Sidebar', 'recipe-maker' ),
        'section'        => 'recipe_maker_general_settings',
        'settings'       => 'recipe_maker_woocommerce_shop_page_sidebar',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_shop_page_sidebar_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control('recipe_maker_shop_page_sidebar_layout',array(
        'type' => 'select',
        'label' => __('Woocommerce Shop Page Sidebar','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','recipe-maker'),
            'Right Sidebar' => __('Right Sidebar','recipe-maker'),
        ),
    ) );

     // Product Columns
    $wp_customize->add_setting('custom_related_products_number_per_row',array(
        'default'           => '3',
        'transport'         => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('custom_related_products_number_per_row',array(
        'label'       => esc_html__('Related Products Column Count', 'recipe-maker'),
        'section'     => 'recipe_maker_general_settings',
        'type'        => 'number',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 1,
            'max'  => 4,
        ),
    ));

    // Product Columns
    $wp_customize->add_setting('custom_related_products_number',array(
        'default'           => '3',
        'transport'         => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('custom_related_products_number',array(
        'label'       => esc_html__('Number of Related Products Per Page', 'recipe-maker'),
        'section'     => 'recipe_maker_general_settings',
        'type'        => 'number',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 1,
            'max'  => 10,
        ),
    ));

    $wp_customize->add_setting('recipe_maker_related_product_display_setting', array(
        'default' => true,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_related_product_display_setting',array(
        'label'          => __( 'Show Related Products', 'recipe-maker' ),
        'section'        => 'recipe_maker_general_settings',
        'settings'       => 'recipe_maker_related_product_display_setting',
        'type'           => 'checkbox',
    )));

    //Woocommerce Single Product page Sidebar
    $wp_customize->add_setting('recipe_maker_woocommerce_single_product_page_sidebar', array(
        'default' => true,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_woocommerce_single_product_page_sidebar',array(
        'label'          => __( 'Hide Single Product Page Sidebar', 'recipe-maker' ),
        'section'        => 'recipe_maker_general_settings',
        'settings'       => 'recipe_maker_woocommerce_single_product_page_sidebar',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_single_product_sidebar_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control('recipe_maker_single_product_sidebar_layout',array(
        'type' => 'select',
        'label' => __('Woocommerce Single Product Page Sidebar','recipe-maker'),
        'section' => 'recipe_maker_general_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','recipe-maker'),
            'Right Sidebar' => __('Right Sidebar','recipe-maker'),
        ),
    ) );

    // Pro Version
    $wp_customize->add_setting( 'pro_version_general_settings', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_general_settings', array(
                'section'     => 'recipe_maker_general_settings',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );

     // Social Link
    $wp_customize->add_section('recipe_maker_social_link',array(
        'title' => esc_html__('Social Links','recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_facebook_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_facebook_icon',array(
        'label' => esc_html__('Facebook Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_facebook_icon',
        'type'  => 'text',
        'default' => 'fab fa-facebook-f',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-facebook-f','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_facebook_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_facebook_url',array(
        'label' => esc_html__('Facebook Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_facebook_url',
        'type'  => 'url'
    ));

    $wp_customize->add_setting('recipe_maker_twitter_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_twitter_icon',array(
        'label' => esc_html__('Twitter Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_twitter_icon',
        'type'  => 'text',
        'default' => 'fab fa-twitter',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-twitter','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_twitter_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_twitter_url',array(
        'label' => esc_html__('Twitter Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_twitter_url',
        'type'  => 'url'
    ));

    $wp_customize->add_setting('recipe_maker_intagram_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_intagram_icon',array(
        'label' => esc_html__('Intagram Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_intagram_icon',
        'type'  => 'text',
        'default' => 'fab fa-instagram',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-instagram','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_intagram_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_intagram_url',array(
        'label' => esc_html__('Intagram Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_intagram_url',
        'type'  => 'url'
    ));

    $wp_customize->add_setting('recipe_maker_linkedin_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_linkedin_icon',array(
        'label' => esc_html__('Linkedin Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_linkedin_icon',
        'type'  => 'text',
        'default' => 'fab fa-linkedin-in',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-linkedin-in','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_linkedin_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_linkedin_url',array(
        'label' => esc_html__('Linkedin Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_linkedin_url',
        'type'  => 'url'
    ));

    $wp_customize->add_setting('recipe_maker_pintrest_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_pintrest_icon',array(
        'label' => esc_html__('Pinterest Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_pintrest_icon',
        'type'  => 'text',
        'default' => 'fab fa-pinterest-p',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-pinterest-p','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_pintrest_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_pintrest_url',array(
        'label' => esc_html__('Pinterest Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_pintrest_url',
        'type'  => 'url'
    ));

     // Social Link
    $wp_customize->add_section('recipe_maker_social_link',array(
        'title' => esc_html__('Social Links','recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_facebook_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_facebook_icon',array(
        'label' => esc_html__('Facebook Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_facebook_icon',
        'type'  => 'text',
        'default' => 'fab fa-facebook-f',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-facebook-f','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_facebook_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_facebook_url',array(
        'label' => esc_html__('Facebook Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_facebook_url',
        'type'  => 'url'
    ));

    $wp_customize->add_setting('recipe_maker_twitter_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_twitter_icon',array(
        'label' => esc_html__('Twitter Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_twitter_icon',
        'type'  => 'text',
        'default' => 'fab fa-twitter',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-twitter','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_twitter_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_twitter_url',array(
        'label' => esc_html__('Twitter Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_twitter_url',
        'type'  => 'url'
    ));

    $wp_customize->add_setting('recipe_maker_intagram_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_intagram_icon',array(
        'label' => esc_html__('Intagram Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_intagram_icon',
        'type'  => 'text',
        'default' => 'fab fa-instagram',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-instagram','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_intagram_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_intagram_url',array(
        'label' => esc_html__('Intagram Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_intagram_url',
        'type'  => 'url'
    ));

    $wp_customize->add_setting('recipe_maker_linkedin_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_linkedin_icon',array(
        'label' => esc_html__('Linkedin Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_linkedin_icon',
        'type'  => 'text',
        'default' => 'fab fa-linkedin-in',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-linkedin-in','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_linkedin_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_linkedin_url',array(
        'label' => esc_html__('Linkedin Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_linkedin_url',
        'type'  => 'url'
    ));

    $wp_customize->add_setting('recipe_maker_pintrest_icon',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_pintrest_icon',array(
        'label' => esc_html__('Pinterest Icon','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_pintrest_icon',
        'type'  => 'text',
        'default' => 'fab fa-pinterest-p',
        'description' =>  __('Select font awesome icons <a target="_blank" href="https://fontawesome.com/v5/search?m=free">Click Here</a> for select icon. for eg:-fab fa-pinterest-p','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_pintrest_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('recipe_maker_pintrest_url',array(
        'label' => esc_html__('Pinterest Link','recipe-maker'),
        'section' => 'recipe_maker_social_link',
        'setting' => 'recipe_maker_pintrest_url',
        'type'  => 'url'
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_social_link', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_social_link', array(
                'section'     => 'recipe_maker_social_link',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );


    //Top Header
    $wp_customize->add_section('recipe_maker_top_header',array(
        'title' => esc_html__(' Header Option','recipe-maker')
    ));

    $wp_customize->add_setting('recipe_maker_topbar_text',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_topbar_text',array(
        'label' => esc_html__('Topbar Text','recipe-maker'),
        'section' => 'recipe_maker_top_header',
        'setting' => 'recipe_maker_topbar_text',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('recipe_maker_topbar1_wishlist_url',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_topbar1_wishlist_url',array(
        'label' => esc_html__('Wishlist Url','recipe-maker'),
        'section' => 'recipe_maker_top_header',
        'setting' => 'recipe_maker_topbar1_wishlist_url',
        'type'  => 'url'
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_top_header', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_top_header', array(
                'section'     => 'recipe_maker_top_header',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );

    //Slider
    $wp_customize->add_section('recipe_maker_top_slider',array(
        'title' => esc_html__('Slider Settings','recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_slider_section_setting', array(
        'default' => true,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_slider_section_setting',array(
        'label'          => __( 'Show Slider', 'recipe-maker' ),
        'section'        => 'recipe_maker_top_slider',
        'settings'       => 'recipe_maker_slider_section_setting',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_slider_right_background_image',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( 
    $wp_customize,'recipe_maker_slider_right_background_image',array(
        'label' => __('Slider Background Image ','recipe-maker'),
        'description' => __('Dimension 700 x 140 ','recipe-maker'),
        'section' => 'recipe_maker_top_slider',
        'settings' => 'recipe_maker_slider_right_background_image',
    )));

    for ( $recipe_maker_count = 1; $recipe_maker_count <= 3; $recipe_maker_count++ ) {

        $wp_customize->add_setting( 'recipe_maker_top_slider_page' . $recipe_maker_count, array(
            'default'           => '',
            'sanitize_callback' => 'recipe_maker_sanitize_dropdown_pages'
        ) );
        $wp_customize->add_control( 'recipe_maker_top_slider_page' . $recipe_maker_count, array(
            'label'    => __( 'Select Slide Page', 'recipe-maker' ),
            'description' => __('Slider image size (1400 x 550)','recipe-maker'),
            'section'  => 'recipe_maker_top_slider',
            'type'     => 'dropdown-pages'
        ) );
    }

    $wp_customize->add_setting('recipe_maker_slider_short_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_slider_short_heading',array(
        'label' => esc_html__('Short Heading','recipe-maker'),
        'section' => 'recipe_maker_top_slider',
        'setting' => 'recipe_maker_slider_short_heading',
        'type'  => 'text'
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_top_slider', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_top_slider', array(
                'section'     => 'recipe_maker_top_slider',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );

    //Categories Section
    $wp_customize->add_section('recipe_maker_top_categories',array(
        'title' => esc_html__('Categories Settings','recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_categories_section_setting', array(
        'default' => true,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_categories_section_setting',array(
        'label'          => __( 'Show Categories', 'recipe-maker' ),
        'section'        => 'recipe_maker_top_categories',
        'settings'       => 'recipe_maker_categories_section_setting',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_categorie_short_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_categorie_short_heading',array(
        'label' => esc_html__('Categories Short Heading','recipe-maker'),
        'section' => 'recipe_maker_top_categories',
        'setting' => 'recipe_maker_categorie_short_heading',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('recipe_maker_categorie_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_categorie_heading',array(
        'label' => esc_html__('Categories Heading','recipe-maker'),
        'section' => 'recipe_maker_top_categories',
        'setting' => 'recipe_maker_categorie_heading',
        'type'  => 'text'
    ));

    $categories = get_categories();
    $cat_post = array();
    $cat_post[]= 'select';
    $i = 0;
    foreach($categories as $category){
        if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_post[$category->slug] = $category->name;
    }

    $wp_customize->add_setting('recipe_maker_services_sec_category',array(
        'default'   => 'select',
        'sanitize_callback' => 'recipe_maker_sanitize_select',
    ));
    $wp_customize->add_control('recipe_maker_services_sec_category',array(
        'type'    => 'select',
        'choices' => $cat_post,
        'label' => __('Select Category to display Category Post','recipe-maker'),
        'section' => 'recipe_maker_top_categories',
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_top_categories', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_top_categories', array(
                'section'     => 'recipe_maker_top_categories',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );

    // Flash Sale
    $wp_customize->add_section('recipe_maker_services_section',array(
        'title' => esc_html__('Flash Sale Option','recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_activities_section_setting', array(
        'default' => false,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'recipe_maker_activities_section_setting',array(
        'label'          => __( 'Show Flash Sale', 'recipe-maker' ),
        'section'        => 'recipe_maker_services_section',
        'settings'       => 'recipe_maker_activities_section_setting',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('recipe_maker_flash_sale_section_image_left',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( 
    $wp_customize,'recipe_maker_flash_sale_section_image_left',array(
        'label' => __('Flash Sale Left Image ','recipe-maker'),
        'description' => __('Dimension 400 x 500 ','recipe-maker'),
        'section' => 'recipe_maker_services_section',
        'settings' => 'recipe_maker_flash_sale_section_image_left',
    )));

    $wp_customize->add_setting('recipe_maker_flash_sale_short_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_flash_sale_short_heading',array(
        'label' => esc_html__('Short Heading','recipe-maker'),
        'section' => 'recipe_maker_services_section',
        'setting' => 'recipe_maker_flash_sale_short_heading',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('recipe_maker_flash_sale_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_flash_sale_heading',array(
        'label' => esc_html__(' Heading','recipe-maker'),
        'section' => 'recipe_maker_services_section',
        'setting' => 'recipe_maker_flash_sale_heading',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('recipe_maker_clock_timer_start',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_clock_timer_start',array(
        'description' => esc_html__('Timer obtains the time and date of the moment. You simply need to include the expiration date. To include the date, please use the format below. "Month date year hours,minutes,seconds" for instance 30 Jan 2025','recipe-maker'),
        'label' => esc_html__('Start Date','recipe-maker'),
        'section' => 'recipe_maker_services_section',
        'setting' => 'recipe_maker_clock_timer_start',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('recipe_maker_clock_timer_end',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('recipe_maker_clock_timer_end',array(
        'description' => esc_html__('Timer obtains the time and date of the moment. You simply need to include the expiration date. To include the date, please use the format below. "Month date year hours,minutes,seconds" for instance 12 May 2026','recipe-maker'),
        'label' => esc_html__('End Date','recipe-maker'),
        'section' => 'recipe_maker_services_section',
        'setting' => 'recipe_maker_clock_timer_end',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('recipe_maker_flash_sale_section_image_right',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( 
    $wp_customize,'recipe_maker_flash_sale_section_image_right',array(
        'label' => __('Flash Sale Right Image ','recipe-maker'),
        'description' => __('Dimension 400 x 500 ','recipe-maker'),
        'section' => 'recipe_maker_services_section',
        'settings' => 'recipe_maker_flash_sale_section_image_right',
    )));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_services_section', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_services_section', array(
                'section'     => 'recipe_maker_services_section',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );

    // Post Settings
     $wp_customize->add_section('recipe_maker_post_settings',array(
        'title' => esc_html__('Post Settings','recipe-maker'),
        'priority'   =>40,
    ));

    $wp_customize->add_setting('recipe_maker_post_page_title',array(
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('recipe_maker_post_page_title',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Title', 'recipe-maker'),
        'section'     => 'recipe_maker_post_settings',
        'description' => esc_html__('Check this box to enable title on post page.', 'recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_post_page_meta',array(
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('recipe_maker_post_page_meta',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Meta', 'recipe-maker'),
        'section'     => 'recipe_maker_post_settings',
        'description' => esc_html__('Check this box to enable meta on post page.', 'recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_post_page_thumb',array(
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('recipe_maker_post_page_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Thumbnail', 'recipe-maker'),
        'section'     => 'recipe_maker_post_settings',
        'description' => esc_html__('Check this box to enable thumbnail on post page.', 'recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_post_page_content',array(
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('recipe_maker_post_page_content',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Content', 'recipe-maker'),
        'section'     => 'recipe_maker_post_settings',
        'description' => esc_html__('Check this box to enable content on post page.', 'recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_post_page_excerpt_length',array(
        'sanitize_callback' => 'recipe_maker_sanitize_number_range',
        'default'           => 30,
    ));
    $wp_customize->add_control('recipe_maker_post_page_excerpt_length',array(
        'label'       => esc_html__('Post Page Excerpt Length', 'recipe-maker'),
        'section'     => 'recipe_maker_post_settings',
        'type'        => 'range',
        'input_attrs' => array(
            'step'             => 1,
            'min'              => 1,
            'max'              => 50,
        ),
    ));

    $wp_customize->add_setting('recipe_maker_post_page_excerpt_suffix',array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => '[...]',
    ));
    $wp_customize->add_control('recipe_maker_post_page_excerpt_suffix',array(
        'type'        => 'text',
        'label'       => esc_html__('Post Page Excerpt Suffix', 'recipe-maker'),
        'section'     => 'recipe_maker_post_settings',
        'description' => esc_html__('For Ex. [...], etc', 'recipe-maker'),
    ));

    $wp_customize->add_setting( 'recipe_maker_blog_post_columns', array(
        'default'  => 'Two',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control( 'recipe_maker_blog_post_columns', array(
        'section' => 'recipe_maker_post_settings',
        'type' => 'select',
        'label' => __( 'No. of Posts per row', 'recipe-maker' ),
        'choices' => array(
            'One'  => __( 'One', 'recipe-maker' ),
            'Two' => __( 'Two', 'recipe-maker' ),
            'Three' => __( 'Three', 'recipe-maker' ),
        )
    ));

    $wp_customize->add_setting('recipe_maker_post_page_pagination',array(
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('recipe_maker_post_page_pagination',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Pagination', 'recipe-maker'),
        'section'     => 'recipe_maker_post_settings',
        'description' => esc_html__('Check this box to enable pagination on post page.', 'recipe-maker'),
    ));

    $wp_customize->add_setting( 'recipe_maker_blog_pagination_type', array(
        'default'           => 'blog-nav-numbers',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control( 'recipe_maker_blog_pagination_type', array(
        'section' => 'recipe_maker_post_settings',
        'type' => 'select',
        'label' => __( 'Post Pagination Type', 'recipe-maker' ),
        'choices' => array(
            'blog-nav-numbers'  => __( 'Numeric', 'recipe-maker' ),
            'next-prev' => __( 'Older/Newer Posts', 'recipe-maker' ),
        )
    ));

    $wp_customize->add_setting( 'recipe_maker_blog_sidebar_position', array(
        'default'           => 'Right Side',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control( 'recipe_maker_blog_sidebar_position', array(
        'section' => 'recipe_maker_post_settings',
        'type' => 'select',
        'label' => __( 'Post Page Sidebar Position', 'recipe-maker' ),
        'choices' => array(
            'Right Side' => __( 'Right Side', 'recipe-maker' ),
            'Left Side' => __( 'Left Side', 'recipe-maker' ),
        )
    ));

    $wp_customize->add_setting('recipe_maker_single_post_page_content',array(
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('recipe_maker_single_post_page_content',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Single Post Page Content', 'recipe-maker'),
        'section'     => 'recipe_maker_post_settings',
        'description' => esc_html__('Check this box to enable content on single post page.', 'recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_single_post_page_tag',array(
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('recipe_maker_single_post_page_tag',array(
        'type'  => 'checkbox',
        'label' => esc_html__('Enable Single Post Page Tag', 'recipe-maker'),
        'section' => 'recipe_maker_post_settings',
        'description' => esc_html__('Check this box to enable content on single post page.', 'recipe-maker'),
    ));

    $wp_customize->add_setting( 'recipe_maker_single_post_sidebar_position', array(
        'default'           => 'Right Side',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control( 'recipe_maker_single_post_sidebar_position', array(
        'section' => 'recipe_maker_post_settings',
        'type' => 'select',
        'label' => __( 'Single Post Sidebar Position', 'recipe-maker' ),
        'choices' => array(
            'Right Side' => __( 'Right Side', 'recipe-maker' ),
            'Left Side' => __( 'Left Side', 'recipe-maker' ),
        )
    ));

    // Pro Version
    $wp_customize->add_setting( 'pro_version_post_settings', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_post_settings', array(
                'section'     => 'recipe_maker_post_settings',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );
    
    // Footer
    $wp_customize->add_section('recipe_maker_site_footer_section', array(
        'title' => esc_html__('Footer', 'recipe-maker'),
    ));

    $wp_customize->add_setting('recipe_maker_footer_widget_content_alignment',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control('recipe_maker_footer_widget_content_alignment',array(
        'type' => 'select',
        'label' => __('Footer Widget Content Alignment','recipe-maker'),
        'section' => 'recipe_maker_site_footer_section',
        'choices' => array(
            'Left' => __('Left','recipe-maker'),
            'Center' => __('Center','recipe-maker'),
            'Right' => __('Right','recipe-maker')
        ),
    ) );

    $wp_customize->add_setting('recipe_maker_show_hide_copyright',array(
        'default' => true,
        'sanitize_callback' => 'recipe_maker_sanitize_checkbox'
    ));
    $wp_customize->add_control('recipe_maker_show_hide_copyright',array(
        'type' => 'checkbox',
        'label' => __('Show / Hide Copyright','recipe-maker'),
        'section' => 'recipe_maker_site_footer_section',
    ));

    $wp_customize->add_setting('recipe_maker_footer_text_setting', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('recipe_maker_footer_text_setting', array(
        'label' => __('Replace the footer text', 'recipe-maker'),
        'section' => 'recipe_maker_site_footer_section',
        'type' => 'text',
    ));

    $wp_customize->add_setting('recipe_maker_copyright_content_alignment',array(
        'default' => 'Center',
        'transport' => 'refresh',
        'sanitize_callback' => 'recipe_maker_sanitize_choices'
    ));
    $wp_customize->add_control('recipe_maker_copyright_content_alignment',array(
        'type' => 'select',
        'label' => __('Copyright Content Alignment','recipe-maker'),
        'section' => 'recipe_maker_site_footer_section',
        'choices' => array(
            'Left' => __('Left','recipe-maker'),
            'Center' => __('Center','recipe-maker'),
            'Right' => __('Right','recipe-maker')
        ),
    ) );

     // Pro Version
    $wp_customize->add_setting( 'pro_version_site_footer_section', array(
        'sanitize_callback' => 'recipe_maker_sanitize_custom_control'
    ) );
    $wp_customize->add_control( new Recipe_Maker_Customize_Pro_Version ( $wp_customize,
            'pro_version_site_footer_section', array(
                'section'     => 'recipe_maker_site_footer_section',
                'type'        => 'pro_options',
                'label'       => esc_html__( 'Customizer Options', 'recipe-maker' ),
                'description' => esc_url( RECIPE_MAKER_URL ),
                'priority'    => 100
            )
        )
    );
}
add_action('customize_register', 'recipe_maker_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function recipe_maker_customize_partial_blogname(){
    bloginfo('name');
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function recipe_maker_customize_partial_blogdescription(){
    bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function recipe_maker_customize_preview_js(){
    wp_enqueue_script('recipe-maker-customizer', esc_url(get_template_directory_uri()) . '/assets/js/customizer.js', array('customize-preview'), '20151215', true);
}
add_action('customize_preview_init', 'recipe_maker_customize_preview_js');

/*
** Load dynamic logic for the customizer controls area.
*/
function recipe_maker_panels_js() {
    wp_enqueue_style( 'recipe-maker-customizer-layout-css', get_theme_file_uri( '/assets/css/customizer-layout.css' ) );
    wp_enqueue_script( 'recipe-maker-customize-layout', get_theme_file_uri( '/assets/js/customize-layout.js' ), array(), '1.2', true );
}
add_action( 'customize_controls_enqueue_scripts', 'recipe_maker_panels_js' );