<?php
/**
 * Recipe Maker functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Recipe Maker
 */

include get_theme_file_path( 'vendor/wptrt/autoload/src/Recipe_Maker_Loader.php' );

$Recipe_Maker_Loader = new \WPTRT\Autoload\Recipe_Maker_Loader();

$Recipe_Maker_Loader->recipe_maker_add( 'WPTRT\\Customize\\Section', get_theme_file_path( 'vendor/wptrt/customize-section-button/src' ) );

$Recipe_Maker_Loader->recipe_maker_register();

if ( ! function_exists( 'recipe_maker_setup' ) ) :

	function recipe_maker_setup() {

		/*
		 * Enable support for Post Formats.
		 *
		 * See: https://codex.wordpress.org/Post_Formats
		*/
		add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

		load_theme_textdomain( 'recipe-maker', get_template_directory() . '/languages' );
		add_theme_support( 'woocommerce' );
		add_theme_support( "responsive-embeds" );
		add_theme_support( "align-wide" );
		add_theme_support( "wp-block-styles" );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
        add_image_size('recipe-maker-featured-header-image', 2000, 660, true);

        register_nav_menus( array(
            'primary' => esc_html__( 'Primary','recipe-maker' ),
        ) );

		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		add_theme_support( 'custom-background', apply_filters( 'recipe_maker_custom_background_args', array(
			'default-color' => 'f7ebe5',
			'default-image' => '',
		) ) );

		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support( 'custom-logo', array(
			'height'      => 200,
			'width'       => 200,
			'flex-width'  => true,
		) );

		add_editor_style( array( '/editor-style.css' ) );
		add_action('wp_ajax_recipe_maker_dismissable_notice', 'recipe_maker_dismissable_notice');
	}
endif;
add_action( 'after_setup_theme', 'recipe_maker_setup' );


function recipe_maker_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'recipe_maker_content_width', 1170 );
}
add_action( 'after_setup_theme', 'recipe_maker_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function recipe_maker_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'recipe-maker' ),
		'id'            => 'sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'recipe-maker' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 1', 'recipe-maker' ),
		'id'            => 'recipe-maker-footer1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="footer-column-widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 2', 'recipe-maker' ),
		'id'            => 'recipe-maker-footer2',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="footer-column-widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 3', 'recipe-maker' ),
		'id'            => 'recipe-maker-footer3',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="footer-column-widget-title">',
		'after_title'   => '</h5>',
	) );
}
add_action( 'widgets_init', 'recipe_maker_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function recipe_maker_scripts() {

	require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );

	wp_enqueue_style(
		'cormorant-garamond',
		wptt_get_webfont_url('https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap'),
		array(),
		'1.0'
	);

	wp_enqueue_style(
		'lato',
		wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap' ),
		array(),
		'1.0'
	);

	wp_enqueue_style(
		'dancing-script',
		wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&display=swap' ),
		array(),
		'1.0'
	);

	wp_enqueue_style( 'recipe-maker-block-editor-style', get_theme_file_uri('/assets/css/block-editor-style.css') );

	// load bootstrap css
    wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/assets/css/bootstrap.css');

    wp_enqueue_style( 'owl.carousel-css', get_template_directory_uri() . '/assets/css/owl.carousel.css');

	wp_enqueue_style( 'recipe-maker-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/custom-option.php' );
	wp_add_inline_style( 'recipe-maker-style',$recipe_maker_theme_css );

	// fontawesome
	wp_enqueue_style( 'fontawesome-style', get_template_directory_uri() .'/assets/css/fontawesome/css/all.css' );

	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js',array('jquery'),'',true);

    wp_enqueue_script('recipe-maker-theme-js', get_template_directory_uri() . '/assets/js/theme-script.js', array('jquery'), '', true );

    wp_enqueue_script('owl.carousel-js', get_template_directory_uri() . '/assets/js/owl.carousel.js', array('jquery'), '', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'recipe_maker_scripts' );

/**
 * Enqueue Preloader.
 */
function recipe_maker_preloader() {

  $recipe_maker_theme_color_css = '';
  $recipe_maker_preloader_bg_color = get_theme_mod('recipe_maker_preloader_bg_color');
  $recipe_maker_preloader_dot_1_color = get_theme_mod('recipe_maker_preloader_dot_1_color');
  $recipe_maker_preloader_dot_2_color = get_theme_mod('recipe_maker_preloader_dot_2_color');
  $recipe_maker_preloader2_dot_color = get_theme_mod('recipe_maker_preloader2_dot_color');
  $recipe_maker_preloader2_dot_color = get_theme_mod('recipe_maker_preloader2_dot_color');
  $recipe_maker_logo_max_height = get_theme_mod('recipe_maker_logo_max_height');
  $recipe_maker_scroll_bg_color = get_theme_mod('recipe_maker_scroll_bg_color');
  $recipe_maker_scroll_color = get_theme_mod('recipe_maker_scroll_color');
  $recipe_maker_scroll_font_size = get_theme_mod('recipe_maker_scroll_font_size');
  $recipe_maker_scroll_border_radius = get_theme_mod('recipe_maker_scroll_border_radius');
  $recipe_maker_related_product_display_setting = get_theme_mod('recipe_maker_related_product_display_setting', true);

  	if(get_theme_mod('recipe_maker_logo_max_height') == '') {
		$recipe_maker_logo_max_height = '200';
	}

	if(get_theme_mod('recipe_maker_preloader_dot_1_color') == '') {
		$recipe_maker_preloader_dot_1_color = '#ffffff';
	}
	if(get_theme_mod('recipe_maker_preloader_dot_2_color') == '') {
		$recipe_maker_preloader_dot_2_color = '#222222';
	}

	// Start CSS build
	$recipe_maker_theme_color_css = '';

	
	if (!$recipe_maker_related_product_display_setting) {
	    $recipe_maker_theme_color_css .= '
	        .related.products,
	        .related h2 {
	            display: none !important;
	        }
	    ';
	}

	$recipe_maker_theme_color_css .= '
		.custom-logo-link img{
			max-height: '.esc_attr($recipe_maker_logo_max_height).'px;
	 	}
		.loading, .loading2{
			background-color: '.esc_attr($recipe_maker_preloader_bg_color).';
		 }
		 @keyframes loading {
		  0%,
		  100% {
		  	transform: translatey(-2.5rem);
		    background-color: '.esc_attr($recipe_maker_preloader_dot_1_color).';
		  }
		  50% {
		  	transform: translatey(2.5rem);
		    background-color: '.esc_attr($recipe_maker_preloader_dot_2_color).';
		  }
		}
		.load hr {
			background-color: '.esc_attr($recipe_maker_preloader2_dot_color).';
		}
		.load hr {
			background-color: '.esc_attr($recipe_maker_preloader2_dot_color).';
		}
		a#button{
			background-color: '.esc_attr($recipe_maker_scroll_bg_color).';
			color: '.esc_attr($recipe_maker_scroll_color).' !important;
			font-size: '.esc_attr($recipe_maker_scroll_font_size).'px;
			border-radius: '.esc_attr($recipe_maker_scroll_border_radius).'%;
		}
	';
    wp_add_inline_style( 'recipe-maker-style',$recipe_maker_theme_color_css );

}
add_action( 'wp_enqueue_scripts', 'recipe_maker_preloader' );

function recipe_maker_files_setup() {
	/**
	 * Customizer additions.
	 */
	require get_template_directory() . '/inc/customizer.php';

	if ( ! defined( 'RECIPE_MAKER_CONTACT_SUPPORT' ) ) {
		define('RECIPE_MAKER_CONTACT_SUPPORT',__('https://wordpress.org/support/theme/recipe-maker/','recipe-maker'));
	}
	if ( ! defined( 'RECIPE_MAKER_REVIEW' ) ) {
		define('RECIPE_MAKER_REVIEW',__('https://wordpress.org/support/theme/recipe-maker/reviews/','recipe-maker'));
	}
	if ( ! defined( 'RECIPE_MAKER_LIVE_DEMO' ) ) {
		define('RECIPE_MAKER_LIVE_DEMO',__('https://demo.themagnifico.net/recipe-maker-pro/','recipe-maker'));
	}
	if ( ! defined( 'RECIPE_MAKER_GET_PREMIUM_PRO' ) ) {
		define('RECIPE_MAKER_GET_PREMIUM_PRO',__('https://www.themagnifico.net/products/recipe-blog-wordpress-theme','recipe-maker'));
	}
	if ( ! defined( 'RECIPE_MAKER_PRO_DOC' ) ) {
		define('RECIPE_MAKER_PRO_DOC',__('https://demo.themagnifico.net/eard/wathiqa/recipe-maker-pro-doc/','recipe-maker'));
	}
	if ( ! defined( 'RECIPE_MAKER_FREE_DOC' ) ) {
		define('RECIPE_MAKER_FREE_DOC',__('https://demo.themagnifico.net/eard/wathiqa/recipe-maker-free-doc/','recipe-maker'));
	}
}

add_action( 'after_setup_theme', 'recipe_maker_files_setup' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/* TGM. */
require get_parent_theme_file_path( '/inc/tgm.php' );

/** * Posts pagination. */
if ( ! function_exists( 'recipe_maker_blog_posts_pagination' ) ) {
	function recipe_maker_blog_posts_pagination() {
		$pagination_type = get_theme_mod( 'recipe_maker_blog_pagination_type', 'blog-nav-numbers' );
		if ( $pagination_type == 'blog-nav-numbers' ) {
			the_posts_pagination();
		} else {
			the_posts_navigation();
		}
	}
}

function recipe_maker_sanitize_select( $input, $setting ){
    $input = sanitize_key($input);
    $choices = $setting->manager->get_control( $setting->id )->choices;
    return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
}

function recipe_maker_preloader1(){
	if(get_theme_mod('recipe_maker_preloader_type', 'Preloader 1') == 'Preloader 1' ) {
		return true;
	}
	return false;
}

function recipe_maker_preloader2(){
	if(get_theme_mod('recipe_maker_preloader_type', 'Preloader 1') == 'Preloader 2' ) {
		return true;
	}
	return false;
}

/*dropdown page sanitization*/
function recipe_maker_sanitize_dropdown_pages( $page_id, $setting ) {
	$page_id = absint( $page_id );
	return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

function recipe_maker_sanitize_checkbox( $input ) {
  // Boolean check
  return ( ( isset( $input ) && true == $input ) ? true : false );
}

/*radio button sanitization*/
function recipe_maker_sanitize_choices( $input, $setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $setting->id );
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

function recipe_maker_sanitize_number_range( $number, $setting ) {
	
	// Ensure input is an absolute integer.
	$number = absint( $number );
	
	// Get the input attributes associated with the setting.
	$atts = $setting->manager->get_control( $setting->id )->input_attrs;
	
	// Get minimum number in the range.
	$min = ( isset( $atts['min'] ) ? $atts['min'] : $number );
	
	// Get maximum number in the range.
	$max = ( isset( $atts['max'] ) ? $atts['max'] : $number );
	
	// Get step.
	$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );
	
	// If the number is within the valid range, return it; otherwise, return the default
	return ( $min <= $number && $number <= $max && is_int( $number / $step ) ? $number : $setting->default );
}

function recipe_maker_sanitize_number_absint( $number, $setting ) {
	// Ensure $number is an absolute integer (whole number, zero or greater).
	$number = absint( $number );

	// If the input is an absolute integer, return it; otherwise, return the default
	return ( $number ? $number : $setting->default );
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'recipe_maker_loop_columns');
if (!function_exists('recipe_maker_loop_columns')) {
	function recipe_maker_loop_columns() {
		$columns = get_theme_mod( 'recipe_maker_products_per_row', 3 );
		return $columns; // 3 products per row
	}
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'recipe_maker_shop_per_page', 9 );
function recipe_maker_shop_per_page( $cols ) {
  	$cols = get_theme_mod( 'recipe_maker_product_per_page', 9 );
	return $cols;
}

// Filter to change the number of related products displayed
add_filter( 'woocommerce_output_related_products_args', 'recipe_maker_products_args' );
function recipe_maker_products_args( $args ) {
    $args['posts_per_page'] = get_theme_mod( 'custom_related_products_number', 6 );
    $args['columns'] = get_theme_mod( 'custom_related_products_number_per_row', 3 );
    return $args;
}

function recipe_maker_get_page_id_by_title($recipe_maker_pagename){

    $args = array(
        'post_type' => 'page',
        'posts_per_page' => 1,
        'post_status' => 'publish',
        'title' => $recipe_maker_pagename
    );
    $query = new WP_Query( $args );

    $page_id = '1';
    if (isset($query->post->ID)) {
        $page_id = $query->post->ID;
    }

    return $page_id;
}

function recipe_maker_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'pro_version_footer_setting' );
    $wp_customize->remove_control( 'pro_version_footer_setting' );

}
add_action( 'customize_register', 'recipe_maker_remove_customize_register', 11 );


/**
 * Get CSS
 */

function recipe_maker_getpage_css($hook) {
	wp_register_script( 'admin-notice-script', get_template_directory_uri() . '/inc/admin/js/admin-notice-script.js', array( 'jquery' ) );
    wp_localize_script('admin-notice-script','recipe_maker',
		array('admin_ajax'	=>	admin_url('admin-ajax.php'),'wpnonce'  =>	wp_create_nonce('recipe_maker_dismissed_notice_nonce')
		)
	);
	wp_enqueue_script('admin-notice-script');

    wp_localize_script( 'admin-notice-script', 'recipe_maker_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
	if ( 'appearance_page_recipe_maker-info' != $hook ) {
		return;
	}
	
}
add_action( 'admin_enqueue_scripts', 'recipe_maker_getpage_css' );

//Admin Notice For Getstart
function recipe_maker_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function recipe_maker_deprecated_hook_admin_notice() {

     // Check if the notice has been dismissed by the user
    $dismissed = get_user_meta(get_current_user_id(), 'recipe_maker_dismissable_notice', true);

    // Exclude the notice from being shown on the "Theme Importer" page
    $current_screen = get_current_screen();
    if ($current_screen && $current_screen->id === 'appearance_page_theme-importer') {
        return; // Don't show the notice on this page
    }

    if (!$dismissed) {  
    	?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get_started" style="background: #f7f9f9; padding: 20px 10px; display: flex;">
	    	<div class="tm-admin-image">
	    		<img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;border: 2px solid #ddd;border-radius: 4px;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
	    	</div>
	    	<div class="tm-admin-content" style="padding-left: 30px; align-self: center">
	    		<h2 style="font-weight: 600;line-height: 1.3; margin: 0px;"><?php esc_html_e('Thank You For Choosing ', 'recipe-maker'); ?><?php echo wp_get_theme(); ?><h2>
	    		<p style="color: #3c434a; font-weight: 400; margin-bottom: 30px;"><?php _e('Get Started With Theme By Clicking On Getting Started.', 'recipe-maker'); ?><p>
	    		<a class="admin-notice-btn button button-primary button-hero" target="_blank" href="<?php echo esc_url( admin_url( 'admin.php?page=theme-importer' )); ?>"><?php esc_html_e( 'Start Demo Import', 'recipe-maker' ) ?></a>
	        	<a class="admin-notice-btn button button-primary button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=recipe-maker-info.php' )); ?>"><?php esc_html_e( 'Get started', 'recipe-maker' ) ?></a>
	        	<a class="admin-notice-btn button button-primary button-hero" target="_blank" href="<?php echo esc_url( RECIPE_MAKER_FREE_DOC ); ?>"><?php esc_html_e( 'Documentation', 'recipe-maker' ) ?></a>
	        	<span style="padding-top: 15px; display: inline-block; padding-left: 8px;">
	        	<span class="dashicons dashicons-admin-links"></span>
	        	<a class="admin-notice-btn"	 target="_blank" href="<?php echo esc_url( RECIPE_MAKER_LIVE_DEMO ); ?>"><?php esc_html_e( 'View Demo', 'recipe-maker' ) ?></a>
	        	</span>
	    	</div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'recipe_maker_deprecated_hook_admin_notice' );

function recipe_maker_switch_theme() {
    delete_user_meta(get_current_user_id(), 'recipe_maker_dismissable_notice');
}
add_action('after_switch_theme', 'recipe_maker_switch_theme');
function recipe_maker_dismissable_notice() {
    update_user_meta(get_current_user_id(), 'recipe_maker_dismissable_notice', true);
    die();
}

// Demo Content Code

// Ensure WordPress is loaded
if (!defined('ABSPATH')) {
    exit;
}

// Add admin menu page to trigger theme import
add_action('admin_menu', 'recipe_maker_demo_importer_admin_page');

function recipe_maker_demo_importer_admin_page() {
    add_theme_page(
        'Demo Theme Importer',     // Page title
        'Theme Importer',          // Menu title
        'manage_options',          // Capability
        'theme-importer',          // Menu slug
        'recipe_maker_demo_importer_page',      // Callback function
    );
}

// Display the page content with the button
function recipe_maker_demo_importer_page() {
    ?>
    <div class="wrap-main-box">
        <div class="main-box">
            <h2><?php echo esc_html('Welcome to Recipe Maker','recipe-maker'); ?></h2>
            <h3><?php echo esc_html('Create your website in just one click','recipe-maker'); ?></h3>
            <hr>
            <p><?php echo esc_html('The "Begin Installation" helps you quickly set up your website by importing sample content that mirrors the demo version of the theme. This tool provides you with a ready-made layout and structure, so you can easily see how your site will look and start customizing it right away. It\'s a straightforward way to get your site up and running with minimal effort.','recipe-maker'); ?></p>
            <p><?php echo esc_html('Click the button below to install the demo content.','recipe-maker'); ?></p>
            <hr>
            <button id="import-theme-mods" class="button button-primary"><?php echo esc_html('Begin Installation','recipe-maker'); ?></button>
            <div id="import-response"></div>
        </div>
    </div>
    <?php
}

// Add the AJAX action to trigger theme mods import
add_action('wp_ajax_import_theme_mods', 'recipe_maker_demo_importer_ajax_handler');

// Handle the AJAX request
function recipe_maker_demo_importer_ajax_handler() {
    // Sample data to import
    $theme_mods_data = array(
        'header_textcolor' => '000000',  // Example: change header text color
        'background_color' => 'ffffff',  // Example: change background color
        'custom_logo'      => 123,       // Example: set a custom logo by attachment ID
        'footer_text'      => 'Custom Footer Text', // Example: custom footer text
    );

    // Call the function to import theme mods
    if (recipe_maker_demo_theme_importer($theme_mods_data)) {
        // After importing theme mods, create the menu
        recipe_maker_create_demo_menu();
        wp_send_json_success(array(
        	'msg' => 'Theme mods imported successfully.',
        	'redirect' => home_url()
        ));
    } else {
        wp_send_json_error('Failed to import theme mods.');
    }

    wp_die();
}

// Function to set theme mods
function recipe_maker_demo_theme_importer($import_data) {
    if (is_array($import_data)) {
        foreach ($import_data as $mod_name => $mod_value) {
            set_theme_mod($mod_name, $mod_value);
        }
        return true;
    } else {
        return false;
    }
}

// Function to create demo menu
function recipe_maker_create_demo_menu() {

    // Page import process
    $pages_to_create = array(
        array(
            'title'    => 'HOME',
            'slug'     => 'home',
            'template' => 'page-template/home-template.php',
        ),
        array(
            'title'    => 'BLOG',
            'slug'     => 'blog',
            'template' => '',
        ),
        array(
            'title'    => 'RECIPE',
            'slug'     => 'recipe',
            'template' => '',
        ),
        
        array(
            'title'    => 'SHOP',
            'slug'     => 'shop',
            'template' => '',
        ),
        array(
            'title'    => 'ABOUT',
            'slug'     => 'about',
            'template' => '',
        ),
        array(
            'title'    => 'CONTACT',
            'slug'     => 'contact',
            'template' => '',
        ),
    );

    // Loop through each page data to create pages
    foreach ($pages_to_create as $page_data) {
        $page_check = get_page_by_title($page_data['title']);
        
        // Check if the page doesn't exist already
        if (!$page_check) {
            $page = array(
                'post_type'    => 'page',
                'post_title'   => $page_data['title'],
                'post_status'  => 'publish',
                'post_author'  => 1,
                'post_slug'    => $page_data['slug'],
            );
            
            // Insert the page and get the inserted page ID
            $page_id = wp_insert_post($page);
            
            // Set the page template
            if ($page_id) {
                add_post_meta($page_id, '_wp_page_template', $page_data['template']);
            }
        }
    }

    // Set 'Home' as the front page
    $home_page = get_page_by_title('Home');
    if ($home_page) {
        update_option('page_on_front', $home_page->ID);
        update_option('show_on_front', 'page');
    }

    // Set 'Blog' as the posts page
    $blog_page = get_page_by_title('Blog');
    if ($blog_page) {
        update_option('page_for_posts', $blog_page->ID);
    }
    // ------- Create Main Menu --------
    $menuname =  'Primary Menu';
    $bpmenulocation = 'primary';
    $menu_exists = wp_get_nav_menu_object($menuname);
    
    if (!$menu_exists) {
        $menu_id = wp_create_nav_menu($menuname);
        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('HOME','recipe-maker'),
            'menu-item-classes' => 'home',
            'menu-item-url' => home_url( '/' ),
            'menu-item-status' => 'publish'));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' => __('BLOG','recipe-maker'),
            'menu-item-classes' => 'blog',
            'menu-item-url' => home_url( '/' ),
            'menu-item-status' => 'publish',
        ));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('RECIPE','recipe-maker'),
            'menu-item-classes' => 'recipe',
            'menu-item-url' => home_url( '/' ),
            'menu-item-status' => 'publish'
        ));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('SHOP','recipe-maker'),
            'menu-item-classes' => 'shop',
            'menu-item-url' => home_url( '/' ),
            'menu-item-status' => 'publish'
        ));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('ABOUT','recipe-maker'),
            'menu-item-classes' => 'about',
            'menu-item-url' => home_url( '/' ),
            'menu-item-status' => 'publish'
        ));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('Contact','recipe-maker'),
            'menu-item-classes' => 'contact',
            'menu-item-url' => home_url( '/' ),
            'menu-item-status' => 'publish'
        ));

        // Assign the menu to the location
        if (!has_nav_menu($bpmenulocation)) {
            $locations = get_theme_mod('nav_menu_locations');
            $locations[$bpmenulocation] = $menu_id;
            set_theme_mod('nav_menu_locations', $locations);
        }
    }
    
    //Top Header
    set_theme_mod( 'recipe_maker_topbar_text', 'Check out our latest fall-inspired recipes and get exclusive cooking tips – only on our blog!' );
    set_theme_mod( 'recipe_maker_top_header_about_us_button_url', '#' );

    set_theme_mod( 'recipe_maker_facebook_icon', 'fab fa-facebook-f' );
    set_theme_mod( 'recipe_maker_facebook_url', '#' );

    set_theme_mod( 'recipe_maker_twitter_icon', 'fab fa-twitter' );
    set_theme_mod( 'recipe_maker_twitter_url', '#' );

    set_theme_mod( 'recipe_maker_intagram_icon', 'fab fa-instagram' );
    set_theme_mod( 'recipe_maker_intagram_url', '#' );

    set_theme_mod( 'recipe_maker_linkedin_icon', 'fab fa-linkedin-in' );
    set_theme_mod( 'recipe_maker_linkedin_url', '#' );

    set_theme_mod( 'recipe_maker_pintrest_icon', 'fab fa-pinterest-p' );
    set_theme_mod( 'recipe_maker_pintrest_url', '#' );

    set_theme_mod( 'recipe_maker_topbar1_wishlist_url', '#' );

    //Slider
    set_theme_mod( 'recipe_maker_slider_short_heading', 'Good Food' );
    set_theme_mod( 'recipe_maker_slider_right_background_image', get_template_directory_uri() . '/assets/img/slider-banner.jpg');
   	for($i=1;$i<=3;$i++){
         $title = 'Discover Delicious Recipes for Every Occasion and Taste!';
         $content = 'Discover a wide range of delicious recipes tailored for every occasion, from casual meals to special events. Whether you\'re cooking for yourself or hosting guests, find something to suit every taste!';
            // Create post object
         $my_post = array(
         'post_title'    => wp_strip_all_tags( $title ),
         'post_content'  => $content,
         'post_status'   => 'publish',
         'post_type'     => 'page',
         );

         // Insert the post into the database
         $post_id = wp_insert_post( $my_post );

         if ($post_id) {
	        // Set the theme mod for the slider page
	        set_theme_mod('recipe_maker_top_slider_page' . $i, $post_id);

	        $image_url = get_template_directory_uri().'/assets/img/slider.png';

			$image_id = media_sideload_image($image_url, $post_id, null, 'id');

		        if (!is_wp_error($image_id)) {
		            // Set the downloaded image as the post's featured image
		            set_post_thumbnail($post_id, $image_id);
		        }
      	}
    }

   // Top categories

    set_theme_mod( 'recipe_maker_categorie_short_heading', 'Categories' );
    set_theme_mod( 'recipe_maker_categorie_heading', 'Explore a World of Flavors with Our Recipe Categories!' );

    for($i=1;$i<=4;$i++){
         $title = array('Breakfast & Brunch','Appetizers & Snacks','Soups & Salads','Soups & Salads');
         $content = 'Discover a wide range of delicious recipes tailored for every occasion, from casual meals to special events. Whether you\'re cooking for yourself or hosting guests, find something to suit every taste!';
            // Create post object
         $my_post = array(
         'post_title'    => wp_strip_all_tags( $title [$i-1]),
         'post_content'  => $content,
         'post_status'   => 'publish',
         'post_type'     => 'post',
         );

         // Insert the post into the database
         $post_id = wp_insert_post( $my_post );

         if ($post_id) {
	        // Set the theme mod for the slider page
	        set_theme_mod('recipe_maker_services_sec_category' ,'categories');

	        $image_url = get_template_directory_uri() . '/assets/img/categories' . $i . '.png';

	        wp_set_object_terms($post_id,'categories', 'category');

			$image_id = media_sideload_image($image_url, $post_id, null, 'id');

		        if (!is_wp_error($image_id)) {
		            // Set the downloaded image as the post's featured image
		            set_post_thumbnail($post_id, $image_id);
		        }
      	}
    }

    // Sale

    set_theme_mod( 'recipe_maker_flash_sale_section_image_left', get_template_directory_uri() . '/assets/img/sale.png');
    set_theme_mod( 'recipe_maker_flash_sale_short_heading', 'FlashSale' );
    set_theme_mod( 'recipe_maker_flash_sale_heading', 'Limited-Time Offer: Save Big on Exclusive Recipe Bundles – Hurry, Time\'s Running Out!' );
    set_theme_mod( 'recipe_maker_clock_timer_start', '30 Jan 2025' );
    set_theme_mod( 'recipe_maker_clock_timer_end', '12 May 2026' );
    set_theme_mod( 'recipe_maker_flash_sale_section_image_right', get_template_directory_uri() . '/assets/img/sale-right.png');

}
// Enqueue necessary scripts
add_action('admin_enqueue_scripts', 'recipe_maker_demo_importer_enqueue_scripts');

function recipe_maker_demo_importer_enqueue_scripts() {
    wp_enqueue_script(
        'demo-theme-importer',
        get_template_directory_uri() . '/assets/js/theme-importer.js', // Path to your JS file
        array('jquery'),
        null,
        true
    );

    wp_enqueue_style('demo-importer-style', get_template_directory_uri() . '/assets/css/importer.css', array(), '');

    // Localize script to pass AJAX URL to JS
    wp_localize_script(
        'demo-theme-importer',
        'demoImporter',
        array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('theme_importer_nonce')
        )
    );
}

/**
 * Theme Info.
 */
function recipe_maker_theme_info_load() {
	require get_theme_file_path( '/inc/theme-installation/theme-installation.php' );
}
add_action( 'init', 'recipe_maker_theme_info_load' );