<?php
/**
 * Theme Customizer
 *
 * @package Radiant Blog
 */

function radiant_blog_customize_register( $wp_customize ) {

	// Upsell Section.
	$wp_customize->add_section(
		new Radiant_Blog_Upsell_Section(
			$wp_customize,
			'upsell_sections',
			array(
				'title'            => __( 'Radiant Blog', 'radiant-blog' ),
				'button_text'      => __( 'Buy Pro', 'radiant-blog' ),
				'url'              => 'https://ascendoor.com/themes/radiant-blog-pro/',
				'background_color' => '#3763e8',
				'text_color'       => '#fff',
				'priority'         => 0,
			)
		)
	);

	$wp_customize->add_section(
		'radiant_blog_archive_layout',
		array(
			'title' => esc_html__( 'Archive Layout', 'radiant-blog' ),
			'panel' => 'dazzling_blog_theme_options',
		)
	);

	require get_theme_file_path() . '/inc/customizer/flash-articles.php';

}
add_action( 'customize_register', 'radiant_blog_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function radiant_blog_customize_preview_js() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_script( 'radiant-blog-customizer', get_stylesheet_directory_uri() . '/assets/js/customizer' . $min . '.js', array( 'dazzling-blog-customizer', 'customize-preview' ), '1.0.0', true );
}
add_action( 'customize_preview_init', 'radiant_blog_customize_preview_js' );

function radiant_blog_custom_control_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'radiant-blog-custom-controls-css', get_stylesheet_directory_uri() . '/assets/css/custom-controls' . $min . '.css', array( 'dazzling-blog-custom-controls-css' ), '1.0.0', 'all' );
	wp_enqueue_script( 'radiant-blog-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/custom-controls' . $min . '.js', array( 'dazzling-blog-custom-controls-js', 'jquery', 'jquery-ui-core' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'radiant_blog_custom_control_scripts' );

function radiant_blog_admin_style() {

	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'radiant-blog-demo-url', get_stylesheet_directory_uri() . '/assets/css/admin' . $min . '.css', array(), '1.0.0', 'all' );

}
add_action( 'admin_enqueue_scripts', 'radiant_blog_admin_style' );

// Active Callback.

// Flash Article Section.
function radiant_blog_is_flash_articles_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'radiant_blog_enable_flash_articles_section' )->value() );
}
function radiant_blog_is_flash_articles_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'radiant_blog_flash_articles_content_type' )->value();
	return ( radiant_blog_is_flash_articles_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function radiant_blog_is_flash_articles_section_and_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'radiant_blog_flash_articles_content_type' )->value();
	return ( radiant_blog_is_flash_articles_section_enabled( $control ) && ( 'category' === $content_type ) );
}