<?php
/**
 * Radiant Blog functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Radiant Blog
 */

if ( ! function_exists( 'radiant_blog_setup' ) ) :
	function radiant_blog_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'radiant-blog', get_stylesheet_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'register_block_pattern' );

		add_theme_support( 'register_block_style' );

		add_theme_support( 'wp-block-styles' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'radiant_blog_setup' );

if ( ! function_exists( 'radiant_blog_enqueue_styles' ) ) :
	/**
	 * Enqueue scripts and styles.
	 */
	function radiant_blog_enqueue_styles() {
		$parenthandle = 'dazzling-blog-style';
		$theme        = wp_get_theme();

		// Append .min if SCRIPT_DEBUG is false.
		$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'dazzling-blog-slick-css',
				'dazzling-blog-font-awesome-css',
				'dazzling-blog-google-fonts',
			),
			$theme->parent()->get( 'Version' )
		);

		wp_enqueue_style(
			'radiant-blog-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);

		wp_enqueue_script( 'radiant-blog-script', get_stylesheet_directory_uri() . '/assets/js/custom' . $min . '.js', array( 'jquery', 'dazzling-blog-custom-script' ), $theme->get( 'Version' ), true );

	}

endif;

add_action( 'wp_enqueue_scripts', 'radiant_blog_enqueue_styles' );

// Custom Controls.
require get_theme_file_path() . '/inc/custom-controls.php';

// Customizer Section.
require get_theme_file_path() . '/inc/customizer.php';

/**
 * One Click Demo Import after import setup.
 */
if ( class_exists( 'OCDI_Plugin' ) ) {
	require get_theme_file_path() . '/inc/ocdi.php';
}

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses radiant_blog_header_style()
 */
function radiant_blog_custom_header_setup() {
	add_theme_support(
		'custom-header',
		apply_filters(
			'dazzling_blog_custom_header_args',
			array(
				'default-image'      => '',
				'default-text-color' => '3763e8',
				'width'              => 1000,
				'height'             => 250,
				'flex-height'        => true,
				'wp-head-callback'   => 'dazzling_blog_header_style',
			)
		)
	);
}
add_action( 'after_setup_theme', 'radiant_blog_custom_header_setup' );

/**
 * Renders customizer section link
 */
function radiant_blog_section_link( $section_id ) {
	$section_name      = str_replace( 'radiant_blog_', ' ', $section_id );
	$section_name      = str_replace( '_', ' ', $section_name );
	$starting_notation = '#';
	?>
	<span class="section-link">
		<span class="section-link-title"><?php echo esc_html( $section_name ); ?></span>
	</span>
	<style type="text/css">
		<?php echo $starting_notation . $section_id; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>:hover .section-link {
			visibility: visible;
		}
	</style>
	<?php
}
