<?php
/**
 * Functions and definitions
 *
 * @package WordPress
 * @subpackage Portfolio Ajust
 * @since Portfolio Ajust 1.0
*/

/**
 * Portfolio Ajust setup.
 *
 * @since Portfolio Ajust 1.0
 */
 
 if ( ! isset( $content_width ) ) {
	$content_width = 900;
}
define ( 'PORTFOLIOADJUST_VERSION', '1.2' );
  
function portfolioadjust_setup() {

	$defaults = meditation_get_defaults();

	load_child_theme_textdomain( 'portfolio-adjust' );
	
	$args = array(
		'default-image'          => "",
		'header-text'            => true,
		'default-text-color'     => 'ffffff',
		'width'                  => absint( meditation_get_theme_mod( 'size_image' ) ),
		'height'                 => absint( meditation_get_theme_mod( 'size_image_height' ) ),
		'flex-height'            => true,
		'flex-width'             => true,
	);
	add_theme_support( 'custom-header', $args );
	
	global $meditation_colors_class;	
	$meditation_colors_class = NULL;	
	
}
add_action( 'after_setup_theme', 'portfolioadjust_setup' );

function portfolioadjust_init() {
//change colors in the color scheme	
	global $meditation_colors_class;
	if( $meditation_colors_class != NULL ) {
		$meditation_colors_class->set_color("menu1_color", 1, '#fff', 1);		
		$meditation_colors_class->set_color("heading_color", 1, '#21bbd3', 1);		
		$meditation_colors_class->set_color("heading_link", 1, '#dd3333', 1);		
	}
}
add_action( 'init', 'portfolioadjust_init' );


/**
 * Enqueue parent and child scripts
 *
 * @package WordPress
 * @subpackage Portfolio Ajust
 * @since Portfolio Ajust 1.0
*/

function portfolioadjust_styles() {
	
	//menu scripts
	if ( meditation_get_theme_mod( 'header_effect_class' ) != 0 ) {
		wp_enqueue_script( 'portfolioadjust-menu', get_stylesheet_uri() . '/js/menu.js', array( 'jquery' ), PORTFOLIOADJUST_VERSION, true );
	}		
	
	wp_enqueue_style( 'meditation-style', get_template_directory_uri() . '/style.css', array(), PORTFOLIOADJUST_VERSION );
	wp_enqueue_style( 'portfolioadjust-style', get_stylesheet_uri(), array( 'meditation-style', 'meditation-animate' ), PORTFOLIOADJUST_VERSION );
	
	// Adds JavaScript for handing the navigation menu
	wp_enqueue_script( 'portfolio-adjust-navigation',  get_stylesheet_directory_uri() . '/inc/nav.js', array( 'jquery' ), PORTFOLIOADJUST_VERSION, true );

}
add_action( 'wp_enqueue_scripts', 'portfolioadjust_styles' );

/**
 * Set defaults
 *
 * @package WordPress
 * @subpackage Portfolio Ajust
 * @since Portfolio Ajust 1.0
*/

function portfolioadjust_defaults( $defaults ) {
	
	$defaults['is_cat'] = '1';
	$defaults['is_author'] = '';
	$defaults['is_date'] = '';
	$defaults['is_views'] = '';
	$defaults['is_comments'] = '';
	$defaults['blog_is_cat'] = '1';
	$defaults['blog_is_author'] = '';
	$defaults['blog_is_date'] = '';
	$defaults['blog_is_views'] = '';
	$defaults['blog_is_comments'] = '';
	$defaults['blog_is_entry_meta'] = '';
	$defaults['is_restart_header'] = '';
	$defaults['font_scheme'] = '3';
	$defaults['color_scheme'] = '1';
	$defaults['menu_effect_class'] = '2';
	$defaults['blog_effect_class'] = '2';
	$defaults['sidebar_effect_class'] = '1';
	$defaults['header_effect_class'] = '1';

	$defaults['site_style'] = 'full';
	
	$defaults['width_site'] = '1200';
	$defaults['width_top_widget_area'] = '1200';
	$defaults['width_content_no_sidebar'] = '1200';	
	$defaults['width_content'] = '1200';
	$defaults['width_main_wrapper'] = '1200';
	
	/* Header Image size */
	$defaults['size_image'] = '1200';
	$defaults['size_image_height'] = '400';
	/* Header Image and top sidebar wrapper */
	$defaults['width_image'] = '1200';
	
	$defaults['scroll_button'] = 'right';
	
	$defaults['single_style'] = 'excerpt';

	$defaults['footer_text'] = '<a href="' . esc_url( 'http://wordpress.org/' ) . '">' . 'WordPress' . '</a> | ' . ' ' . '<a href="' .  esc_url( 'http://englishlrn.ru/2025/04/21/portfolio-adjust/' ) . '">Portfolio Ajust</a>';
	
	return $defaults;

}
add_filter( 'meditation_option_defaults', 'portfolioadjust_defaults' );

/** Set theme layout
 *
 * @since Portfolio Ajust 1.0
 */
function portfolioadjust_layout( $layout ) {
	
	foreach( $layout as $id => $layouts ) {
		if ( 'layout_home' == $layouts['name'] ) {

			$layout[ $id ]['val'] = 'no-sidebar';
			
		}
		if ( 'layout_home' == $layouts['name'] || 'layout_blog' == $layouts['name'] || 'layout_archive' == $layouts['name'] ) {

			$layout[ $id ]['content_val'] = 'flex-layout-3';
			
		}	
		if (  'layout_archive' == $layouts['name'] ) {

			$layout[ $id ]['content_val'] = 'flex-layout-3';
			
		}
		if (  'layout_default' == $layouts['name'] ) {

			$layout[ $id ]['val'] = 'left-sidebar';
			
		}
	}
	return $layout;
}
add_filter( 'meditation_layout', 'portfolioadjust_layout' );


/**
 * Top menu and site name
 *
 * @since Meditation 1.0.0
 */
function meditation_header() {

?>
<a class="skip-link screen-reader-text" href="#content"><?php echo __('Skip to content', 'portfolio-adjust' ); ?></a>

	<div id="sg-site-header" class="sg-site-header">
		<!-- First Top Menu -->		
		<div class="menu-top top-1-navigation">						
			<?php if ( meditation_get_theme_mod( 'is_show_top_menu' ) == '1' ) : ?>
				<nav class="horisontal-navigation menu-1 primary-menu-wrapper" role="navigation">
					<?php if ( function_exists( 'the_custom_logo' ) && has_custom_logo() ) :
						the_custom_logo();
						elseif ( '' != meditation_get_theme_mod( 'logotype_url' ) ) : ?>
						<a class="small-logo" href='<?php echo esc_url( home_url( '/' ) ); ?>' title='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>' rel='home'>
							<img src='<?php echo esc_url( meditation_get_theme_mod( 'logotype_url' ) ); ?>' class="menu-logo" alt='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>'>
						</a><!-- .logo-section -->
					<?php endif; ?>
					<span class="toggle"><button class="menu-toggle"></button></span>
					<ul class="primary-menu reset-list-style">
						<?php
							wp_nav_menu(
								array(
									'container'  => '',
									'items_wrap' => '%3$s',
									'theme_location' => 'top1',
									'menu_class' => 'nav-horizontal',
									'fallback_cb' => 'meditation_empty_menu'
								)
							);
						?>
					</ul>					
				</nav><!-- .menu-1 .horisontal-navigation -->
			<?php endif; ?>
			<div class="clear"></div>
		</div><!-- .menu-top  -->
	</div><!-- .sg-site-header -->
	
<?php
}

/**
 * Header image
 *
 * @since Meditation 1.0.0
 */
function meditation_header_image() {

	if ( get_header_image() && ( meditation_get_theme_mod( 'is_header_on_front_page_only' ) != '1' || is_front_page() ) ) : ?>	
		
			<!-- Banner -->
			<div class="image-container">
				<div class="image-wrapper">
				
					<div class="image-text-wrap">
						<div class="image-text">
							
							<div class="site-title">
								<h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							</div><!-- .site-title -->
							<!-- Dscription -->
							<div class="site-description">
								<h2><?php echo bloginfo( 'description' ); ?></h2>
							</div><!-- .site-description -->
				
						</div><!-- .image-text -->
					</div><!-- .image-text-wrap -->
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
						<img src="<?php header_image(); ?>" class="header-image" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="" />
					</a>
				</div><!-- .image-wrapper -->
			</div><!-- .image-container -->
		
	<?php else : ?>
	
		<div class="sg-site-header-1 no-image">
			<div class="image-text-wrap">
				<div class="image-text">
					<div class="site-title">
						<h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					</div><!-- .site-title -->
					<!-- Dscription -->
					<div class="site-description">
						<h2><?php bloginfo( 'description' ); ?></h2>
					</div><!-- .site-description -->
				</div><!-- .image-text -->
			</div><!-- .image-text-wrap -->
		</div><!-- .sg-site-header-1 -->
		
	<?php endif;
}