<?php get_header(); ?>

<main id="main" class="site-main">
    <div class="pedro-container">
        <div class="pedro-row">
            <!-- Main Content Area -->
            <div class="pedro-col-8">
                <?php if (have_posts()) : ?>
                    <header class="page-header">
                        <h1 class="page-title"><?php single_post_title(); ?></h1>
                    </header>

                    <?php while (have_posts()) : the_post(); ?>
                        <article <?php post_class('mb-4'); ?>>
                            <h2 class="entry-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h2>
                            <div class="entry-excerpt">
                                <?php the_excerpt(); ?>
                            </div>
                        </article>
                    <?php endwhile; ?>

                    <div class="pagination">
                        <?php the_posts_navigation(); ?>
                    </div>
                <?php else : ?>
                    <h2><?php echo esc_html__('No posts found.', 'pedro'); ?></h2>
                <?php endif; ?>
            </div>

            <!-- Sidebar Area -->
            <div class="pedro-col-4">
                <?php get_sidebar(); ?>
            </div>
        </div>
    </div>
</main>

<?php get_footer(); ?>

