<?php

function pedro_customize_register( $wp_customize ) {

    $wp_customize->add_section( 'pedro_section', array(
      'title'      => __( 'Pedro Styles', 'pedro'),
      'priority'   => 160,
      'capability' => 'edit_theme_options',
    ) );

   // footer title
   $wp_customize->add_setting( 'pedro_footer_title', array(
      'type'              => 'theme_mod',
      'capability'        => 'edit_theme_options',
      'default'           => '',
      'transport'         => 'postMessage',
      'sanitize_callback' => 'sanitize_text_field',
  ) );

   $wp_customize->add_control( 'pedro_footer_title', array(
    'type' => 'text',
    'priority' => 10,
    'section' => 'pedro_section',
    'label' => __( 'footer title', 'pedro'),
    'input_attrs' => array(
      'style' => 'width: 100%',
      'placeholder' => __( 'footer title', 'pedro'),
    ),
    'active_callback' => 'is_front_page',
  ) );

   // footer copywrite text
   $wp_customize->add_setting( 'pedro_copywrite_text', array(
      'type'              => 'theme_mod',
      'capability'        => 'edit_theme_options',
      'default'           => '',
      'transport'         => 'postMessage',
      'sanitize_callback' => 'sanitize_text_field',
  ) );

   $wp_customize->add_control( 'pedro_copywrite_text', array(
    'type' => 'text',
    'priority' => 10,
    'section' => 'pedro_section',
    'label' => __( 'Copyright Text', 'pedro'),
    'input_attrs' => array(
      'style' => 'width: 100%',
      'placeholder' => __( 'Copyright Text', 'pedro'),
    ),
    'active_callback' => 'is_front_page',
  ) );


}
add_action( 'customize_register', 'pedro_customize_register' );
