<?php
/**
 * Header Layout
 * @package Outdoor Adventure
 */

$outdoor_adventure_defaults = outdoor_adventure_get_default_theme_options();

$outdoor_adventure_sticky = get_theme_mod('outdoor_adventure_sticky');
    $outdoor_adventure_data_sticky = "false";
    if ($outdoor_adventure_sticky) {
    $outdoor_adventure_data_sticky = "true";
    }
    global $wp_customize;

$outdoor_adventure_header_layout_phone_number_text = esc_html( get_theme_mod( 'outdoor_adventure_header_layout_phone_number_text',
$outdoor_adventure_defaults['outdoor_adventure_header_layout_phone_number_text'] ) );

$outdoor_adventure_header_layout_phone_number = esc_html( get_theme_mod( 'outdoor_adventure_header_layout_phone_number',
$outdoor_adventure_defaults['outdoor_adventure_header_layout_phone_number'] ) );

?>
<header id="site-header" class="site-header-layout header-layout" role="banner">
    <div class="header-navbar <?php if( is_user_logged_in() && !isset( $wp_customize ) ){ echo "login-user";} ?>" data-sticky="<?php echo esc_attr($outdoor_adventure_data_sticky); ?>">
        <div class="wrapper header-wrapper">
            <div class="theme-header-areas header-areas-left aa">
                <div class="header-titles">
                    <?php
                    outdoor_adventure_site_logo();
                    outdoor_adventure_site_description();
                    ?>
                </div>
            </div>
            <div class="theme-header-areas header-areas-right bb">
                <div class="site-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'outdoor-adventure'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('outdoor-adventure-primary-menu')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'outdoor-adventure-primary-menu',
                                    )
                                );
                            } else {
                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'walker' => new outdoor_adventure_Walker_Page(),
                                    )
                                );
                            } ?>
                        </ul>
                    </nav>
                </div>
                <div class="navbar-controls twp-hide-js">
                    <button type="button" class="navbar-control navbar-control-offcanvas">
                        <span class="navbar-control-trigger" tabindex="-1">
                            <?php outdoor_adventure_the_theme_svg('menu'); ?>
                        </span>
                    </button>
                </div>
            </div>
            <div class="theme-header-areas header-areas-right header-contact cc">
                <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M493.4 24.6l-104-24c-11.3-2.6-22.9 3.3-27.5 13.9l-48 112c-4.2 9.8-1.4 21.3 6.9 28l60.6 49.6c-36 76.7-98.9 140.5-177.2 177.2l-49.6-60.6c-6.8-8.3-18.2-11.1-28-6.9l-112 48C3.9 366.5-2 378.1.6 389.4l24 104C27.1 504.2 36.7 512 48 512c256.1 0 464-207.5 464-464 0-11.2-7.7-20.9-18.6-23.4z"/></svg>
                <div class="header-areas-box">
                    <?php if( $outdoor_adventure_header_layout_phone_number_text ){ ?>
                        <h6><?php echo esc_html( $outdoor_adventure_header_layout_phone_number_text ); ?></h6>
                    <?php } ?>
                    <?php if( $outdoor_adventure_header_layout_phone_number ){ ?>
                        <p><a href="tel:<?php echo esc_attr( $header_layout_phone_number ); ?>"><?php echo esc_html( $outdoor_adventure_header_layout_phone_number ); ?></a></p>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</header>