<?php
/**
 * The template for displaying single posts and pages.
 * @package Outdoor Adventure
 * @since 1.0.0
 */

get_header();

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();
$outdoor_adventure_global_layout = get_theme_mod('outdoor_adventure_global_sidebar_layout', $outdoor_adventure_default['outdoor_adventure_global_sidebar_layout']);
$outdoor_adventure_page_layout = get_theme_mod('outdoor_adventure_page_sidebar_layout', $outdoor_adventure_global_layout);
$outdoor_adventure_post_layout = get_theme_mod('outdoor_adventure_post_sidebar_layout', $outdoor_adventure_global_layout);
$outdoor_adventure_post_meta = get_post_meta(get_the_ID(), 'outdoor_adventure_post_sidebar_option', true);

$outdoor_adventure_final_layout = $outdoor_adventure_global_layout;
if (!empty($outdoor_adventure_post_meta) && $outdoor_adventure_post_meta !== 'default') {
    $outdoor_adventure_final_layout = $outdoor_adventure_post_meta;
} elseif (is_page() || (function_exists('is_shop') && is_shop())) {
    $outdoor_adventure_final_layout = $outdoor_adventure_page_layout;
} elseif (is_single()) {
    $outdoor_adventure_final_layout = $outdoor_adventure_post_layout;
}

// Set content column order based on sidebar layout
$outdoor_adventure_sidebar_column_class = 'column-order-1';
if ($outdoor_adventure_final_layout === 'left-sidebar') {
    $outdoor_adventure_sidebar_column_class = 'column-order-2';
}

?>

<div id="single-page" class="singular-main-block">
    <div class="wrapper">
        <div class="column-row <?php echo esc_attr($outdoor_adventure_final_layout === 'no-sidebar' ? 'no-sidebar-layout' : ''); ?>">

            <?php if ($outdoor_adventure_final_layout === 'left-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

            <div id="primary" class="content-area <?php echo esc_attr($outdoor_adventure_final_layout === 'no-sidebar' ? 'full-width-content' : $outdoor_adventure_sidebar_column_class); ?>">
                <main id="site-content" role="main">

                    <?php
                    outdoor_adventure_breadcrumb(); // Display breadcrumb

                    if (have_posts()) : ?>

                        <div class="article-wraper">
                            <?php while (have_posts()) : the_post(); ?>

                                <?php get_template_part('template-parts/content', 'single'); ?>

                                <?php if ((is_single() || is_page()) && (comments_open() || get_comments_number()) && !post_password_required()) : ?>
                                    <div class="comments-wrapper">
                                        <?php comments_template(); ?>
                                    </div>
                                <?php endif; ?>

                            <?php endwhile; ?>
                        </div>

                    <?php else : ?>

                        <?php get_template_part('template-parts/content', 'none'); ?>

                    <?php endif;

                    do_action('outdoor_adventure_navigation_action');
                    ?>

                </main>
            </div>

            <?php if ($outdoor_adventure_final_layout === 'right-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

        </div>
    </div>
</div>

<?php get_footer(); ?>