<?php
$outdoor_adventure_layout = outdoor_adventure_get_final_sidebar_layout();
$outdoor_adventure_sidebar_class = 'column-order-1';

if ( $outdoor_adventure_layout === 'left-sidebar' ) {
    $outdoor_adventure_sidebar_class = 'column-order-1';
} elseif ( $outdoor_adventure_layout === 'right-sidebar' ) {
    $outdoor_adventure_sidebar_class = 'column-order-2';
}

if ( $outdoor_adventure_layout !== 'no-sidebar' ) : ?>
    <aside id="secondary" class="widget-area <?php echo esc_attr( $outdoor_adventure_sidebar_class ); ?>">
        <div class="widget-area-wrapper">
            <?php if ( is_active_sidebar('sidebar-1') ) : ?>
                <?php dynamic_sidebar( 'sidebar-1' ); ?>
            <?php else : ?>
                <!-- Default widgets -->
                <div class="widget widget_block widget_search">
                    <h3 class="widget-title"><?php esc_html_e('Search', 'outdoor-adventure'); ?></h3>
                    <?php get_search_form(); ?>
                </div>

                <div class="widget widget_pages">
                    <h3 class="widget-title"><?php esc_html_e('Pages', 'outdoor-adventure'); ?></h3>
                    <ul>
                        <?php
                        wp_list_pages(array(
                            'title_li' => '',
                        ));
                        ?>
                    </ul>
                </div>

                <div class="widget widget_archive">
                    <h3 class="widget-title"><?php esc_html_e('Archives', 'outdoor-adventure'); ?></h3>
                    <ul>
                        <?php wp_get_archives(['type' => 'monthly', 'show_post_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_categories">
                    <h3 class="widget-title"><?php esc_html_e('Categories', 'outdoor-adventure'); ?></h3>
                    <ul class="wp-block-categories-list wp-block-categories">
                        <?php wp_list_categories(['orderby' => 'name', 'title_li' => '', 'show_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_tag_cloud">
                    <h3 class="widget-title"><?php esc_html_e('Tags', 'outdoor-adventure'); ?></h3>
                    <?php
                    $outdoor_adventure_tags = get_tags();
                    if ( $outdoor_adventure_tags ) {
                        echo '<div class="tagcloud">';
                        foreach ( $outdoor_adventure_tags as $outdoor_adventure_tag ) {
                            $outdoor_adventure_link = get_tag_link($outdoor_adventure_tag->term_id);
                            echo '<a href="' . esc_url($outdoor_adventure_link) . '" class="tag-cloud-link">' . esc_html($outdoor_adventure_tag->name) . '</a> ';
                        }
                        echo '</div>';
                    } else {
                        echo '<p>' . esc_html__('No tags found.', 'outdoor-adventure') . '</p>';
                    }
                    ?>
                </div>

            <?php endif; ?>
        </div>
    </aside>
<?php endif; ?>
