<?php
/**
 *
 * Pagination Functions
 *
 * @package Outdoor Adventure
 */

/**
 * Pagination for archive.
 */
function outdoor_adventure_render_posts_pagination() {
    // Get the setting to check if pagination is enabled
    $outdoor_adventure_is_pagination_enabled = get_theme_mod( 'outdoor_adventure_enable_pagination', true );

    // Check if pagination is enabled
    if ( $outdoor_adventure_is_pagination_enabled ) {
        // Get the selected pagination type from the Customizer
        $outdoor_adventure_pagination_type = get_theme_mod( 'outdoor_adventure_theme_pagination_type', 'numeric' );

        // Check if the pagination type is "newer_older" (Previous/Next) or "numeric"
        if ( 'newer_older' === $outdoor_adventure_pagination_type ) :
            // Display "Newer/Older" pagination (Previous/Next navigation)
            the_posts_navigation(
                array(
                    'prev_text' => __( '&laquo; Newer', 'outdoor-adventure' ),  // Change the label for "previous"
                    'next_text' => __( 'Older &raquo;', 'outdoor-adventure' ),  // Change the label for "next"
                    'screen_reader_text' => __( 'Posts navigation', 'outdoor-adventure' ),
                )
            );
        else :
            // Display numeric pagination (Page numbers)
            the_posts_pagination(
                array(
                    'prev_text' => __( '&laquo; Previous', 'outdoor-adventure' ),
                    'next_text' => __( 'Next &raquo;', 'outdoor-adventure' ),
                    'type'      => 'list', // Display as <ul> <li> tags
                    'screen_reader_text' => __( 'Posts navigation', 'outdoor-adventure' ),
                )
            );
        endif;
    }
}
add_action( 'outdoor_adventure_posts_pagination', 'outdoor_adventure_render_posts_pagination', 10 );