<?php
/**
* Posts Settings.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();

// Single Post Section.
$wp_customize->add_section( 'outdoor_adventure_single_posts_settings',
    array(
    'title'      => esc_html__( 'Single Meta Information Settings', 'outdoor-adventure' ),
    'priority'   => 35,
    'capability' => 'edit_theme_options',
    'panel'      => 'outdoor_adventure_theme_option_panel',
    )
);

$wp_customize->add_setting('outdoor_adventure_display_single_post_image',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_display_single_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_display_single_post_image',
    array(
        'label' => esc_html__('Enable Single Posts Image', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_post_author',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_post_author'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_post_author',
    array(
        'label' => esc_html__('Enable Posts Author', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_post_date',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_post_date'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_post_date',
    array(
        'label' => esc_html__('Enable Posts Date', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_post_category',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_post_tags',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_post_tags'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_post_tags',
    array(
        'label' => esc_html__('Enable Posts Tags', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_single_page_content_alignment',
    array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_single_page_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'outdoor_adventure_single_page_content_alignment',
    array(
    'label'       => esc_html__( 'Single Page Content Alignment', 'outdoor-adventure' ),
    'section'     => 'outdoor_adventure_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'outdoor-adventure' ),
        'center'  => esc_html__( 'Center', 'outdoor-adventure' ),
        'right'    => esc_html__( 'Right', 'outdoor-adventure' ),
        ),
    )
);

$wp_customize->add_setting( 'outdoor_adventure_single_post_content_alignment',
    array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_single_post_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'outdoor_adventure_single_post_content_alignment',
    array(
    'label'       => esc_html__( 'Single Post Content Alignment', 'outdoor-adventure' ),
    'section'     => 'outdoor_adventure_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'outdoor-adventure' ),
        'center'  => esc_html__( 'Center', 'outdoor-adventure' ),
        'right'    => esc_html__( 'Right', 'outdoor-adventure' ),
        ),
    )
);

// Archive Post Section.
$wp_customize->add_section( 'outdoor_adventure_posts_settings',
    array(
    'title'      => esc_html__( 'Archive Meta Information Settings', 'outdoor-adventure' ),
    'priority'   => 36,
    'capability' => 'edit_theme_options',
    'panel'      => 'outdoor_adventure_theme_option_panel',
    )
);

$wp_customize->add_setting('outdoor_adventure_display_archive_post_format_icon',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_display_archive_post_format_icon'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_display_archive_post_format_icon',
    array(
        'label' => esc_html__('Enable Posts Format Icon', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_display_archive_post_image',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_display_archive_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_display_archive_post_image',
    array(
        'label' => esc_html__('Enable Posts Image', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_display_archive_post_category',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_display_archive_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_display_archive_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_display_archive_post_title',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_display_archive_post_title'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_display_archive_post_title',
    array(
        'label' => esc_html__('Enable Posts Title', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_display_archive_post_content',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_display_archive_post_content'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_display_archive_post_content',
    array(
        'label' => esc_html__('Enable Posts Content', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_display_archive_post_button',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_display_archive_post_button'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_display_archive_post_button',
    array(
        'label' => esc_html__('Enable Posts Button', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_excerpt_limit',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_excerpt_limit'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
    )
);
$wp_customize->add_control('outdoor_adventure_excerpt_limit',
    array(
        'label'       => esc_html__('Blog Posts Excerpt limit', 'outdoor-adventure'),
        'section'     => 'outdoor_adventure_posts_settings',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 100,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'outdoor_adventure_archive_image_size',
	array(
	'default'           => 'medium',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'outdoor_adventure_sanitize_select',
	)
);
$wp_customize->add_control( 'outdoor_adventure_archive_image_size',
	array(
	'label'       => esc_html__( 'Blog Posts Image Size', 'outdoor-adventure' ),
	'section'     => 'outdoor_adventure_posts_settings',
	'type'        => 'select',
	'choices'               => array(
		'full' => esc_html__( 'Large Size Image', 'outdoor-adventure' ),
		'large' => esc_html__( 'Big Size Image', 'outdoor-adventure' ),
		'medium' => esc_html__( 'Medium Size Image', 'outdoor-adventure' ),
		'small' => esc_html__( 'Small Size Image', 'outdoor-adventure' ),
		'xsmall' => esc_html__( 'Extra Small Size Image', 'outdoor-adventure' ),
		'thumbnail' => esc_html__( 'Thumbnail Size Image', 'outdoor-adventure' ),
	    ),
	)
);

$wp_customize->add_setting('outdoor_adventure_posts_per_columns',
    array(
    'default'           => '3',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
    )
);
$wp_customize->add_control('outdoor_adventure_posts_per_columns',
    array(
    'label'       => esc_html__('Blog Posts Per Column', 'outdoor-adventure'),
    'section'     => 'outdoor_adventure_posts_settings',
    'type'        => 'number',
    'input_attrs' => array(
    'min'   => 1,
    'max'   => 5,
    'step'   => 1,
    ),
    )
);