<?php
/**
* Layouts Settings.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'outdoor_adventure_layout_setting',
	array(
	'title'      => esc_html__( 'Sidebar Settings', 'outdoor-adventure' ),
	'priority'   => 20,
	'capability' => 'edit_theme_options',
	'panel'      => 'outdoor_adventure_theme_option_panel',
	)
);

$wp_customize->add_setting( 'outdoor_adventure_global_sidebar_layout',
    array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_sidebar_option',
    )
);
$wp_customize->add_control( 'outdoor_adventure_global_sidebar_layout',
    array(
    'label'       => esc_html__( 'Global Sidebar Layout', 'outdoor-adventure' ),
    'section'     => 'outdoor_adventure_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__( 'Right Sidebar', 'outdoor-adventure' ),
        'left-sidebar'  => esc_html__( 'Left Sidebar', 'outdoor-adventure' ),
        'no-sidebar'    => esc_html__( 'No Sidebar', 'outdoor-adventure' ),
        ),
    )
);

$wp_customize->add_setting('outdoor_adventure_page_sidebar_layout', array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_sidebar_option',
));

$wp_customize->add_control('outdoor_adventure_page_sidebar_layout', array(
    'label'       => esc_html__('Single Page Sidebar Layout', 'outdoor-adventure'),
    'section'     => 'outdoor_adventure_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'outdoor-adventure'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'outdoor-adventure'),
        'no-sidebar'    => esc_html__('No Sidebar', 'outdoor-adventure'),
    ),
));

$wp_customize->add_setting('outdoor_adventure_post_sidebar_layout', array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_sidebar_option',
));

$wp_customize->add_control('outdoor_adventure_post_sidebar_layout', array(
    'label'       => esc_html__('Single Post Sidebar Layout', 'outdoor-adventure'),
    'section'     => 'outdoor_adventure_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'outdoor-adventure'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'outdoor-adventure'),
        'no-sidebar'    => esc_html__('No Sidebar', 'outdoor-adventure'),
    ),
));

$wp_customize->add_setting('outdoor_adventure_sticky_sidebar',
    array(
        'default'           => true,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_sticky_sidebar',
    array(
        'label' => esc_html__('Enable/Disable Sticky Sidebar', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_layout_setting',
        'type' => 'checkbox',
    )
);