<?php
/**
* Header Banner Options.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();
$outdoor_adventure_post_category_list = outdoor_adventure_post_category_list();

$wp_customize->add_section( 'outdoor_adventure_header_banner_setting',
    array(
    'title'      => esc_html__( 'Slider Settings', 'outdoor-adventure' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'outdoor_adventure_theme_home_pannel',
    )
);

// Show/Hide Site Logo
$wp_customize->add_setting('outdoor_adventure_display_logo', array(
    'default'           => false,
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
));
$wp_customize->add_control('outdoor_adventure_display_logo', array(
    'label'    => esc_html__('Enable / Disable Site Logo', 'outdoor-adventure'),
    'section'  => 'title_tagline',
    'type'     => 'checkbox',
));

// Show/Hide Site Title
$wp_customize->add_setting('outdoor_adventure_display_title', array(
    'default'           => true,
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
));
$wp_customize->add_control('outdoor_adventure_display_title', array(
    'label'    => esc_html__('Enable / Disable Site Title', 'outdoor-adventure'),
    'section'  => 'title_tagline',
    'type'     => 'checkbox',
));

// Show/Hide Site Tagline
$wp_customize->add_setting('outdoor_adventure_display_header_text',
    array(
        'default'           => false,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_display_header_text',
    array(
        'label' => esc_html__('Enable / Disable Site Tagline', 'outdoor-adventure'),
        'section' => 'title_tagline',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_header_banner',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_header_banner'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_header_banner',
    array(
        'label' => esc_html__('Enable Slider', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_header_banner_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('outdoor_adventure_banner_background_image',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_banner_background_image'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'outdoor_adventure_banner_background_image',
        array(
            'label' => __('Slider Background Image','outdoor-adventure'),
            'section' => 'outdoor_adventure_header_banner_setting',
            'settings' => 'outdoor_adventure_banner_background_image',
        )
    )
);

$wp_customize->add_setting( 'outdoor_adventure_header_banner_cat',
    array(
    'default'           => '',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_select',
    )
);
$wp_customize->add_control( 'outdoor_adventure_header_banner_cat',
    array(
    'label'       => esc_html__( 'Slider Post Category', 'outdoor-adventure' ),
    'section'     => 'outdoor_adventure_header_banner_setting',
    'type'        => 'select',
    'choices'     => $outdoor_adventure_post_category_list,
    )
);

$wp_customize->add_setting( 'outdoor_adventure_slider_section_short_title',
    array(
    'default' => $outdoor_adventure_default['outdoor_adventure_slider_section_short_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_slider_section_short_title',
    array(
    'label'    => esc_html__( 'Short Title', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_header_banner_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_slider_video_button_url',
    array(
    'default'           => '#',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_slider_video_button_url',
    array(
    'label'    => esc_html__( 'Video Url', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_header_banner_setting',
    'type'     => 'url',
    )
);



/* Adventure Packs */


$wp_customize->add_section( 'outdoor_adventure_header_category_setting',
    array(
    'title'      => esc_html__( 'Adventure Packs Settings', 'outdoor-adventure' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'outdoor_adventure_theme_home_pannel',
    )
);

$wp_customize->add_setting('outdoor_adventure_services',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_services'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_services',
    array(
        'label' => esc_html__('Enable Adventure Packs Section', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_header_category_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_services_section_title',
    array(
    'default' => $outdoor_adventure_default['outdoor_adventure_services_section_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_services_section_title',
    array(
    'label'    => esc_html__( 'Main Title', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_header_category_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_services_section_short_title',
    array(
    'default' => $outdoor_adventure_default['outdoor_adventure_services_section_short_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_services_section_short_title',
    array(
    'label'    => esc_html__( 'Short Title', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_header_category_setting',
    'type'     => 'text',
    )
);

$categories = get_categories();
$cat_post = array();
$cat_post[]= 'select';
$m = 0;
foreach($categories as $category){
    if($m==0){
        $default = $category->slug;
        $m++;
    }
    $cat_post[$category->slug] = $category->name;
}

$wp_customize->add_setting('outdoor_adventure_video_section_left_post_cat',array(
    'default'   => '',
    'sanitize_callback' => 'outdoor_adventure_sanitize_select',
));
$wp_customize->add_control('outdoor_adventure_video_section_left_post_cat' ,array(
    'type'    => 'select',
    'choices' => $cat_post,
    'label' => __('Select Category to display Adventure Post','outdoor-adventure'),
    'section' => 'outdoor_adventure_header_category_setting',
));