<?php
/**
* Header Options.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();

// Header Section.
$wp_customize->add_section( 'outdoor_adventure_button_header_setting',
	array(
	'title'      => esc_html__( 'Header Settings', 'outdoor-adventure' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	'panel'      => 'outdoor_adventure_theme_option_panel',
	)
);

$wp_customize->add_setting('outdoor_adventure_sticky',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_sticky'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_sticky',
    array(
        'label' => esc_html__('Enable Sticky Header', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_button_header_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_header_layout_phone_number_text',
    array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_header_layout_phone_number_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_header_layout_phone_number_text',
    array(
    'label'    => esc_html__( 'Header Phone Number Text', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_header_layout_phone_number',
    array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_header_layout_phone_number'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_header_layout_phone_number',
    array(
    'label'    => esc_html__( 'Header Phone Number', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting('outdoor_adventure_menu_font_size',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_menu_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
    )
);
$wp_customize->add_control('outdoor_adventure_menu_font_size',
    array(
        'label'       => esc_html__('Menu Font Size', 'outdoor-adventure'),
        'section'     => 'outdoor_adventure_button_header_setting',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 30,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'outdoor_adventure_menu_text_transform',
    array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_menu_text_transform'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_menu_transform',
    )
);
$wp_customize->add_control( 'outdoor_adventure_menu_text_transform',
    array(
    'label'       => esc_html__( 'Menu Text Transform', 'outdoor-adventure' ),
    'section'     => 'outdoor_adventure_button_header_setting',
    'type'        => 'select',
    'choices'     => array(
        'capitalize' => esc_html__( 'Capitalize', 'outdoor-adventure' ),
        'uppercase'  => esc_html__( 'Uppercase', 'outdoor-adventure' ),
        'lowercase'    => esc_html__( 'Lowercase', 'outdoor-adventure' ),
        ),
    )
);