<?php
/**
* Global Color Settings.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'outdoor_adventure_global_color_setting',
	array(
	'title'      => esc_html__( 'Global Color Settings', 'outdoor-adventure' ),
	'priority'   => 1,
	'capability' => 'edit_theme_options',
	'panel'      => 'outdoor_adventure_theme_option_panel',
	)
);

$wp_customize->add_setting( 'outdoor_adventure_global_color',
    array(
    'default'           => '#1A1A1A',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'outdoor_adventure_global_color',
    array(
        'label'      => esc_html__( 'Global Color', 'outdoor-adventure' ),
        'section'    => 'outdoor_adventure_global_color_setting',
        'settings'   => 'outdoor_adventure_global_color',
    ) ) 
);

$wp_customize->add_setting( 'outdoor_adventure_secondary_color',
    array(
    'default'           => '#00AEFF',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'outdoor_adventure_secondary_color',
    array(
        'label'      => esc_html__( 'Seconday Color', 'outdoor-adventure' ),
        'section'    => 'outdoor_adventure_global_color_setting',
        'settings'   => 'outdoor_adventure_secondary_color',
    ) ) 
);