<?php
/**
* Footer Settings.
*
* @package Outdoor Adventure
*/

$outdoor_adventure_default = outdoor_adventure_get_default_theme_options();

$wp_customize->add_section( 'outdoor_adventure_footer_widget_area',
	array(
	'title'      => esc_html__( 'Footer Settings', 'outdoor-adventure' ),
	'priority'   => 200,
	'capability' => 'edit_theme_options',
	'panel'      => 'outdoor_adventure_theme_option_panel',
	)
);

$wp_customize->add_setting('outdoor_adventure_display_footer',
    array(
    'default' => $outdoor_adventure_default['outdoor_adventure_display_footer'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
)
);
$wp_customize->add_control('outdoor_adventure_display_footer',
    array(
        'label' => esc_html__('Enable Footer', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_footer_column_layout',
	array(
	'default'           => $outdoor_adventure_default['outdoor_adventure_footer_column_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'outdoor_adventure_sanitize_select',
	)
);
$wp_customize->add_control( 'outdoor_adventure_footer_column_layout',
	array(
	'label'       => esc_html__( 'Footer Column Layout', 'outdoor-adventure' ),
	'section'     => 'outdoor_adventure_footer_widget_area',
	'type'        => 'select',
	'choices'               => array(
		'1' => esc_html__( 'One Column', 'outdoor-adventure' ),
		'2' => esc_html__( 'Two Column', 'outdoor-adventure' ),
		'3' => esc_html__( 'Three Column', 'outdoor-adventure' ),
	    ),
	)
);

$wp_customize->add_setting( 'outdoor_adventure_footer_widget_title_alignment',
    array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_footer_widget_title_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_footer_widget_title_alignment',
    )
);
$wp_customize->add_control( 'outdoor_adventure_footer_widget_title_alignment',
    array(
    'label'       => esc_html__( 'Footer Widget Title Alignment', 'outdoor-adventure' ),
    'section'     => 'outdoor_adventure_footer_widget_area',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'outdoor-adventure' ),
        'center'  => esc_html__( 'Center', 'outdoor-adventure' ),
        'right'    => esc_html__( 'Right', 'outdoor-adventure' ),
        ),
    )
);

$wp_customize->add_setting( 'outdoor_adventure_footer_copyright_text',
	array(
	'default'           => $outdoor_adventure_default['outdoor_adventure_footer_copyright_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'outdoor_adventure_footer_copyright_text',
	array(
	'label'    => esc_html__( 'Footer Copyright Text', 'outdoor-adventure' ),
	'section'  => 'outdoor_adventure_footer_widget_area',
	'type'     => 'text',
	)
);

$wp_customize->add_setting('outdoor_adventure_copyright_font_size',
    array(
        'default'           => $outdoor_adventure_default['outdoor_adventure_copyright_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_number_range',
    )
);
$wp_customize->add_control('outdoor_adventure_copyright_font_size',
    array(
        'label'       => esc_html__('Copyright Font Size', 'outdoor-adventure'),
        'section'     => 'outdoor_adventure_footer_widget_area',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 5,
           'max'   => 30,
           'step'   => 1,
    	),
    )
);

$wp_customize->add_setting( 'outdoor_adventure_copyright_alignment', array(
    'default'           => 'Default',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'outdoor_adventure_sanitize_copyright_alignment_meta',
) );

$wp_customize->add_control( 'outdoor_adventure_copyright_alignment', array(
    'label'    => esc_html__( 'Copyright Section Alignment', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_footer_widget_area',
    'type'     => 'select',
    'choices'  => array(
        'Default' => esc_html__( 'Default View', 'outdoor-adventure' ),
        'Reverse' => esc_html__( 'Reverse View', 'outdoor-adventure' ),
        'Center'  => esc_html__( 'Centered Content', 'outdoor-adventure' ),
    ),
) );

$wp_customize->add_setting( 'outdoor_adventure_footer_widget_background_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'outdoor_adventure_footer_widget_background_color', array(
    'label'     => __('Footer Widget Background Color', 'outdoor-adventure'),
    'description' => __('It will change the complete footer widget background color.', 'outdoor-adventure'),
    'section' => 'outdoor_adventure_footer_widget_area',
    'settings' => 'outdoor_adventure_footer_widget_background_color',
)));

$wp_customize->add_setting('outdoor_adventure_footer_widget_background_image',array(
    'default'   => '',
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'outdoor_adventure_footer_widget_background_image',array(
    'label' => __('Footer Widget Background Image','outdoor-adventure'),
    'section' => 'outdoor_adventure_footer_widget_area'
)));

$wp_customize->add_setting('outdoor_adventure_enable_to_the_top',
    array(
        'default' => $outdoor_adventure_default['outdoor_adventure_enable_to_the_top'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'outdoor_adventure_sanitize_checkbox',
    )
);
$wp_customize->add_control('outdoor_adventure_enable_to_the_top',
    array(
        'label' => esc_html__('Enable To The Top', 'outdoor-adventure'),
        'section' => 'outdoor_adventure_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'outdoor_adventure_to_the_top_text',
    array(
    'default'           => $outdoor_adventure_default['outdoor_adventure_to_the_top_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'outdoor_adventure_to_the_top_text',
    array(
    'label'    => esc_html__( 'Edit Text Here', 'outdoor-adventure' ),
    'section'  => 'outdoor_adventure_footer_widget_area',
    'type'     => 'text',
    )
);