<?php
/**
 * Default Values.
 *
 * @package Outdoor Adventure
 */

if ( ! function_exists( 'outdoor_adventure_get_default_theme_options' ) ) :
	function outdoor_adventure_get_default_theme_options() {

		$outdoor_adventure_defaults = array();
		
		// Options.
        $outdoor_adventure_defaults['outdoor_adventure_logo_width_range']                            = 200;
	$outdoor_adventure_defaults['outdoor_adventure_global_sidebar_layout']		           = 'right-sidebar';
        $outdoor_adventure_defaults['outdoor_adventure_theme_breadcrumb_options_alignment']          = 'Left';
        $outdoor_adventure_defaults['outdoor_adventure_theme_pagination_options_alignment']          = 'Center';
        $outdoor_adventure_defaults['outdoor_adventure_theme_loader']                                = 0;
        $outdoor_adventure_defaults['outdoor_adventure_header_layout_phone_number_text']             = esc_html__( 'contact us', 'outdoor-adventure' );
        $outdoor_adventure_defaults['outdoor_adventure_header_layout_phone_number']                  = '+123 456 789';
        $outdoor_adventure_defaults['outdoor_adventure_pagination_layout']                           = 'numeric';
	$outdoor_adventure_defaults['outdoor_adventure_footer_column_layout'] 			   = 3;
        $outdoor_adventure_defaults['outdoor_adventure_menu_font_size']                              = 15;
        $outdoor_adventure_defaults['outdoor_adventure_copyright_font_size']                         = 16;
        $outdoor_adventure_defaults['outdoor_adventure_breadcrumb_font_size']                        = 16;
        $outdoor_adventure_defaults['outdoor_adventure_excerpt_limit']                               = 20;
        $outdoor_adventure_defaults['outdoor_adventure_menu_text_transform']                         = 'Capitalize';  
        $outdoor_adventure_defaults['outdoor_adventure_single_page_content_alignment']               = 'left';
        $outdoor_adventure_defaults['outdoor_adventure_per_columns']                                 = 3;  
        $outdoor_adventure_defaults['outdoor_adventure_product_per_page']                            = 9; 
        $outdoor_adventure_defaults['outdoor_adventure_custom_related_products_number'] = 6;
        $outdoor_adventure_defaults['outdoor_adventure_custom_related_products_number_per_row'] = 3; 
	$outdoor_adventure_defaults['outdoor_adventure_footer_copyright_text'] 		           = esc_html__( 'All rights reserved.', 'outdoor-adventure' );
        $outdoor_adventure_defaults['twp_navigation_type']              			           = 'theme-normal-navigation';
        $outdoor_adventure_defaults['outdoor_adventure_post_author']                		   = 1;
        $outdoor_adventure_defaults['outdoor_adventure_post_date']                		   = 1;
        $outdoor_adventure_defaults['outdoor_adventure_post_category']                	           = 1;
        $outdoor_adventure_defaults['outdoor_adventure_post_tags']                		   = 1;
        $outdoor_adventure_defaults['outdoor_adventure_floating_next_previous_nav']                  = 1;
        $outdoor_adventure_defaults['outdoor_adventure_header_banner']               		   = 1;
        $outdoor_adventure_defaults['outdoor_adventure_display_header_title']                        = 1;
        $outdoor_adventure_defaults['outdoor_adventure_sticky']                                      = 0;
        $outdoor_adventure_defaults['outdoor_adventure_services']               	                   = 1;        
        $outdoor_adventure_defaults['outdoor_adventure_background_color']               	           = '#fff';
        $outdoor_adventure_defaults['outdoor_adventure_display_footer']                              = 1;
        $outdoor_adventure_defaults['outdoor_adventure_footer_widget_title_alignment']               = 'left'; 
        $outdoor_adventure_defaults['outdoor_adventure_show_hide_related_product']                   = 1;
        $outdoor_adventure_defaults['outdoor_adventure_display_archive_post_image']                  = 1;
        $outdoor_adventure_defaults['outdoor_adventure_secondary_color']                        = '#000000';
        $outdoor_adventure_defaults['outdoor_adventure_global_color']                           = '#1A1A1A';
        $outdoor_adventure_defaults['outdoor_adventure_display_archive_post_category']          = 1;
        $outdoor_adventure_defaults['outdoor_adventure_display_archive_post_title']             = 1;
        $outdoor_adventure_defaults['outdoor_adventure_display_archive_post_content']           = 1;
        $outdoor_adventure_defaults['outdoor_adventure_display_archive_post_button']            = 1;
        
        $outdoor_adventure_defaults['outdoor_adventure_display_single_post_image']              = 1;
        $outdoor_adventure_defaults['outdoor_adventure_display_archive_post_format_icon']       = 1;

        $outdoor_adventure_defaults['outdoor_adventure_display_single_post_image']              = 1;
        $outdoor_adventure_defaults['outdoor_adventure_display_archive_post_format_icon']       = 1;

        $outdoor_adventure_defaults['outdoor_adventure_slider_section_short_title']                = esc_html__( 'we are adventureFlay', 'outdoor-adventure' );
        $outdoor_adventure_defaults['outdoor_adventure_banner_background_image']                   = esc_url(get_template_directory_uri() . '/assets/images/slide-bg.png');

	$outdoor_adventure_defaults['outdoor_adventure_services_section_short_title'] 	           = esc_html__( 'AdventureFlay', 'outdoor-adventure' );
	$outdoor_adventure_defaults['outdoor_adventure_services_section_title'] 	           = esc_html__( 'Paragliding pack', 'outdoor-adventure' );

        $outdoor_adventure_defaults['outdoor_adventure_enable_to_the_top']                         = 1;
        $outdoor_adventure_defaults['outdoor_adventure_to_the_top_text']                           = esc_html__( 'To The Top', 'outdoor-adventure' );
        $outdoor_adventure_defaults['outdoor_adventure_theme_breadcrumb_enable']                   = 1;
        $outdoor_adventure_defaults['outdoor_adventure_single_post_content_alignment']             = 'left';

        // 404 Page Defaults
        $outdoor_adventure_defaults['outdoor_adventure_404_main_title'] = esc_html__( 'Oops! That page can’t be found.', 'outdoor-adventure' );
        $outdoor_adventure_defaults['outdoor_adventure_404_subtitle_one'] = esc_html__( 'Maybe it’s out there, somewhere...', 'outdoor-adventure' );
        $outdoor_adventure_defaults['outdoor_adventure_404_para_one'] = esc_html__( 'You can always find insightful stories on our', 'outdoor-adventure' );
        $outdoor_adventure_defaults['outdoor_adventure_404_subtitle_two'] = esc_html__( 'Still feeling lost? You’re not alone.', 'outdoor-adventure' );
        $outdoor_adventure_defaults['outdoor_adventure_404_para_two'] = esc_html__( 'Enjoy these stories about getting lost, losing things, and finding what you never knew you were looking for.', 'outdoor-adventure' );

        // Pass through filter.
        $outdoor_adventure_defaults = apply_filters( 'outdoor_adventure_filter_default_theme_options', $outdoor_adventure_defaults );

        return $outdoor_adventure_defaults;
	}
endif;
