<?php
/**
 * Outdoor Adventure functions and definitions
 * @package Outdoor Adventure
 */

if ( ! function_exists( 'outdoor_adventure_after_theme_support' ) ) :

	function outdoor_adventure_after_theme_support() {
		
		add_theme_support( 'automatic-feed-links' );

		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'ffffff',
			)
		);

		$GLOBALS['content_width'] = apply_filters( 'outdoor_adventure_content_width', 1140 );
		
		add_theme_support( 'post-thumbnails' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 270,
				'width'       => 90,
				'flex-height' => true,
				'flex-width'  => true,
			)
		);
		
		add_theme_support( 'title-tag' );

        load_theme_textdomain( 'outdoor-adventure', get_template_directory() . '/languages' );

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			)
		);

		add_theme_support( 'post-formats', array(
			'video',  
			'audio',  
			'gallery',
			'quote',  
			'image',  
			'link',   
			'status', 
			'aside',  
			'chat',   
		) );
		
		add_theme_support( 'align-wide' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'wp-block-styles' );

		require get_template_directory() . '/inc/metabox.php';
		require get_template_directory() . '/inc/homepage-setup/homepage-setup-settings.php';

		if (! defined( 'OUTDOOR_ADVENTURE_DOCS_PRO' ) ){
		define('OUTDOOR_ADVENTURE_DOCS_PRO',__('https://layout.omegathemes.com/steps/pro-outdoor-adventure/','outdoor-adventure'));
		}
		if (! defined( 'OUTDOOR_ADVENTURE_BUY_NOW' ) ){
		define('OUTDOOR_ADVENTURE_BUY_NOW',__('https://www.omegathemes.com/products/outdoor-adventure-wordpress-theme','outdoor-adventure'));
		}
		if (! defined( 'OUTDOOR_ADVENTURE_SUPPORT_FREE' ) ){
		define('OUTDOOR_ADVENTURE_SUPPORT_FREE',__('https://wordpress.org/support/theme/outdoor-adventure/','outdoor-adventure'));
		}
		if (! defined( 'OUTDOOR_ADVENTURE_REVIEW_FREE' ) ){
		define('OUTDOOR_ADVENTURE_REVIEW_FREE',__('https://wordpress.org/support/theme/outdoor-adventure/reviews/#new-post/','outdoor-adventure'));
		}
		if (! defined( 'OUTDOOR_ADVENTURE_DEMO_PRO' ) ){
		define('OUTDOOR_ADVENTURE_DEMO_PRO',__('https://layout.omegathemes.com/outdoor-adventure/','outdoor-adventure'));
		}
		if (! defined( 'OUTDOOR_ADVENTURE_LITE_DOCS_PRO' ) ){
		define('OUTDOOR_ADVENTURE_LITE_DOCS_PRO',__('https://layout.omegathemes.com/steps/free-outdoor-adventure/','outdoor-adventure'));
		}
		if (! defined( 'OUTDOOR_ADVENTURE_BUNDLE_BUTTON' ) ){
			define('OUTDOOR_ADVENTURE_BUNDLE_BUTTON',__('https://www.omegathemes.com/products/wp-theme-bundle','outdoor-adventure'));
		}

	}

endif;

add_action( 'after_setup_theme', 'outdoor_adventure_after_theme_support' );

/**
 * Register and Enqueue Styles.
 */
function outdoor_adventure_register_styles() {

	wp_enqueue_style( 'dashicons' );

    $outdoor_adventure_theme_version = wp_get_theme()->get( 'Version' );
	$outdoor_adventure_fonts_url = outdoor_adventure_fonts_url();
    if( $outdoor_adventure_fonts_url ){
    	require get_theme_file_path( 'lib/custom/css/wptt-webfont-loader.php' );
        wp_enqueue_style(
			'outdoor-adventure-google-fonts',
			wptt_get_webfont_url( $outdoor_adventure_fonts_url ),
			array(),
			$outdoor_adventure_theme_version
		);
    }

    wp_enqueue_style( 'swiper', get_template_directory_uri() . '/lib/swiper/css/swiper-bundle.min.css');
    wp_enqueue_style( 'owl.carousel', get_template_directory_uri() . '/lib/custom/css/owl.carousel.min.css');
	wp_enqueue_style( 'outdoor-adventure-style', get_stylesheet_uri(), array(), $outdoor_adventure_theme_version );

	wp_enqueue_style( 'outdoor-adventure-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/custom_css.php' );
	wp_add_inline_style( 'outdoor-adventure-style',$outdoor_adventure_custom_css );

	$outdoor_adventure_css = '';

	if ( get_header_image() ) :

		$outdoor_adventure_css .=  '
			.header-navbar{
				background-image: url('.esc_url(get_header_image()).');
				-webkit-background-size: cover !important;
				-moz-background-size: cover !important;
				-o-background-size: cover !important;
				background-size: cover !important;
			}';

	endif;

	wp_add_inline_style( 'outdoor-adventure-style', $outdoor_adventure_css );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}	

	wp_enqueue_script( 'imagesloaded' );
    wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'swiper', get_template_directory_uri() . '/lib/swiper/js/swiper-bundle.min.js', array('jquery'), '', 1);
	wp_enqueue_script( 'outdoor-adventure-custom', get_template_directory_uri() . '/lib/custom/js/theme-custom-script.js', array('jquery'), '', 1);
	wp_enqueue_script( 'owl.carousel', get_template_directory_uri() . '/lib/custom/js/owl.carousel.js', array('jquery'), '', 1);

    // Global Query
    if( is_front_page() ){

    	$outdoor_adventure_posts_per_page = absint( get_option('posts_per_page') );
        $outdoor_adventure_c_paged = ( get_query_var( 'page' ) ) ? absint( get_query_var( 'page' ) ) : 1;
        $outdoor_adventure_posts_args = array(
            'posts_per_page'        => $outdoor_adventure_posts_per_page,
            'paged'                 => $outdoor_adventure_c_paged,
        );
        $posts_qry = new WP_Query( $outdoor_adventure_posts_args );
        $max = $posts_qry->max_num_pages;

    }else{
        global $wp_query;
        $max = $wp_query->max_num_pages;
        $outdoor_adventure_c_paged = ( get_query_var( 'paged' ) > 1 ) ? get_query_var( 'paged' ) : 1;
    }

    $outdoor_adventure_default = outdoor_adventure_get_default_theme_options();
    $outdoor_adventure_pagination_layout = get_theme_mod( 'outdoor_adventure_pagination_layout',$outdoor_adventure_default['outdoor_adventure_pagination_layout'] );
}

add_action( 'wp_enqueue_scripts', 'outdoor_adventure_register_styles',200 );

function outdoor_adventure_admin_enqueue_scripts_callback() {
    if ( ! did_action( 'wp_enqueue_media' ) ) {
    wp_enqueue_media();
    }
    wp_enqueue_script('outdoor-adventure-uploaderjs', get_stylesheet_directory_uri() . '/lib/custom/js/uploader.js', array(), "1.0", true);
}
add_action( 'admin_enqueue_scripts', 'outdoor_adventure_admin_enqueue_scripts_callback' );

/**
 * Register navigation menus uses wp_nav_menu in five places.
 */
function outdoor_adventure_menus() {

	$outdoor_adventure_locations = array(
		'outdoor-adventure-primary-menu'  => esc_html__( 'Primary Menu', 'outdoor-adventure' ),
	);

	register_nav_menus( $outdoor_adventure_locations );
}

add_action( 'init', 'outdoor_adventure_menus' );

add_filter('loop_shop_columns', 'outdoor_adventure_loop_columns');
if (!function_exists('outdoor_adventure_loop_columns')) {
	function outdoor_adventure_loop_columns() {
		$outdoor_adventure_columns = get_theme_mod( 'outdoor_adventure_per_columns', 3 );
		return $outdoor_adventure_columns;
	}
}

add_filter( 'loop_shop_per_page', 'outdoor_adventure_per_page', 20 );
function outdoor_adventure_per_page( $outdoor_adventure_cols ) {
  	$outdoor_adventure_cols = get_theme_mod( 'outdoor_adventure_product_per_page', 9 );
	return $outdoor_adventure_cols;
}

function outdoor_adventure_products_args( $outdoor_adventure_args ) {

    $outdoor_adventure_args['posts_per_page'] = get_theme_mod( 'outdoor_adventure_custom_related_products_number', 6 );

    $outdoor_adventure_args['columns'] = get_theme_mod( 'outdoor_adventure_custom_related_products_number_per_row', 3 );

    return $outdoor_adventure_args;
}

require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/classes/class-svg-icons.php';
require get_template_directory() . '/classes/class-walker-menu.php';
require get_template_directory() . '/inc/customizer/customizer.php';
require get_template_directory() . '/inc/custom-functions.php';
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/classes/body-classes.php';
require get_template_directory() . '/inc/widgets/widgets.php';
require get_template_directory() . '/inc/pagination.php';
require get_template_directory() . '/lib/breadcrumbs/breadcrumbs.php';
require get_template_directory() . '/lib/custom/css/dynamic-style.php';


function outdoor_adventure_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'outdoor_adventure_remove_customize_register', 11 );

function outdoor_adventure_radio_sanitize(  $outdoor_adventure_input, $outdoor_adventure_setting  ) {
	$outdoor_adventure_input = sanitize_key( $outdoor_adventure_input );
	$outdoor_adventure_choices = $outdoor_adventure_setting->manager->get_control( $outdoor_adventure_setting->id )->choices;
	return ( array_key_exists( $outdoor_adventure_input, $outdoor_adventure_choices ) ? $outdoor_adventure_input : $outdoor_adventure_setting->default );
}
require get_template_directory() . '/inc/general.php';


// NOTICE FUNCTION

function outdoor_adventure_admin_notice() { 
    global $pagenow;
    $theme_args = wp_get_theme();
    $meta = get_option( 'outdoor_adventure_admin_notice' );
    $name = $theme_args->get( 'Name' );
    $current_screen = get_current_screen();

    if ( ! $meta ) {
        if ( is_network_admin() ) {
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if ( $current_screen->base != 'appearance_page_outdooradventure-wizard' ) {
            ?>
            <div class="notice notice-success notice-content">
                <h2><?php esc_html_e('Welcome! Thank you for choosing Outdoor Adventure. Let’s Set Up Your Website!', 'outdoor-adventure') ?> </h2>
                <p><?php esc_html_e('Before you dive into customization, let’s go through a quick setup process to ensure everything runs smoothly. Click below to start setting up your website in minutes!', 'outdoor-adventure') ?> </p>
                <div class="info-link">
                    <a href="<?php echo esc_url( admin_url( 'themes.php?page=outdooradventure-wizard' ) ); ?>"><?php esc_html_e('Get Started with Outdoor Adventure', 'outdoor-adventure'); ?></a>
                </div>
                <p class="dismiss-link"><strong><a href="?outdoor_adventure_admin_notice=1"><?php esc_html_e( 'Dismiss', 'outdoor-adventure' ); ?></a></strong></p>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'outdoor_adventure_admin_notice' );

if ( ! function_exists( 'outdoor_adventure_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
 */
function outdoor_adventure_update_admin_notice() {
    if ( isset( $_GET['outdoor_adventure_admin_notice'] ) && $_GET['outdoor_adventure_admin_notice'] == '1' ) {
        update_option( 'outdoor_adventure_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'outdoor_adventure_update_admin_notice' );

// After Switch theme function
add_action( 'after_switch_theme', 'outdoor_adventure_getstart_setup_options' );
function outdoor_adventure_getstart_setup_options() {
    update_option( 'outdoor_adventure_admin_notice', false );
}