<?php
/**
 * Custom page walker for this theme.
 *
 * @package Outdoor Adventure
 */

if (!class_exists('Outdoor_Adventure_Walker_Page')) {
    /**
     * CUSTOM PAGE WALKER
     * A custom walker for pages.
     */
    class Outdoor_Adventure_Walker_Page extends Walker_Page
    {

        /**
         * Outputs the beginning of the current element in the tree.
         *
         * @param string $outdoor_adventure_output Used to append additional content. Passed by reference.
         * @param WP_Post $page Page data object.
         * @param int $outdoor_adventure_depth Optional. Depth of page. Used for padding. Default 0.
         * @param array $outdoor_adventure_args Optional. Array of arguments. Default empty array.
         * @param int $current_page Optional. Page ID. Default 0.
         * @since 2.1.0
         *
         * @see Walker::start_el()
         */

        public function start_lvl( &$outdoor_adventure_output, $outdoor_adventure_depth = 0, $outdoor_adventure_args = array() ) {
            $outdoor_adventure_indent  = str_repeat( "\t", $outdoor_adventure_depth );
            $outdoor_adventure_output .= "$outdoor_adventure_indent<ul class='sub-menu'>\n";
        }

        public function start_el(&$outdoor_adventure_output, $page, $outdoor_adventure_depth = 0, $outdoor_adventure_args = array(), $current_page = 0)
        {

            if (isset($outdoor_adventure_args['item_spacing']) && 'preserve' === $outdoor_adventure_args['item_spacing']) {
                $t = "\t";
                $n = "\n";
            } else {
                $t = '';
                $n = '';
            }
            if ($outdoor_adventure_depth) {
                $outdoor_adventure_indent = str_repeat($t, $outdoor_adventure_depth);
            } else {
                $outdoor_adventure_indent = '';
            }

            $outdoor_adventure_css_class = array('page_item', 'page-item-' . $page->ID);

            if (isset($outdoor_adventure_args['pages_with_children'][$page->ID])) {
                $outdoor_adventure_css_class[] = 'page_item_has_children';
            }

            if (!empty($current_page)) {
                $_current_page = get_post($current_page);
                if ($_current_page && in_array($page->ID, $_current_page->ancestors, true)) {
                    $outdoor_adventure_css_class[] = 'current_page_ancestor';
                }
                if ($page->ID === $current_page) {
                    $outdoor_adventure_css_class[] = 'current_page_item';
                } elseif ($_current_page && $page->ID === $_current_page->post_parent) {
                    $outdoor_adventure_css_class[] = 'current_page_parent';
                }
            } elseif (get_option('page_for_posts') === $page->ID) {
                $outdoor_adventure_css_class[] = 'current_page_parent';
            }

            /** This filter is documented in wp-includes/class-walker-page.php */
            $outdoor_adventure_css_classes = implode(' ', apply_filters('page_css_class', $outdoor_adventure_css_class, $page, $outdoor_adventure_depth, $outdoor_adventure_args, $current_page));
            $outdoor_adventure_css_classes = $outdoor_adventure_css_classes ? ' class="' . esc_attr($outdoor_adventure_css_classes) . '"' : '';

            if ('' === $page->post_title) {
                /* translators: %d: ID of a post. */
                $page->post_title = sprintf(__('#%d (no title)', 'outdoor-adventure'), $page->ID);
            }

            $outdoor_adventure_args['link_before'] = empty($outdoor_adventure_args['link_before']) ? '' : $outdoor_adventure_args['link_before'];
            $outdoor_adventure_args['link_after'] = empty($outdoor_adventure_args['link_after']) ? '' : $outdoor_adventure_args['link_after'];

            $outdoor_adventure_atts = array();
            $outdoor_adventure_atts['href'] = get_permalink($page->ID);
            $outdoor_adventure_atts['aria-current'] = ($page->ID === $current_page) ? 'page' : '';

            /** This filter is documented in wp-includes/class-walker-page.php */
            $outdoor_adventure_atts = apply_filters('page_menu_link_attributes', $outdoor_adventure_atts, $page, $outdoor_adventure_depth, $outdoor_adventure_args, $current_page);

            $outdoor_adventure_attributes = '';
            foreach ($outdoor_adventure_atts as $attr => $outdoor_adventure_value) {
                if (!empty($outdoor_adventure_value)) {
                    $outdoor_adventure_value = ('href' === $attr) ? esc_url($outdoor_adventure_value) : esc_attr($outdoor_adventure_value);
                    $outdoor_adventure_attributes .= ' ' . $attr . '="' . $outdoor_adventure_value . '"';
                }
            }

            $outdoor_adventure_args['list_item_before'] = '';
            $outdoor_adventure_args['list_item_after'] = '';
            $outdoor_adventure_args['icon_rennder'] = '';
            // Wrap the link in a div and append a sub menu toggle.
            if (isset($outdoor_adventure_args['show_toggles']) && true === $outdoor_adventure_args['show_toggles']) {
                // Wrap the menu item link contents in a div, used for positioning.
                $outdoor_adventure_args['list_item_after'] = '';
            }


            // Add icons to menu items with children.
            if (isset($outdoor_adventure_args['show_sub_menu_icons']) && true === $outdoor_adventure_args['show_sub_menu_icons']) {
                if (isset($outdoor_adventure_args['pages_with_children'][$page->ID])) {
                    $outdoor_adventure_args['icon_rennder'] = '';
                }
            }

            // Add icons to menu items with children.
            if (isset($outdoor_adventure_args['show_toggles']) && true === $outdoor_adventure_args['show_toggles']) {
                if (isset($outdoor_adventure_args['pages_with_children'][$page->ID])) {

                    $toggle_target_string = '.page_item.page-item-' . $page->ID . ' > .sub-menu';

                    $outdoor_adventure_args['list_item_after'] = '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . __( 'Show sub menu', 'outdoor-adventure' ) . '</span>' . outdoor_adventure_get_theme_svg( 'chevron-down' ) . '</span></button>';
                }
            }

            if (isset($outdoor_adventure_args['show_toggles']) && true === $outdoor_adventure_args['show_toggles']) {

                $outdoor_adventure_output .= $outdoor_adventure_indent . sprintf(
                        '<li%s>%s%s<a%s>%s%s%s</a>%s%s',
                        $outdoor_adventure_css_classes,
                        '<div class="submenu-wrapper">',
                        $outdoor_adventure_args['list_item_before'],
                        $outdoor_adventure_attributes,
                        $outdoor_adventure_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $outdoor_adventure_args['link_after'],
                        $outdoor_adventure_args['list_item_after'],
                        '</div>'
                    );

            }else{

                $outdoor_adventure_output .= $outdoor_adventure_indent . sprintf(
                        '<li%s>%s<a%s>%s%s%s%s</a>%s',
                        $outdoor_adventure_css_classes,
                        $outdoor_adventure_args['list_item_before'],
                        $outdoor_adventure_attributes,
                        $outdoor_adventure_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $outdoor_adventure_args['icon_rennder'],
                        $outdoor_adventure_args['link_after'],
                        $outdoor_adventure_args['list_item_after']
                    );

            }

            if (!empty($outdoor_adventure_args['show_date'])) {
                if ('modified' === $outdoor_adventure_args['show_date']) {
                    $outdoor_adventure_time = $page->post_modified;
                } else {
                    $outdoor_adventure_time = $page->post_date;
                }

                $outdoor_adventure_date_format = empty($outdoor_adventure_args['date_format']) ? '' : $outdoor_adventure_args['date_format'];
                $outdoor_adventure_output .= ' ' . mysql2date($outdoor_adventure_date_format, $outdoor_adventure_time);
            }
        }
    }
}