<?php
/**
 * Body Classes.
 * @package Outdoor Adventure
 */

if (!function_exists('outdoor_adventure_body_classes')) :

    function outdoor_adventure_body_classes($outdoor_adventure_classes)
    {
        $outdoor_adventure_defaults = outdoor_adventure_get_default_theme_options();
        $outdoor_adventure_layout = outdoor_adventure_get_final_sidebar_layout();

        // Adds a class of hfeed to non-singular pages.
        if (!is_singular()) {
            $outdoor_adventure_classes[] = 'hfeed';
        }

        // Sidebar layout logic
        $outdoor_adventure_classes[] = $outdoor_adventure_layout;

        // Copyright alignment
        $copyright_alignment = get_theme_mod('outdoor_adventure_copyright_alignment', 'Default');
        $outdoor_adventure_classes[] = 'copyright-' . strtolower($copyright_alignment);

        return $outdoor_adventure_classes;
    }

endif;

add_filter('body_class', 'outdoor_adventure_body_classes');