<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package nuvio
 * @since 1.0.0
 */

/**
 * Enqueue the CSS files.
 *
 * @since 1.0.0
 *
 * @return void
 */
function nuvio_styles() {
	wp_enqueue_style(
		'nuvio-style',
		get_stylesheet_uri(),
		[],
		wp_get_theme()->get( 'Version' )
	);
}
add_action( 'wp_enqueue_scripts', 'nuvio_styles' );

register_block_style( 'core/group', [
  'name'  => 'card',
  'label' => 'Card',
  'style_handle' => 'nuvio-style-card'
] );

// Register and enqueue the style
add_action( 'init', function() {
	wp_register_style(
		'nuvio-style-card',
		get_template_directory_uri() . '/assets/css/block-style-card.css',
		[], // dependencies
		wp_get_theme()->get( 'Version' )
	);
});

add_action( 'enqueue_block_editor_assets', function() {
	wp_enqueue_style( 'nuvio-style-card' );
});


