<?php
/**
 * Displays footer bottom area
 *
 * @package NotoMag
 */

$enable_footer_nav = notomag_get_option('enable_footer_nav');
?>
<div class="site-footer-area site-info">
    <div class="wrapper">
        <div class="site-info-panel">
            <div class="site-info-title">
                <?php
                get_template_part('template-parts/footer/site-branding-footer');
                ?>
                <?php notomag_get_copyright_text(); ?>

            </div>

            <?php if ($enable_footer_nav) { ?>
                <?php
                wp_nav_menu(
                    array(
                        'theme_location'  => 'footer',
                        'container_class' => 'footer-navigation',
                        'fallback_cb'     => false,
                        'depth'           => 1,
                        'menu_class'      => 'footer-menu reset-list-style',
                    )
                );
                ?>
            <?php } ?>

        </div>
    </div>
</div><!-- .site-info -->