<?php
if (!defined('ABSPATH')) {
    exit;
}

class NotoMag_Multi_Grid_Post extends NotoMag_Widget_Base
{
    /**
     * Sets up a new widget instance.
     *
     * @since 1.0.0
     */
    public function __construct()
    {
        $this->widget_cssclass = 'notomag-multi-grid-post';
        $this->widget_description = __("Shows post in multi grid layout", 'notomag');
        $this->widget_id = 'NotoMag_Multi_Grid_Post';
        $this->widget_name = __('NotoMag: Multi Grid Post', 'notomag');
        $this->settings = $this->get_widget_settings();
        parent::__construct();
    }

    /**
     * Define widget settings.
     */
    protected function get_widget_settings()
    {
        return array(
            'title' => array(
                'type' => 'text',
                'label' => __('Title', 'notomag'),
            ),
            'title_size_1' => array(
                'type' => 'select',
                'label' => __('Font size for Prime Article', 'notomag'),
                'options' => array(
                    'entry-title-medium' => __('Medium', 'notomag'),
                    'entry-title-small' => __('Small', 'notomag'),
                ),
                'std' => 'entry-title-medium',
            ),
            'title_size_2' => array(
                'type' => 'select',
                'label' => __('Font size for Sub Articles', 'notomag'),
                'options' => array(
                    'entry-title-medium' => __('Medium', 'notomag'),
                    'entry-title-small' => __('Small', 'notomag'),
                ),
                'std' => 'entry-title-small',
            ),
            'number' => array(
                'type' => 'number',
                'step' => 1,
                'min' => 2,
                'max' => 12,
                'std' => 5,
                'label' => __('Number of posts to show', 'notomag'),
            ),
            'offset'                  => array(
                'type'  => 'number',
                'step'  => 1,
                'min'   => 0,
                'max'   => '',
                'std'   => '',
                'label' => __( 'Offset', 'notomag' ),
                'desc'  => __( 'Offsets are used to skip a certain number of WordPress posts before starting output. Set it to 0 if you do not wish to use this feature.', 'notomag' ),
            ),
            'image_size' => array(
                'type' => 'select',
                'label' => __('Image size', 'notomag'),
                'options' => array(
                    'entry-image-large' => __('Large', 'notomag'),
                    'entry-image-big' => __('Big', 'notomag'),
                    'entry-image-medium' => __('Medium', 'notomag'),
                    'entry-image-small' => __('Small', 'notomag'),
                ),
                'std' => 'entry-image-large',
            ),
            'show_description' => array(
                'type' => 'checkbox',
                'label' => __('Show Description', 'notomag'),
                'std' => true,
            ),
            'category' => array(
                'type' => 'dropdown-taxonomies',
                'label' => __('Select Category', 'notomag'),
                'desc' => __('Leave empty if you don\'t want the posts to be category specific', 'notomag'),
                'args' => array(
                    'taxonomy' => 'category',
                    'class' => 'widefat',
                    'hierarchical' => true,
                    'show_count' => 1,
                    'show_option_all' => __('&mdash; Select &mdash;', 'notomag'),
                ),
            ),
            'show_category' => array(
                'type' => 'checkbox',
                'label' => __('Show Category', 'notomag'),
                'std' => true,
            ),
            'category_text' => array(
                'type' => 'text',
                'label' => __('Category Text', 'notomag'),
            ),
            'display_category_option' => array(
                'type' => 'select',
                'label' => __('Category Option', 'notomag'),
                'options' => array(
                    'none' => __('None', 'notomag'),
                    'has-background' => __('Has background', 'notomag'),
                    'has-text-color' => __('Has text color', 'notomag'),
                ),
                'std' => 'has-background',
            ),
            'number_of_cat' => array(
                'type' => 'number',
                'step' => 1,
                'min' => 1,
                'std' => 1,
                'label' => __('Number of Category to show', 'notomag'),
            ),
            'show_date' => array(
                'type' => 'checkbox',
                'label' => __('Show Date', 'notomag'),
                'std' => true,
            ),
            'date_format' => array(
                'type' => 'select',
                'label' => __('Date Format', 'notomag'),
                'options' => array(
                    'classic'   => __( 'Classic', 'notomag' ),
                    'time_ago' => __( 'Time Ago', 'notomag' ),
                ),
                'std' => 'classic',
            ),
            'show_author' => array(
                'type' => 'checkbox',
                'label' => __('Show Author', 'notomag'),
                'std' => true,
            ),
            'display_author_option' => array(
                'type' => 'select',
                'label' => __('Author Option', 'notomag'),
                'options' => array(
                    'with_label' => __('With Label', 'notomag'),
                    'with_icon' => __('With Icon', 'notomag'),
                    'with_avatar_image' => __('With Avatar Image', 'notomag'),
                ),
                'std' => 'with_icon',
            ),
            'author_text' => array(
                'type' => 'text',
                'label' => __('Author Text', 'notomag'),
                'std' => __('By:', 'notomag'),
                'desc' => __('This only works when the "With Label" option is selected under "Author Option"', 'notomag'),
            ),
            'style' => array(
                'type' => 'select',
                'label' => __('Style', 'notomag'),
                'options' => array(
                    'style_1' => __('Style 1', 'notomag'),
                    'style_2' => __('Style 2', 'notomag'),
                ),
                'std' => 'style_1',
            ),
        );
    }

    /**
     * Query the posts and return them.
     * @param array $args
     * @param array $instance
     * @return WP_Query
     */
    public function get_posts($args, $instance)
    {
        $number = !empty($instance['number']) ? absint($instance['number']) : $this->settings['number']['std'];
        $query_args = array(
            'posts_per_page' => $number,
            'post_status' => 'publish',
            'no_found_rows' => 1,
            'offset' => !empty($instance['offset']) ? sanitize_text_field($instance['offset']) : $this->settings['offset']['std'],
            'ignore_sticky_posts' => 1
        );

        if ( isset($instance['offset']) && absint($instance['offset']) != 0 ) {
            $query_args['offset'] = absint($instance['offset']);
        }

        if (!empty($instance['category']) && -1 != $instance['category'] && 0 != $instance['category']) {
            $query_args['tax_query'][] = array(
                'taxonomy' => 'category',
                'field' => 'term_id',
                'terms' => $instance['category'],
            );
        }
        return new WP_Query(apply_filters('NotoMag_Multi_Grid_Post_query_args', $query_args));
    }

    /**
     * Output widget.
     *
     * @param array $args
     * @param array $instance
     * @see WP_Widget
     *
     */
    public function widget($args, $instance)
    {
        ob_start();
        $count = 1;
        if (($posts = $this->get_posts($args, $instance)) && $posts->have_posts()) {
            echo $args['before_widget'];
            do_action('notomag_before_simplepost_widget');
            ?>
            <?php if ($instance['title']) : ?>
                <h2 class="widget-title">
                    <?php echo esc_html($instance['title']); ?>
                </h2>
            <?php endif; ?>
            <div class="multi-grid-content <?php echo esc_attr($instance['style']); ?>">
                <?php while ($posts->have_posts()):
                $posts->the_post();
                $category_text = !empty($instance['category_text']) ? $instance['category_text'] : '';
                $display_category_option = !empty($instance['display_category_option']) ? $instance['display_category_option'] : $this->settings['display_category_option']['std'];
                $number_of_cat = !empty($instance['number_of_cat']) ? absint($instance['number_of_cat']) : $this->settings['number_of_cat']['std'];
                $show_author = !empty($instance['show_author']) ? $instance['show_author'] : $this->settings['show_author']['std'];
                $author_text = !empty($instance['author_text']) ? $instance['author_text'] : $this->settings['author_text']['std'];
                $display_author_option = !empty($instance['display_author_option']) ? $instance['display_author_option'] : $this->settings['display_author_option']['std'];
                ?>
                <?php if ($count == 1) { ?>
                <div class="widget-content-prime">
                    <article id="multi-grid-prime-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-post-regular'); ?>>
                        <?php $this->output_prime_content($instance, $category_text, $display_category_option, $number_of_cat, $show_author, $author_text, $display_author_option); ?>
                    </article>
                </div>
                <div class="widget-content-regular">
                    <?php $count++;
                    } else { ?>
                        <article id="multi-grid-regular-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-post-regular'); ?>>
                            <?php $this->output_list_content($instance, $category_text, $display_category_option, $number_of_cat, $show_author, $author_text, $display_author_option); ?>
                        </article>
                    <?php } ?>
                    <?php endwhile;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
            <?php
            do_action('notomag_after_simplepost_widget');
            echo $args['after_widget'];
        }
        echo ob_get_clean();
    }

    /**
     * Output post content.
     *
     * @param array $instance
     */
    private function output_prime_content($instance, $category_text, $display_category_option, $number_of_cat, $show_author, $author_text, $display_author_option)
    {
        ?>
        <?php if (has_post_thumbnail()): ?>
        <div class="entry-image <?php echo esc_attr($instance['image_size']); ?> image-hover-effect hover-effect-shine">
            <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
                <?php
                the_post_thumbnail(
                    'medium_large',
                    array(
                        'alt' => the_title_attribute(
                            array(
                                'echo' => false,
                            )
                        ),
                    )
                );
                ?>
            </a>
        </div>
    <?php endif; ?>
        <div class="entry-details">
            <?php
            if (!empty($instance['show_category']) && $instance['show_category']) {
                notomag_post_category($display_category_option, $category_text, $number_of_cat);
            }
            ?>
            <?php the_title('<h3 class="entry-title ' . $instance['title_size_1'] . '"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
            <div class="entry-meta-wrapper">
                <?php if (!empty($instance['show_date']) && $instance['show_date']) : ?>
                    <div class="entry-meta entry-date posted-on">
                        <span class="screen-reader-text"><?php _e('Post Date', 'notomag'); ?></span>
                        <?php notomag_the_theme_svg('calendar'); ?>
                        <?php
                        $date_format = !empty($instance['date_format']) ? $instance['date_format'] : 'classic';
                            notomag_posted_on($date_format);
                        ?>
                    </div>
                <?php endif; ?>
                <?php if (!empty($instance['show_author']) && $instance['show_author']) : ?>
                    <?php
                    if ($show_author) {
                        notomag_posted_by($display_author_option, $author_text);
                    }
                    ?>
                <?php endif; ?>
            </div>
            <?php
            if ($instance['show_description'] && has_excerpt()): ?>
                <div class="entry-summary limit-line-4">
                    <?php the_excerpt(); ?>
                </div>
            <?php elseif ($instance['show_description']): ?>
                <div class="entry-summary limit-line-4">
                    <?php echo esc_html(wp_trim_words(get_the_content(), 40, '...')); ?>
                </div>
            <?php endif; ?>
        </div>

        <?php
    }

    /**
     * Output post content.
     *
     * @param array $instance
     */
    private function output_list_content($instance, $category_text, $display_category_option, $number_of_cat, $show_author, $author_text, $display_author_option)
    {
        ?>
        <?php if (has_post_thumbnail()): ?>
        <div class="entry-image entry-image-thumbnail image-hover-effect hover-effect-slide">
            <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
                <?php
                the_post_thumbnail(
                    'medium',
                    array(
                        'alt' => the_title_attribute(
                            array(
                                'echo' => false,
                            )
                        ),
                    )
                );
                ?>
            </a>
        </div>
    <?php endif; ?>
        <div class="entry-details">
            <?php
            if (!empty($instance['show_category']) && $instance['show_category']) {
                notomag_post_category($display_category_option, $category_text, $number_of_cat);
            }
            ?>
            <?php the_title('<h3 class="entry-title ' . $instance['title_size_2'] . '"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
            <div class="entry-meta-wrapper">
                <?php if (!empty($instance['show_date']) && $instance['show_date']) : ?>
                    <div class="entry-meta entry-date posted-on">
                        <span class="screen-reader-text"><?php _e('Post Date', 'notomag'); ?></span>
                        <?php notomag_the_theme_svg('calendar'); ?>
                        <?php
                        $date_format = !empty($instance['date_format']) ? $instance['date_format'] : 'classic';
                            notomag_posted_on($date_format);
                        ?>
                    </div>
                <?php endif; ?>
                <?php if (!empty($instance['show_author']) && $instance['show_author']) : ?>
                    <?php
                    if ($show_author) {
                        notomag_posted_by($display_author_option, $author_text);
                    }
                    ?>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}