<?php
/**
 * All settings related to footer recommended post.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
	'split_block',
	array(
		'title' => esc_html__( 'Split Block Section', 'notomag' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[enable_split_block]',
    array(
        'default'           => $notomag_default['enable_split_block'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_split_block]',
    array(
        'label'       => esc_html__( 'Enable Split Block', 'notomag' ),
        'section'     => 'split_block',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
  'notomag_options[split_block_title]',
  array(
      'default' => $notomag_default['split_block_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'notomag_options[split_block_title]',
  array(
      'label' => __('Section Title', 'notomag'),
      'section' => 'split_block',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
    'notomag_options[split_block_category]',
    array(
        'default'           => $notomag_default['split_block_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[split_block_category]',
        array(
            'label'           => __( 'Choose Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'split_block',
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[split_block_offset]',
    array(
        'default' => $notomag_default['split_block_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[split_block_offset]',
    array(
        'label' => __('Post Offset', 'notomag'),
        'section' => 'split_block',
        'type' => 'number',
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_split_block_author_meta]',
    array(
        'default' => $notomag_default['enable_split_block_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_split_block_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'split_block',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_split_block_author_meta]',
    array(
        'default' => $notomag_default['select_split_block_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_split_block_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'split_block',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[split_block_author_meta_title]',
    array(
        'default' => $notomag_default['split_block_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[split_block_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'split_block',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_split_block_date_meta]',
    array(
        'default' => $notomag_default['enable_split_block_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_split_block_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'split_block',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_split_block_date]',
    array(
        'default' => $notomag_default['select_split_block_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_split_block_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'split_block',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_split_block_date_meta_title]',
    array(
        'default' => $notomag_default['select_split_block_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_split_block_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'split_block',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_split_block_date_format]',
    array(
        'default' => $notomag_default['select_split_block_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_split_block_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'split_block',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_split_block_category_meta]',
    array(
        'default' => $notomag_default['enable_split_block_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_split_block_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'split_block',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_split_block_number_of_category]',
    array(
        'default' => $notomag_default['select_split_block_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_split_block_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'split_block',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[split_block_category_label]',
    array(
        'default' => $notomag_default['split_block_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[split_block_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'split_block',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_split_block_category_color]',
    array(
        'default' => $notomag_default['select_split_block_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_split_block_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'split_block',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);