<?php
$wp_customize->add_section(
    'homepage_slider_banner_option',
    array(
        'title' => __('Carousel Banner', 'notomag'),
        'panel' => 'front_page_theme_options_panel',
    )
);

/* Home Page Layout */
$wp_customize->add_setting(
    'notomag_options[enable_slider_banner_section]',
    array(
        'default' => $notomag_default['enable_slider_banner_section'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_slider_banner_section]',
    array(
        'label' => __('Enable Carousel Banner Section', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[title_slider_banner_section]',
    array(
        'default'           => $notomag_default['title_slider_banner_section'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[title_slider_banner_section]',
    array(
        'label'    => __( 'Section Title', 'notomag' ),
        'section'  => 'homepage_slider_banner_option',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[number_of_slider_post]',
    array(
        'default' => $notomag_default['number_of_slider_post'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[number_of_slider_post]',
    array(
        'label' => __('Post In Slider', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => array(
            '3' => __('3', 'notomag'),
            '4' => __('4', 'notomag'),
            '5' => __('5', 'notomag'),
            '6' => __('6', 'notomag'),
        ),
    )
);


$wp_customize->add_setting(
    'notomag_options[banner_section_cat]',
    array(
        'default'           => $notomag_default['banner_section_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[banner_section_cat]',
        array(
            'label'           => __( 'Choose  Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'homepage_slider_banner_option',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[slider_banner_offset]',
    array(
        'default' => $notomag_default['slider_banner_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[slider_banner_offset]',
    array(
        'label' => __('Slider Post Offset', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_banner_post_description]',
    array(
        'default' => $notomag_default['enable_banner_post_description'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_post_description]',
    array(
        'label' => __('Enable Post Description', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_banner_overlay]',
    array(
        'default' => $notomag_default['enable_banner_overlay'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_overlay]',
    array(
        'label' => __('Enable Banner Overlay', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[slider_post_content_alignment]',
    array(
        'default' => $notomag_default['slider_post_content_alignment'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[slider_post_content_alignment]',
    array(
        'label' => __('Content Vertical Alignment', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => array(
            'banner-description-top' => __('Vertical alignment top', 'notomag'),
            'banner-description-space' => __('Vertical alignment space between', 'notomag'),
            'banner-description-bottom' => __('Vertical alignment bottom', 'notomag'),
        ),
    )
);

$wp_customize->add_setting(
    'notomag_section_seperator_banner',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_banner',
        array(
            'label'         => esc_html__( 'Banner Slider Meta', 'notomag' ),
            'settings' => 'notomag_section_seperator_banner',
            'section' => 'homepage_slider_banner_option',
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_banner_slider_author_meta]',
    array(
        'default' => $notomag_default['enable_banner_slider_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_slider_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_slider_author_meta]',
    array(
        'default' => $notomag_default['select_banner_slider_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_slider_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[banner_slider_author_meta_title]',
    array(
        'default' => $notomag_default['banner_slider_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[banner_slider_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_banner_slider_date_meta]',
    array(
        'default' => $notomag_default['enable_banner_slider_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_slider_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_slider_date]',
    array(
        'default' => $notomag_default['select_banner_slider_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_slider_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_slider_date_meta_title]',
    array(
        'default' => $notomag_default['select_banner_slider_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_slider_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_slider_date_format]',
    array(
        'default' => $notomag_default['select_banner_slider_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_slider_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_banner_slider_category_meta]',
    array(
        'default' => $notomag_default['enable_banner_slider_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_slider_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_banner_slider_number_of_category]',
    array(
        'default' => $notomag_default['select_banner_slider_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_slider_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[banner_slider_category_label]',
    array(
        'default' => $notomag_default['banner_slider_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[banner_slider_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_banner_slider_category_color]',
    array(
        'default' => $notomag_default['select_banner_slider_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_banner_slider_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);

/* Home Page Layout */
$wp_customize->add_setting(
    'notomag_options[enable_banner_control_icon]',
    array(
        'default' => $notomag_default['enable_banner_control_icon'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_banner_control_icon]',
    array(
        'label' => __('Enable Slider Control', 'notomag'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);