<?php
/**
 * All settings related to single.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
	'single_options',
	array(
		'title' => esc_html__( 'Single Page Options', 'notomag' ),
		'panel' => 'single_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[enable_single_author_meta]',
    array(
        'default'           => $notomag_default['enable_single_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_single_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_single_author_meta]',
    array(
        'default'           => $notomag_default['select_single_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_single_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'select',
        'choices'       => notomag_author_meta(),


    )
);

$wp_customize->add_setting(
    'notomag_options[single_author_meta_title]',
    array(
        'default'           => $notomag_default['single_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[single_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'notomag' ),
        'section'  => 'single_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_single_date_meta]',
    array(
        'default'           => $notomag_default['enable_single_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_single_date_meta]',
    array(
        'label'       => esc_html__( 'Display Published Date', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_single_date]',
    array(
        'default'           => $notomag_default['select_single_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_single_date]',
    array(
        'label'         => esc_html__( 'Select Date Meta', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'select',
        'choices'       => notomag_date_meta(),

    )
);

$wp_customize->add_setting(
    'notomag_options[single_date_meta_title]',
    array(
        'default'           => $notomag_default['single_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[single_date_meta_title]',
    array(
        'label'    => __( 'Date Meta Text', 'notomag' ),
        'section'  => 'single_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_single_date_format]',
    array(
        'default'           => $notomag_default['select_single_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_single_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'select',
        'choices'  		=> notomag_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_single_category_meta]',
    array(
        'default'           => $notomag_default['enable_single_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_single_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Single Category Meta', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[single_category_label]',
    array(
        'default'           => $notomag_default['single_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[single_category_label]',
    array(
        'label'    => __( 'Category Title', 'notomag' ),
        'section'  => 'single_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_single_category_color]',
    array(
        'default'           => $notomag_default['select_single_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_single_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'select',
        'choices'  		=> notomag_category_color(),

    )
);

$wp_customize->add_setting(
    'notomag_options[enable_single_tag_meta]',
    array(
        'default'           => $notomag_default['enable_single_tag_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_single_tag_meta]',
    array(
        'label'       => esc_html__( 'Enable Tag Meta', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_single_read_time_meta]',
    array(
        'default'           => $notomag_default['enable_single_read_time_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_single_read_time_meta]',
    array(
        'label'       => esc_html__( 'Enable Read Time', 'notomag' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);



$wp_customize->add_setting(
    'notomag_section_seperator_single_5',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_single_5',
        array(
            'settings' => 'notomag_section_seperator_single_5',
            'section'       => 'single_options',
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[show_sticky_article_navigation]',
    array(
        'default'           => $notomag_default['show_sticky_article_navigation'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[show_sticky_article_navigation]',
    array(
        'label'    => __( 'Show Sticky Article Navigation', 'notomag' ),
        'section'  => 'single_options',
        'type'     => 'checkbox',
    )
);

/*Show Author Info Box start
*-------------------------------*/
$wp_customize->add_setting(
    'notomag_section_seperator_single_2',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_single_2',
        array(
            'settings' => 'notomag_section_seperator_single_2',
            'section'       => 'single_options',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[show_author_info]',
    array(
        'default'           => $notomag_default['show_author_info'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[show_author_info]',
    array(
        'label'    => __( 'Show Author Info Box', 'notomag' ),
        'section'  => 'single_options',
        'type'     => 'checkbox',
    )
);


$wp_customize->add_section(
    'single_sidebar_options',
    array(
        'title' => esc_html__( 'SideBar Options', 'notomag' ),
        'panel' => 'single_options_panel',
    )
);


$wp_customize->add_setting(
    'single_sidebar_layout_option',
    array(
        'default'           => $notomag_default['single_sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'notomag_sanitize_radio'
    )
);

$wp_customize->add_control(
    new NotoMag_Custom_Radio_Image_Control(
        $wp_customize,
        'single_sidebar_layout_option',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (Single)', 'notomag' ),
            'section'       => 'single_sidebar_options',
            'choices'       => notomag_get_sidebar_layouts(),
        )
    )
);




$wp_customize->add_setting(
    'notomag_options[enable_sidebar_fix_single]',
    array(
        'default'           => $notomag_default['enable_sidebar_fix_single'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_sidebar_fix_single]',
    array(
        'label'    => __( 'Enable Sticky Sidebar', 'notomag' ),
        'section'     => 'single_options_panel',
        'type'        => 'checkbox',
    )
);